/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import se.vandmo.dependencylock.maven.LockableEntity;

public final class DependencySetConfiguration {
    private final ArtifactFilter includes;
    private final ArtifactFilter excludes;
    public final Version version;
    public final Integrity integrity;
    public final Boolean allowMissing;
    public final Boolean allowSuperfluous;

    public DependencySetConfiguration(ArtifactFilter includes, ArtifactFilter excludes, Version version, Integrity integrity, Boolean allowMissing, Boolean allowSuperfluous) {
        this.includes = includes;
        this.excludes = excludes;
        this.version = version;
        this.integrity = integrity;
        this.allowMissing = allowMissing;
        this.allowSuperfluous = allowSuperfluous;
    }

    public boolean matches(LockableEntity<?> entity) {
        Artifact mavenArtifact = entity.getMavenArtifact();
        return this.includes.include(mavenArtifact) && !this.excludes.include(mavenArtifact);
    }

    public static enum Integrity {
        check,
        ignore;

    }

    public static enum Version {
        check,
        useProjectVersion,
        snapshot,
        ignore;

    }
}

