/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.apache.maven.plugin.logging.Log;
import se.vandmo.dependencylock.maven.DependencySetConfiguration;
import se.vandmo.dependencylock.maven.Filters;
import se.vandmo.dependencylock.maven.LockableEntities;
import se.vandmo.dependencylock.maven.LockableEntity;
import se.vandmo.dependencylock.maven.VersionUtils;

final class DiffHelper {
    private final Log log;

    DiffHelper(Log log) {
        this.log = log;
    }

    <T extends LockableEntity<T>> List<String> diffIntegrity(T lockedEntity, T actualEntity, Filters filters) {
        if (lockedEntity.getIntegrity().equals(actualEntity.getIntegrity())) {
            return Collections.emptyList();
        }
        DependencySetConfiguration.Integrity integrityConfiguration = filters.integrityConfiguration(lockedEntity);
        switch (integrityConfiguration) {
            case check: {
                return Arrays.asList("integrity");
            }
            case ignore: {
                this.log.info((CharSequence)String.format(Locale.ROOT, "Ignoring integrity for %s", lockedEntity));
                return Collections.emptyList();
            }
        }
        throw new RuntimeException("Unsupported enum value");
    }

    <T extends LockableEntity<T>> List<String> findExtraneous(LockableEntities<T> entities, LockableEntities<T> lockedEntities, Filters filters) {
        ArrayList<String> extraneous = new ArrayList<String>();
        for (LockableEntity entity : entities) {
            if (lockedEntities.by(entity.getArtifactIdentifier()).isPresent()) continue;
            if (filters.allowSuperfluous(entity)) {
                this.log.info((CharSequence)String.format(Locale.ROOT, "Ignoring extraneous %s", entity.getArtifactIdentifier()));
                continue;
            }
            extraneous.add(entity.toString_withoutIntegrity());
        }
        return extraneous;
    }

    <EntityType extends LockableEntity<EntityType>> List<String> diffVersion(AtomicReference<EntityType> lockedEntityRef, EntityType actualEntity, BiFunction<EntityType, String, EntityType> versionUpdater, Filters filters) {
        LockableEntity lockedDependency = (LockableEntity)lockedEntityRef.get();
        Filters.VersionConfiguration versionConfiguration = filters.versionConfiguration(lockedDependency);
        switch (versionConfiguration.type) {
            case check: {
                if (lockedDependency.getVersion().equals(actualEntity.getVersion())) {
                    return Collections.emptyList();
                }
                return Collections.singletonList("version");
            }
            case useProjectVersion: {
                this.log.info((CharSequence)String.format(Locale.ROOT, "Using project version for %s", lockedDependency));
                lockedEntityRef.set(versionUpdater.apply(lockedDependency, versionConfiguration.projectVersion));
                if (versionConfiguration.projectVersion.equals(actualEntity.getVersion())) {
                    return Collections.emptyList();
                }
                return Collections.singletonList("version (expected project version)");
            }
            case snapshot: {
                this.log.info((CharSequence)String.format(Locale.ROOT, "Allowing snapshot version for %s", lockedDependency));
                if (VersionUtils.snapshotMatch(lockedDependency.getVersion(), actualEntity.getVersion())) {
                    return Collections.emptyList();
                }
                return Collections.singletonList("version (allowing snapshot version)");
            }
            case ignore: {
                this.log.info((CharSequence)String.format(Locale.ROOT, "Ignoring version for %s", lockedDependency));
                return Collections.emptyList();
            }
        }
        throw new RuntimeException("Unsupported enum value");
    }
}

