/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.List;
import java.util.stream.Stream;

public final class DiffReport {
    private final List<String> missing;
    private final List<String> different;
    private final List<String> extraneous;

    DiffReport(List<String> different, List<String> missing, List<String> extraneous) {
        this.different = different;
        this.missing = missing;
        this.extraneous = extraneous;
    }

    public boolean equals() {
        return this.missing.isEmpty() && this.different.isEmpty() && this.extraneous.isEmpty();
    }

    public Stream<String> report(String category) {
        Stream<String> result = Stream.empty();
        if (!this.missing.isEmpty()) {
            result = Stream.concat(result, Stream.concat(Stream.of("Missing " + category + ":"), this.missing.stream().map(line -> "  " + line)));
        }
        if (!this.extraneous.isEmpty()) {
            result = Stream.concat(result, Stream.concat(Stream.of("Extraneous " + category + ":"), this.extraneous.stream().map(line -> "  " + line)));
        }
        if (!this.different.isEmpty()) {
            result = Stream.concat(result, Stream.concat(Stream.of("The following " + category + " differ:"), this.different.stream().map(line -> "  " + line)));
        }
        return result;
    }
}

