/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.Objects;
import org.apache.maven.plugin.ExtensionRealmCache;
import se.vandmo.dependencylock.maven.Artifact;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;
import se.vandmo.dependencylock.maven.Integrity;
import se.vandmo.dependencylock.maven.LockableEntityWithArtifact;

public final class Extension
extends LockableEntityWithArtifact<Extension> {
    public static ArtifactIdentifierBuilderStage builder() {
        return new ArtifactIdentifierBuilderStage();
    }

    public static Extension of(Artifact dependency) {
        return new Extension(dependency);
    }

    public static Extension fromMavenExtensionRealm(ExtensionRealmCache.CacheRecord extensionRealm) {
        return new Extension(Artifact.from((org.apache.maven.artifact.Artifact)extensionRealm.getArtifacts().get(0)));
    }

    @Override
    public Extension withIntegrity(Integrity integrity) {
        return new Extension(this.artifact.withIntegrity(integrity));
    }

    private Extension(Artifact artifact) {
        super(artifact);
    }

    @Override
    public Extension withVersion(String version) {
        return new Extension(this.artifact.withVersion(version));
    }

    public static final class FinalBuilderStage {
        private final Artifact artifact;

        private FinalBuilderStage(Artifact artifact) {
            this.artifact = artifact;
        }

        public Extension build() {
            return new Extension(this.artifact);
        }
    }

    public static final class IntegrityBuilderStage {
        private final Artifact.IntegrityBuilderStage artifactBuilder;

        private IntegrityBuilderStage(Artifact.IntegrityBuilderStage artifactBuilder) {
            this.artifactBuilder = artifactBuilder;
        }

        public FinalBuilderStage integrity(String integrity) {
            return new FinalBuilderStage(this.artifactBuilder.integrity(integrity).build());
        }
    }

    public static final class VersionBuilderStage {
        private final Artifact.VersionBuilderStage artifactBuilder;

        private VersionBuilderStage(Artifact.VersionBuilderStage artifactBuilder) {
            this.artifactBuilder = Objects.requireNonNull(artifactBuilder);
        }

        public IntegrityBuilderStage version(String version) {
            return new IntegrityBuilderStage(this.artifactBuilder.version(version));
        }
    }

    public static final class ArtifactIdentifierBuilderStage {
        private ArtifactIdentifierBuilderStage() {
        }

        public VersionBuilderStage artifactIdentifier(ArtifactIdentifier artifactIdentifier) {
            return new VersionBuilderStage(Artifact.builder().artifactIdentifier(artifactIdentifier));
        }
    }
}

