/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import se.vandmo.dependencylock.maven.DependencySetConfiguration;
import se.vandmo.dependencylock.maven.LockableEntity;

public final class Filters {
    private final List<DependencySetConfiguration> dependencySetConfigurations;
    private final String projectVersion;

    public Filters(List<DependencySetConfiguration> dependencySets, String projectVersion) {
        ArrayList<DependencySetConfiguration> dependencySetConfigurations = new ArrayList<DependencySetConfiguration>(dependencySets);
        Collections.reverse(dependencySetConfigurations);
        this.dependencySetConfigurations = Collections.unmodifiableList(dependencySetConfigurations);
        this.projectVersion = Objects.requireNonNull(projectVersion);
    }

    private <T> T configurationFor(LockableEntity<?> entity, Function<DependencySetConfiguration, T> extractor, T defaultValue) {
        return (T)this.dependencySetConfigurations.stream().filter(d -> d.matches(entity)).map(extractor).filter(v -> v != null).findFirst().orElse(defaultValue);
    }

    public VersionConfiguration versionConfiguration(LockableEntity<?> entity) {
        DependencySetConfiguration.Version type = this.configurationFor(entity, d -> d.version, DependencySetConfiguration.Version.check);
        return new VersionConfiguration(type, this.projectVersion);
    }

    public DependencySetConfiguration.Integrity integrityConfiguration(LockableEntity<?> entity) {
        return this.configurationFor(entity, d -> d.integrity, DependencySetConfiguration.Integrity.check);
    }

    public boolean allowSuperfluous(LockableEntity<?> entity) {
        return this.configurationFor(entity, d -> d.allowSuperfluous, Boolean.FALSE);
    }

    public boolean allowMissing(LockableEntity<?> entity) {
        return this.configurationFor(entity, d -> d.allowMissing, Boolean.FALSE);
    }

    public static final class VersionConfiguration {
        public final DependencySetConfiguration.Version type;
        public final String projectVersion;

        private VersionConfiguration(DependencySetConfiguration.Version type, String projectVersion) {
            this.type = type;
            this.projectVersion = projectVersion;
        }
    }
}

