/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public final class LockFileAccessor {
    public final File file;

    private LockFileAccessor(File file) {
        this.file = file;
    }

    public static LockFileAccessor fromBasedir(File basedir, String filename) {
        return new LockFileAccessor(new File(basedir, filename));
    }

    public Reader reader() {
        return LockFileAccessor.readerFor(this.file);
    }

    private static Reader readerFor(File file) {
        try {
            return new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    public File sibling(String firstChild, String ... rest) {
        File childFile = new File(this.file.getParentFile(), firstChild);
        for (String child : rest) {
            childFile = new File(childFile, child);
        }
        return childFile;
    }

    private static Writer writerFor(File file) {
        file.getParentFile().mkdirs();
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Writer writer() {
        return LockFileAccessor.writerFor(this.file);
    }

    public Writer writer(String firstChild, String ... rest) {
        File childFile = new File(this.file.getParentFile(), firstChild);
        for (String child : rest) {
            childFile = new File(childFile, child);
        }
        return LockFileAccessor.writerFor(childFile);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String filename() {
        return this.file.getAbsolutePath();
    }
}

