/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;
import se.vandmo.dependencylock.maven.LockableEntity;

public class LockableEntities<Type extends LockableEntity<Type>>
implements Iterable<Type> {
    private final List<Type> entities;

    LockableEntities(Collection<Type> contents, boolean sort) {
        ArrayList<Type> copy = new ArrayList<Type>(contents);
        if (sort) {
            copy.sort(new Comparator<Type>(){

                @Override
                public int compare(Type o1, Type o2) {
                    return ((LockableEntity)o1).getArtifactIdentifier().compareTo(((LockableEntity)o2).getArtifactIdentifier());
                }
            });
        }
        this.entities = Collections.unmodifiableList(copy);
    }

    public final Optional<Type> by(ArtifactIdentifier identifier) {
        for (LockableEntity entity : this.entities) {
            if (!identifier.equals(entity.getArtifactIdentifier())) continue;
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    @Override
    public final Iterator<Type> iterator() {
        return this.entities.iterator();
    }

    public final Stream<Type> stream() {
        return this.entities.stream();
    }

    public final int size() {
        return this.entities.size();
    }
}

