/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.Objects;
import se.vandmo.dependencylock.maven.Artifact;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;
import se.vandmo.dependencylock.maven.Integrity;
import se.vandmo.dependencylock.maven.LockableEntity;
import se.vandmo.dependencylock.maven.MavenArtifact;

public abstract class LockableEntityWithArtifact<T extends LockableEntityWithArtifact<T>>
extends LockableEntity<T> {
    final Artifact artifact;
    private org.apache.maven.artifact.Artifact mavenArtifact;

    LockableEntityWithArtifact(Artifact artifact) {
        this.artifact = Objects.requireNonNull(artifact);
    }

    @Override
    public abstract T withIntegrity(Integrity var1);

    @Override
    public abstract T withVersion(String var1);

    @Override
    public final Integrity getIntegrity() {
        return this.artifact.integrity;
    }

    @Override
    public final String getVersion() {
        return this.artifact.version;
    }

    @Override
    public final String getArtifactKey() {
        return this.artifact.getArtifactKey();
    }

    @Override
    public final ArtifactIdentifier getArtifactIdentifier() {
        return this.artifact.identifier;
    }

    @Override
    public String toString_withoutIntegrity() {
        return this.artifact.toString_withoutIntegrity();
    }

    @Override
    public final org.apache.maven.artifact.Artifact getMavenArtifact() {
        org.apache.maven.artifact.Artifact result = this.mavenArtifact;
        if (null == result) {
            this.mavenArtifact = result = this.toMavenArtifact();
        }
        return result;
    }

    org.apache.maven.artifact.Artifact toMavenArtifact() {
        return MavenArtifact.unscoped(this.artifact);
    }

    @Override
    public final String getIntegrityForLockFile() {
        return this.artifact.getIntegrityForLockFile();
    }

    protected StringBuilder toStringBuilder_withoutIntegrity() {
        return this.artifact.toStringBuilder_withoutIntegrity();
    }

    public String toString() {
        return this.toStringBuilder_withoutIntegrity().append('@').append(this.artifact.integrity.matching().Calculated(calculated -> calculated.checksum).Folder(folder -> "<Folder>").Ignored(ignored -> "<Ignored>").get()).toString();
    }
}

