/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.plugin.logging.Log;
import se.vandmo.dependencylock.maven.Dependencies;
import se.vandmo.dependencylock.maven.Dependency;
import se.vandmo.dependencylock.maven.DiffReport;
import se.vandmo.dependencylock.maven.Filters;
import se.vandmo.dependencylock.maven.LockedEntities;

public final class LockedDependencies
extends LockedEntities<Dependency> {
    private LockedDependencies(Dependencies lockedDependencies, Log log) {
        super(lockedDependencies, log);
    }

    public static LockedDependencies from(Dependencies artifacts, Log log) {
        return new LockedDependencies(Objects.requireNonNull(artifacts), log);
    }

    public Diff compareWith(Dependencies dependencies, Filters filters) {
        return new Diff(super.compareWith(dependencies, filters));
    }

    @Override
    List<String> findDiffs(AtomicReference<Dependency> lockedDependencyRef, Dependency actualDependency, Filters filters) {
        ArrayList<String> wrongs = new ArrayList<String>();
        wrongs.addAll(this.diffOptional(lockedDependencyRef.get(), actualDependency));
        wrongs.addAll(this.diffScope(lockedDependencyRef.get(), actualDependency));
        wrongs.addAll(this.diffIntegrity(lockedDependencyRef, actualDependency, filters));
        wrongs.addAll(this.diffVersion(lockedDependencyRef, actualDependency, Dependency::withVersion, filters));
        return wrongs;
    }

    private List<String> diffOptional(Dependency lockedDependency, Dependency actualDependency) {
        if (lockedDependency.optional == actualDependency.optional) {
            return Collections.emptyList();
        }
        return Collections.singletonList("optional");
    }

    private List<String> diffScope(Dependency lockedDependency, Dependency actualDependency) {
        if (lockedDependency.scope.equals(actualDependency.scope)) {
            return Collections.emptyList();
        }
        return Collections.singletonList("scope");
    }

    public static final class Diff {
        private final DiffReport diffReport;

        Diff(DiffReport diffReport) {
            this.diffReport = diffReport;
        }

        public DiffReport getReport() {
            return this.diffReport;
        }

        public boolean equals() {
            return this.diffReport.equals();
        }

        public void logTo(Log log) {
            this.diffReport.report("dependencies").forEach(arg_0 -> ((Log)log).error(arg_0));
        }
    }
}

