/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.plugin.logging.Log;
import se.vandmo.dependencylock.maven.AbstractLockedEntries;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;
import se.vandmo.dependencylock.maven.DiffReport;
import se.vandmo.dependencylock.maven.Filters;
import se.vandmo.dependencylock.maven.LockableEntities;
import se.vandmo.dependencylock.maven.LockableEntity;

public class LockedEntities<EntityType extends LockableEntity<EntityType>>
extends AbstractLockedEntries<EntityType> {
    public final LockableEntities<EntityType> lockedEntities;

    LockedEntities(LockableEntities<EntityType> lockedEntities, Log log) {
        super(log);
        this.lockedEntities = Objects.requireNonNull(lockedEntities);
    }

    final DiffReport compareWith(LockableEntities<EntityType> actualEntities, Filters filters) {
        ArrayList<String> missing = new ArrayList<String>();
        ArrayList<String> different = new ArrayList<String>();
        this.collectDiff(actualEntities, filters, different, missing);
        List<String> extraneous = this.diffHelper.findExtraneous(actualEntities, this.lockedEntities, filters);
        return new DiffReport(different, missing, extraneous);
    }

    private void collectDiff(LockableEntities<EntityType> actualEntities, Filters filters, List<String> different, List<String> missing) {
        for (LockableEntity lockedEntity : this.lockedEntities) {
            ArtifactIdentifier identifier = lockedEntity.getArtifactIdentifier();
            Optional<EntityType> possiblyOtherEntity = actualEntities.by(identifier);
            if (!possiblyOtherEntity.isPresent()) {
                if (filters.allowMissing(lockedEntity)) {
                    this.log.info((CharSequence)String.format(Locale.ROOT, "Ignoring missing %s", identifier));
                    continue;
                }
                missing.add(identifier.toString());
                continue;
            }
            AtomicReference<LockableEntity> lockedEntityRef = new AtomicReference<LockableEntity>(lockedEntity);
            LockableEntity actualEntity = (LockableEntity)possiblyOtherEntity.get();
            List<String> wrongs = this.findDiffs(lockedEntityRef, actualEntity, filters);
            if (wrongs.isEmpty()) continue;
            different.add(this.formatDifference(lockedEntityRef.get(), actualEntity, wrongs));
        }
    }
}

