/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.plugin.logging.Log;
import se.vandmo.dependencylock.maven.AbstractLockedEntries;
import se.vandmo.dependencylock.maven.Artifact;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;
import se.vandmo.dependencylock.maven.DiffReport;
import se.vandmo.dependencylock.maven.Filters;
import se.vandmo.dependencylock.maven.Parents;

public final class LockedParents
extends AbstractLockedEntries<Artifact> {
    private final Parents parents;

    private LockedParents(Parents parents, Log log) {
        super(log);
        this.parents = parents;
    }

    public static LockedParents from(Parents artifacts, Log log) {
        return new LockedParents(Objects.requireNonNull(artifacts), log);
    }

    public DiffReport compareWith(Parents actualEntities, Filters filters) {
        ArrayList<String> missing = new ArrayList<String>();
        ArrayList<String> different = new ArrayList<String>();
        ArrayList<String> extraneous = new ArrayList<String>();
        Iterator lockedEntitiesIterator = this.parents.stream().map(parent -> parent.artifact).iterator();
        Iterator actualEntitiesIterator = actualEntities.stream().map(parent -> parent.artifact).iterator();
        if (!lockedEntitiesIterator.hasNext()) {
            actualEntitiesIterator.forEachRemaining(artifact -> extraneous.add(artifact.toString_withoutIntegrity()));
        }
        if (!actualEntitiesIterator.hasNext()) {
            lockedEntitiesIterator.forEachRemaining(artifact -> missing.add(artifact.toString_withoutIntegrity()));
            return new DiffReport(missing, different, extraneous);
        }
        while (lockedEntitiesIterator.hasNext() && actualEntitiesIterator.hasNext()) {
            Artifact actual;
            Artifact currentLocked = (Artifact)lockedEntitiesIterator.next();
            AtomicReference<Artifact> lockedEntityRef = new AtomicReference<Artifact>(currentLocked);
            List<String> wrongs = this.findDiffs(lockedEntityRef, actual = (Artifact)actualEntitiesIterator.next(), filters);
            if (wrongs.isEmpty()) continue;
            different.add(this.formatDifference(currentLocked, actual, wrongs));
        }
        while (lockedEntitiesIterator.hasNext()) {
            missing.add(((Artifact)lockedEntitiesIterator.next()).toString_withoutIntegrity());
        }
        while (actualEntitiesIterator.hasNext()) {
            extraneous.add(((Artifact)actualEntitiesIterator.next()).toString_withoutIntegrity());
        }
        return new DiffReport(different, missing, extraneous);
    }

    @Override
    List<String> findDiffs(AtomicReference<Artifact> lockedArtifactRef, Artifact actualArtifact, Filters filters) {
        List<String> wrongs = super.findDiffs(lockedArtifactRef, actualArtifact, filters);
        ArtifactIdentifier expectedArtifactIdentifier = lockedArtifactRef.get().getArtifactIdentifier();
        ArtifactIdentifier actualArtifactArtifactIdentifier = actualArtifact.getArtifactIdentifier();
        if (!expectedArtifactIdentifier.groupId.equals(actualArtifactArtifactIdentifier.groupId)) {
            wrongs.add("groupId");
        }
        if (!expectedArtifactIdentifier.artifactId.equals(actualArtifactArtifactIdentifier.artifactId)) {
            wrongs.add("artifactId");
        }
        wrongs.addAll(this.diffVersion(lockedArtifactRef, actualArtifact, Artifact::withVersion, filters));
        return wrongs;
    }
}

