/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.plugin.logging.Log;
import se.vandmo.dependencylock.maven.DiffReport;
import se.vandmo.dependencylock.maven.Filters;
import se.vandmo.dependencylock.maven.LockedArtifacts;
import se.vandmo.dependencylock.maven.LockedEntities;
import se.vandmo.dependencylock.maven.Plugin;
import se.vandmo.dependencylock.maven.Plugins;

public final class LockedPlugins
extends LockedEntities<Plugin> {
    private LockedPlugins(Plugins lockedPlugins, Log log) {
        super(lockedPlugins, log);
    }

    public static LockedPlugins from(Plugins plugins, Log log) {
        return new LockedPlugins(Objects.requireNonNull(plugins), log);
    }

    public DiffReport compareWith(Plugins plugins, Filters filters) {
        return super.compareWith(plugins, filters);
    }

    @Override
    List<String> findDiffs(AtomicReference<Plugin> lockedPluginRef, Plugin actualPlugin, Filters filters) {
        List<String> wrongs = super.findDiffs(lockedPluginRef, actualPlugin, filters);
        wrongs.addAll(this.diffVersion(lockedPluginRef, actualPlugin, Plugin::withVersion, filters));
        LockedArtifacts lockedArtifacts = LockedArtifacts.from(lockedPluginRef.get().dependencies, this.log);
        DiffReport diff = lockedArtifacts.compareWith(actualPlugin.dependencies, filters);
        if (!diff.equals()) {
            diff.report("dependencies for " + lockedPluginRef.get().toString_withoutIntegrity()).forEach(arg_0 -> ((Log)this.log).error(arg_0));
            wrongs.add("dependencies");
        }
        return wrongs;
    }
}

