/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;
import se.vandmo.dependencylock.maven.Dependencies;
import se.vandmo.dependencylock.maven.DiffReport;
import se.vandmo.dependencylock.maven.Extensions;
import se.vandmo.dependencylock.maven.Filters;
import se.vandmo.dependencylock.maven.LockedDependencies;
import se.vandmo.dependencylock.maven.LockedExtensions;
import se.vandmo.dependencylock.maven.LockedParents;
import se.vandmo.dependencylock.maven.LockedPlugins;
import se.vandmo.dependencylock.maven.Parents;
import se.vandmo.dependencylock.maven.Plugins;
import se.vandmo.dependencylock.maven.Project;

public final class LockedProject {
    public final Dependencies dependencies;
    public final Optional<Parents> parents;
    public final Optional<Plugins> plugins;
    public final Optional<Extensions> extensions;
    private final Log log;

    private LockedProject(Dependencies dependencies, Optional<Parents> parents, Optional<Plugins> plugins, Optional<Extensions> extensions, Log log) {
        this.parents = parents;
        this.dependencies = dependencies;
        this.plugins = plugins;
        this.extensions = extensions;
        this.log = log;
    }

    public static LockedProject from(Project project, Log log) {
        return new LockedProject(project.dependencies, project.parents, project.plugins, project.extensions, log);
    }

    public static LockedProject from(Dependencies dependencies, Optional<Parents> parents, Optional<Plugins> plugins, Optional<Extensions> extensions, Log log) {
        return new LockedProject(Objects.requireNonNull(dependencies), Objects.requireNonNull(parents), Objects.requireNonNull(plugins), Objects.requireNonNull(extensions), log);
    }

    public static LockedProject from(Dependencies dependencies, Log log) {
        return new LockedProject(Objects.requireNonNull(dependencies), Optional.empty(), Optional.empty(), Optional.empty(), log);
    }

    public Diff compareWith(Project project, Filters filters) {
        DiffReport dependenciesDiff = LockedDependencies.from(this.dependencies, this.log).compareWith(project.dependencies, filters).getReport();
        return new Diff(dependenciesDiff, project.parents.map(parents -> LockedParents.from(parents, this.log).compareWith(this.parents.get(), filters)), project.plugins.map(plugins -> LockedPlugins.from(plugins, this.log).compareWith(this.plugins.get(), filters)), project.extensions.map(extensions -> LockedExtensions.from(extensions, this.log).compareWith(this.extensions.get(), filters)));
    }

    public static final class Diff {
        private final DiffReport dependenciesDiff;
        private final Optional<DiffReport> parentsDiff;
        private final Optional<DiffReport> pluginsDiff;
        private final Optional<DiffReport> extensionsDiff;

        Diff(DiffReport dependenciesDiff) {
            this(dependenciesDiff, Optional.empty(), Optional.empty(), Optional.empty());
        }

        public Diff(DiffReport dependenciesDiff, Optional<DiffReport> parentsDiff, Optional<DiffReport> pluginsDiff, Optional<DiffReport> extensionsDiff) {
            this.dependenciesDiff = Objects.requireNonNull(dependenciesDiff);
            this.parentsDiff = Objects.requireNonNull(parentsDiff);
            this.pluginsDiff = Objects.requireNonNull(pluginsDiff);
            this.extensionsDiff = Objects.requireNonNull(extensionsDiff);
        }

        public boolean equals() {
            if (!this.dependenciesDiff.equals()) {
                return false;
            }
            if (this.parentsDiff.isPresent() && !this.parentsDiff.get().equals()) {
                return false;
            }
            if (this.pluginsDiff.isPresent() && !this.pluginsDiff.get().equals()) {
                return false;
            }
            return !this.extensionsDiff.isPresent() || this.extensionsDiff.get().equals();
        }

        public Stream<String> report() {
            return Stream.of(Optional.of(this.dependenciesDiff.report("dependencies")), this.parentsDiff.map(report -> report.report("parents")), this.pluginsDiff.map(report -> report.report("plugins")), this.extensionsDiff.map(report -> report.report("extensions"))).filter(Optional::isPresent).flatMap(Optional::get);
        }

        public void logTo(Log log) {
            this.report().forEach(arg_0 -> ((Log)log).error(arg_0));
        }
    }
}

