/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;
import se.vandmo.dependencylock.maven.Checksum;
import se.vandmo.dependencylock.maven.LockableEntitiesWithArtifact;
import se.vandmo.dependencylock.maven.Parent;

public final class Parents
extends LockableEntitiesWithArtifact<Parent>
implements Iterable<Parent> {
    public Parents(List<Parent> parents) {
        super(Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(parents))), false);
    }

    public static Parents from(MavenProject project) {
        ArrayList<Parent> parents = new ArrayList<Parent>();
        while (project.getParentArtifact() != null) {
            Artifact parentArtifact = project.getParentArtifact();
            String integrity = Checksum.calculateFor(parentArtifact.getFile());
            parents.add(Parent.builder().artifactIdentifier(ArtifactIdentifier.from(parentArtifact)).version(parentArtifact.getVersion()).integrity(integrity).build());
            project = project.getParent();
        }
        return new Parents(parents);
    }
}

