/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.Objects;
import se.vandmo.dependencylock.maven.Artifact;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;
import se.vandmo.dependencylock.maven.Artifacts;
import se.vandmo.dependencylock.maven.Integrity;
import se.vandmo.dependencylock.maven.LockableEntityWithArtifact;

public final class Plugin
extends LockableEntityWithArtifact<Plugin> {
    public final Artifacts dependencies;

    public static PluginIdentifierBuilderStage builder() {
        return new PluginIdentifierBuilderStage();
    }

    public static ArtifactsBuilderStage forArtifact(Artifact dependency) {
        return new ArtifactsBuilderStage(dependency);
    }

    @Override
    public Plugin withIntegrity(Integrity integrity) {
        return new Plugin(this.artifact.withIntegrity(integrity), this.dependencies);
    }

    public Plugin withDependencies(Artifacts artifacts) {
        return new Plugin(this.artifact, artifacts);
    }

    private Plugin(Artifact artifact, Artifacts dependencies) {
        super(artifact);
        this.dependencies = Objects.requireNonNull(dependencies);
    }

    @Override
    public Plugin withVersion(String version) {
        return new Plugin(this.artifact.withVersion(version), this.dependencies);
    }

    public static final class FinalBuilderStage {
        private final Artifact artifact;
        private final Artifacts dependencies;

        private FinalBuilderStage(Artifact artifact, Artifacts dependencies) {
            this.artifact = artifact;
            this.dependencies = dependencies;
        }

        public Plugin build() {
            return new Plugin(this.artifact, this.dependencies);
        }
    }

    public static final class ArtifactsBuilderStage {
        private final Artifact artifact;

        private ArtifactsBuilderStage(Artifact artifact) {
            this.artifact = artifact;
        }

        public FinalBuilderStage artifacts(Artifacts artifacts) {
            return new FinalBuilderStage(this.artifact, Objects.requireNonNull(artifacts));
        }
    }

    public static final class IntegrityBuilderStage {
        private final Artifact.IntegrityBuilderStage artifactIntegrity;

        private IntegrityBuilderStage(Artifact.IntegrityBuilderStage artifactIntegrity) {
            this.artifactIntegrity = artifactIntegrity;
        }

        public ArtifactsBuilderStage integrity(String integrity) {
            return new ArtifactsBuilderStage(this.artifactIntegrity.integrity(integrity).build());
        }
    }

    public static final class VersionBuilderStage {
        private final Artifact.VersionBuilderStage versionBuilder;

        private VersionBuilderStage(Artifact.VersionBuilderStage versionBuilder) {
            this.versionBuilder = versionBuilder;
        }

        public IntegrityBuilderStage version(String version) {
            return new IntegrityBuilderStage(this.versionBuilder.version(version));
        }
    }

    public static final class PluginIdentifierBuilderStage {
        private PluginIdentifierBuilderStage() {
        }

        public VersionBuilderStage artifactIdentifier(ArtifactIdentifier artifactIdentifier) {
            return new VersionBuilderStage(Artifact.builder().artifactIdentifier(artifactIdentifier));
        }
    }
}

