/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class VersionUtils {
    private static final Pattern SNAPSHOT_TIMESTAMP = Pattern.compile("^((?<base>.*)-)?([0-9]{8}\\.[0-9]{6}-[0-9]+)$");

    private VersionUtils() {
    }

    static boolean snapshotMatch(String version, String otherVersion) {
        if (version.equals(otherVersion)) {
            return true;
        }
        return VersionUtils.stripSnapshot(version).equals(VersionUtils.stripSnapshot(otherVersion));
    }

    static String stripSnapshot(String version) {
        if (version.endsWith("-SNAPSHOT")) {
            return version.substring(0, version.length() - 9);
        }
        Matcher matcher = SNAPSHOT_TIMESTAMP.matcher(version);
        if (matcher.matches()) {
            return matcher.group("base");
        }
        return version;
    }
}

