/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.maven.plugin.logging.Log;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;
import se.vandmo.dependencylock.maven.Dependencies;
import se.vandmo.dependencylock.maven.DependenciesLockFile;
import se.vandmo.dependencylock.maven.Dependency;
import se.vandmo.dependencylock.maven.LockFileAccessor;
import se.vandmo.dependencylock.maven.LockedDependencies;
import se.vandmo.dependencylock.maven.json.JsonUtils;

public final class DependenciesLockFileJson
implements DependenciesLockFile {
    private final LockFileAccessor dependenciesLockFile;
    private final Log log;

    private DependenciesLockFileJson(LockFileAccessor dependenciesLockFile, Log log) {
        this.dependenciesLockFile = dependenciesLockFile;
        this.log = log;
    }

    public static DependenciesLockFileJson from(LockFileAccessor dependenciesLockFile, Log log) {
        return new DependenciesLockFileJson(Objects.requireNonNull(dependenciesLockFile), Objects.requireNonNull(log));
    }

    @Override
    public LockedDependencies read() {
        JsonNode json = this.readJsonNode();
        if (!json.isObject()) {
            throw new IllegalStateException("Expected top level type to be an object");
        }
        JsonNode dependencies = json.get("dependencies");
        if (dependencies == null || !dependencies.isArray()) {
            throw new IllegalStateException("Expected a property named 'dependencies' of type array");
        }
        return DependenciesLockFileJson.fromJson(dependencies, this.log);
    }

    private static LockedDependencies fromJson(JsonNode json, Log log) {
        if (!json.isArray()) {
            throw new IllegalStateException("Needs to be an array");
        }
        ArrayList<Dependency> lockedDependencies = new ArrayList<Dependency>();
        for (JsonNode entry : json) {
            lockedDependencies.add(DependenciesLockFileJson.lockedDependencyFromJson(entry));
        }
        return LockedDependencies.from(Dependencies.fromDependencies(lockedDependencies), log);
    }

    private static Dependency lockedDependencyFromJson(JsonNode json) {
        return Dependency.builder().artifactIdentifier(ArtifactIdentifier.builder().groupId(JsonUtils.getNonBlankStringValue(json, "groupId")).artifactId(JsonUtils.getNonBlankStringValue(json, "artifactId")).classifier(JsonUtils.possiblyGetStringValue(json, "classifier")).type(JsonUtils.possiblyGetStringValue(json, "type")).build()).version(JsonUtils.getNonBlankStringValue(json, "version")).integrity(JsonUtils.getNonBlankStringValue(json, "integrity")).scope(JsonUtils.getNonBlankStringValue(json, "scope")).optional(JsonUtils.getBooleanOrDefault(json, "optional", false)).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode readJsonNode() {
        try (Reader reader = this.dependenciesLockFile.reader();){
            JsonNode jsonNode = JsonUtils.readJson(reader);
            return jsonNode;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void write(Dependencies projectDependencies) {
        this.write(LockedDependencies.from(projectDependencies, this.log));
    }

    public void write(LockedDependencies lockedDependencies) {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.set("dependencies", this.asJson(lockedDependencies));
        try (Writer writer = this.dependenciesLockFile.writer();){
            JsonUtils.writeJson(writer, (JsonNode)json);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private JsonNode asJson(LockedDependencies lockedDependencies) {
        ArrayNode json = JsonNodeFactory.instance.arrayNode();
        for (Dependency lockedDependency : lockedDependencies.lockedEntities) {
            json.add(this.asJson(lockedDependency));
        }
        return json;
    }

    private JsonNode asJson(Dependency lockedDependency) {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        ArtifactIdentifier artifactIdentifier = lockedDependency.getArtifactIdentifier();
        json.put("groupId", artifactIdentifier.groupId);
        json.put("artifactId", artifactIdentifier.artifactId);
        json.put("version", lockedDependency.getVersion());
        json.put("scope", lockedDependency.scope);
        json.put("type", artifactIdentifier.type);
        json.put("optional", lockedDependency.optional);
        json.put("integrity", lockedDependency.getIntegrityForLockFile());
        artifactIdentifier.classifier.ifPresent(actualClassifier -> json.put("classifier", actualClassifier));
        return json;
    }
}

