/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Optional;
import se.vandmo.dependencylock.maven.lang.Strings;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static String getNonBlankStringValue(JsonNode json, String fieldName) {
        JsonNode jsonNode = json.get(fieldName);
        if (jsonNode == null) {
            throw JsonUtils.missingValueFor(fieldName);
        }
        String value = jsonNode.textValue();
        if (Strings.isBlank(value)) {
            throw JsonUtils.missingValueFor(fieldName);
        }
        return value;
    }

    private static IllegalArgumentException missingValueFor(String fieldName) {
        return new IllegalArgumentException(String.format(Locale.ROOT, "Missing value for '%s'", fieldName));
    }

    public static boolean getBooleanOrDefault(JsonNode json, String fieldName, boolean defaultValue) {
        if (!json.has(fieldName)) {
            return defaultValue;
        }
        JsonNode value = json.get(fieldName);
        if (!value.isBoolean()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "'%s' is not a boolean value", fieldName));
        }
        return value.booleanValue();
    }

    public static Optional<String> possiblyGetStringValue(JsonNode json, String fieldName) {
        if (!json.has(fieldName)) {
            return Optional.empty();
        }
        return Optional.of(JsonUtils.getNonBlankStringValue(json, fieldName));
    }

    public static JsonNode readJson(Reader reader) {
        try {
            return new ObjectMapper().readTree(reader);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static void writeJson(Writer writer, JsonNode json) {
        try {
            new ObjectMapper().disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET}).writerWithDefaultPrettyPrinter().writeValue(writer, (Object)json);
            writer.write(System.lineSeparator());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

