/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import se.vandmo.dependencylock.maven.Artifact;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;
import se.vandmo.dependencylock.maven.Artifacts;
import se.vandmo.dependencylock.maven.Dependencies;
import se.vandmo.dependencylock.maven.Dependency;
import se.vandmo.dependencylock.maven.Extension;
import se.vandmo.dependencylock.maven.Extensions;
import se.vandmo.dependencylock.maven.LockFileAccessor;
import se.vandmo.dependencylock.maven.LockableEntitiesWithArtifact;
import se.vandmo.dependencylock.maven.LockedProject;
import se.vandmo.dependencylock.maven.Lockfile;
import se.vandmo.dependencylock.maven.Parent;
import se.vandmo.dependencylock.maven.Parents;
import se.vandmo.dependencylock.maven.Plugin;
import se.vandmo.dependencylock.maven.Plugins;
import se.vandmo.dependencylock.maven.json.JsonUtils;

public final class LockfileJson
implements Lockfile {
    private static final String V2 = "2";
    private final LockFileAccessor dependenciesLockFile;
    private final Log log;

    private LockfileJson(LockFileAccessor dependenciesLockFile, Log log) {
        this.dependenciesLockFile = dependenciesLockFile;
        this.log = log;
    }

    public static LockfileJson from(LockFileAccessor dependenciesLockFile, Log log) {
        return new LockfileJson(Objects.requireNonNull(dependenciesLockFile), Objects.requireNonNull(log));
    }

    @Override
    public LockedProject read() throws MojoExecutionException {
        JsonNode json = this.readJsonNode();
        if (!json.isObject()) {
            throw new IllegalStateException("Expected top level type to be an object");
        }
        return LockfileJson.fromJson(json, this.log);
    }

    private static LockedProject fromJson(JsonNode json, Log log) throws MojoExecutionException {
        JsonNode version = json.get("version");
        if (version == null) {
            return LockedProject.from(LockfileJson.loadDependenciesFromJson(LockfileJson.getDependencies(json)), log);
        }
        if (V2.equals(version.asText())) {
            JsonNode artifacts = json.get("artifacts");
            if (artifacts == null) {
                throw new IllegalStateException("Missing artifacts field");
            }
            Map<String, Artifact> artifactMap = LockfileJson.loadArtifactsFromJson(artifacts);
            Optional<Plugins> plugins = Optional.ofNullable(json.get("plugins")).map(pluginsNode -> LockfileJson.loadPluginsFromJson(pluginsNode, artifactMap));
            Optional<Extensions> extensions = Optional.ofNullable(json.get("extensions")).map(extensionsNode -> LockfileJson.loadExtensionsFromJson(extensionsNode, artifactMap));
            Dependencies projectDependencies = LockfileJson.loadDependenciesFromJson(LockfileJson.getDependencies(json), artifactMap);
            Optional<Parents> parents = Optional.ofNullable(json.get("parents")).map(parentsNode -> LockfileJson.loadParentsFromJson(parentsNode));
            return LockedProject.from(projectDependencies, parents, plugins, extensions, log);
        }
        throw new MojoExecutionException(String.format(Locale.ROOT, "Unexpected lock file version \"%s\". The file might have been generated by a newer version of this plugin than is used for this check.", version.asText()));
    }

    private static JsonNode getDependencies(JsonNode json) {
        JsonNode dependencies = json.get("dependencies");
        if (dependencies == null) {
            throw new IllegalStateException("Missing dependencies field");
        }
        return dependencies;
    }

    private static Map<String, Artifact> loadArtifactsFromJson(JsonNode json) {
        if (null == json) {
            return Collections.emptyMap();
        }
        Iterator entries = json.fields();
        HashMap<String, Artifact> artifacts = new HashMap<String, Artifact>();
        while (entries.hasNext()) {
            Map.Entry entry = (Map.Entry)entries.next();
            artifacts.put((String)entry.getKey(), LockfileJson.parseArtifact((JsonNode)entry.getValue()));
        }
        return artifacts;
    }

    private static Artifact parseArtifact(JsonNode json) {
        return Artifact.builder().artifactIdentifier(ArtifactIdentifier.builder().groupId(JsonUtils.getNonBlankStringValue(json, "groupId")).artifactId(JsonUtils.getNonBlankStringValue(json, "artifactId")).classifier(JsonUtils.possiblyGetStringValue(json, "classifier")).type(JsonUtils.possiblyGetStringValue(json, "type")).build()).version(JsonUtils.getNonBlankStringValue(json, "version")).integrity(JsonUtils.getNonBlankStringValue(json, "integrity")).build();
    }

    private static Parents loadParentsFromJson(JsonNode json) {
        ArrayList<Parent> parents = new ArrayList<Parent>();
        if (!json.isArray()) {
            throw new IllegalStateException("Expected parents field to be an array");
        }
        for (JsonNode node : json) {
            parents.add(Parent.builder().artifactIdentifier(ArtifactIdentifier.builder().groupId(JsonUtils.getNonBlankStringValue(node, "groupId")).artifactId(JsonUtils.getNonBlankStringValue(node, "artifactId")).type("pom").build()).version(JsonUtils.getNonBlankStringValue(node, "version")).integrity(JsonUtils.getNonBlankStringValue(node, "integrity")).build());
        }
        return new Parents(parents);
    }

    private static Dependencies loadDependenciesFromJson(JsonNode json) {
        if (!json.isArray()) {
            throw new IllegalStateException("Needs to be an array");
        }
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(json.size());
        for (JsonNode dependency : json) {
            Artifact artifact = LockfileJson.parseArtifact(dependency);
            String scope = JsonUtils.possiblyGetStringValue(dependency, "scope").orElse(null);
            boolean optional = dependency.get("optional").asBoolean();
            dependencies.add(Dependency.forArtifact(artifact).scope(scope).optional(optional).build());
        }
        return Dependencies.fromDependencies(dependencies);
    }

    private static Dependencies loadDependenciesFromJson(JsonNode json, Map<String, Artifact> artifacts) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (!json.isArray()) {
            throw new IllegalStateException("Needs to be an array");
        }
        for (JsonNode dependency : json) {
            String artifactKey = JsonUtils.getNonBlankStringValue(dependency, "artifact");
            Artifact artifact = artifacts.get(artifactKey);
            if (artifact == null) {
                throw new IllegalStateException("Artifact not found: " + artifactKey);
            }
            String scope = JsonUtils.possiblyGetStringValue(dependency, "scope").orElse(null);
            boolean optional = dependency.get("optional").asBoolean();
            dependencies.add(Dependency.forArtifact(artifact).scope(scope).optional(optional).build());
        }
        return Dependencies.fromDependencies(dependencies);
    }

    private static Plugins loadPluginsFromJson(JsonNode json, Map<String, Artifact> artifacts) {
        if (!json.isArray()) {
            throw new IllegalStateException("Needs to be an array");
        }
        ArrayList<Plugin> lockedPlugins = new ArrayList<Plugin>();
        for (JsonNode entry : json) {
            lockedPlugins.add(LockfileJson.lockedPluginFromJson(entry, artifacts));
        }
        return Plugins.from(lockedPlugins);
    }

    private static Extensions loadExtensionsFromJson(JsonNode json, Map<String, Artifact> artifacts) {
        if (!json.isArray()) {
            throw new IllegalStateException("Needs to be an array");
        }
        ArrayList<Extension> lockedPlugins = new ArrayList<Extension>(json.size());
        for (JsonNode entry : json) {
            lockedPlugins.add(LockfileJson.lockedExtensionFromJson(entry, artifacts));
        }
        return Extensions.from(lockedPlugins);
    }

    private static Plugin lockedPluginFromJson(JsonNode json, Map<String, Artifact> artifacts) {
        List<Artifact> dependencies;
        String artifactKey = JsonUtils.getNonBlankStringValue(json, "artifact");
        Artifact artifact = artifacts.get(artifactKey);
        if (null == artifact) {
            throw new IllegalArgumentException("Artifact not found: " + artifactKey);
        }
        Plugin.ArtifactsBuilderStage builderStage = Plugin.forArtifact(artifact);
        JsonNode dependenciesNode = json.get("dependencies");
        if (null == dependenciesNode) {
            dependencies = Collections.emptyList();
        } else {
            if (!dependenciesNode.isArray()) {
                throw new IllegalStateException("Needs to be an array");
            }
            dependencies = new ArrayList<Artifact>(dependenciesNode.size());
            for (JsonNode dependency : dependenciesNode) {
                String dependencyKey = dependency.asText();
                Artifact artifactDependency = artifacts.get(dependencyKey);
                if (null == artifactDependency) {
                    throw new IllegalArgumentException("Dependency not found: " + dependencyKey);
                }
                dependencies.add(artifactDependency);
            }
        }
        return builderStage.artifacts(Artifacts.fromArtifacts(dependencies)).build();
    }

    private static Extension lockedExtensionFromJson(JsonNode json, Map<String, Artifact> artifacts) {
        String artifactKey = JsonUtils.getNonBlankStringValue(json, "artifact");
        Artifact artifact = artifacts.get(artifactKey);
        if (null == artifact) {
            throw new IllegalArgumentException("Artifact not found: " + artifactKey);
        }
        return Extension.of(artifact);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode readJsonNode() {
        try (Reader reader = this.dependenciesLockFile.reader();){
            JsonNode jsonNode = JsonUtils.readJson(reader);
            return jsonNode;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void write(LockedProject contents) {
        JsonNode json = this.write(contents, JsonNodeFactory.instance);
        try (Writer writer = this.dependenciesLockFile.writer();){
            JsonUtils.writeJson(writer, json);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private JsonNode write(LockedProject contents, JsonNodeFactory jsonNodeFactory) {
        ObjectNode json = jsonNodeFactory.objectNode();
        ObjectNode output = jsonNodeFactory.objectNode();
        this.collectArtifacts(contents).forEach((key, value) -> output.set(key, this.writeJson((Artifact)value, jsonNodeFactory)));
        json.put("version", V2);
        json.set("artifacts", (JsonNode)output);
        contents.parents.ifPresent(parents -> json.set("parents", this.toJson((Parents)parents, jsonNodeFactory)));
        contents.plugins.ifPresent(plugins -> json.set("plugins", this.toJson((Plugins)plugins, jsonNodeFactory)));
        contents.extensions.ifPresent(extensions -> json.set("extensions", this.toJson((Extensions)extensions, jsonNodeFactory)));
        json.set("dependencies", this.toJson(contents.dependencies, jsonNodeFactory));
        return json;
    }

    private JsonNode writeJson(Artifact artifact, JsonNodeFactory factory) {
        ObjectNode output = factory.objectNode();
        ArtifactIdentifier artifactIdentifier = artifact.identifier;
        output.put("groupId", artifactIdentifier.groupId);
        output.put("artifactId", artifactIdentifier.artifactId);
        output.put("version", artifact.version);
        artifactIdentifier.classifier.ifPresent(actualClassifier -> output.put("classifier", actualClassifier));
        output.put("type", artifactIdentifier.type);
        output.put("integrity", artifact.getIntegrityForLockFile());
        return output;
    }

    private Map<String, Artifact> collectArtifacts(LockedProject contents) {
        HashMap artifacts = new HashMap();
        Stream.concat(Stream.concat(contents.dependencies.artifacts(), contents.plugins.map(Plugins::artifacts).orElse(Stream.empty())), contents.extensions.map(LockableEntitiesWithArtifact::artifacts).orElse(Stream.empty())).forEach(artifact -> artifacts.putIfAbsent(artifact.getArtifactKey(), artifact));
        return new TreeMap<String, Artifact>(artifacts);
    }

    private JsonNode toJson(Plugins plugins, JsonNodeFactory jsonNodeFactory) {
        ArrayNode json = jsonNodeFactory.arrayNode();
        for (Plugin lockedPlugin : plugins) {
            json.add(this.toJson(lockedPlugin, jsonNodeFactory));
        }
        return json;
    }

    private JsonNode toJson(Dependencies dependencies, JsonNodeFactory jsonNodeFactory) {
        ArrayNode json = jsonNodeFactory.arrayNode();
        for (Dependency dependency : dependencies) {
            json.add(this.toJson(dependency, jsonNodeFactory));
        }
        return json;
    }

    private JsonNode toJson(Extensions extensions, JsonNodeFactory jsonNodeFactory) {
        ArrayNode json = jsonNodeFactory.arrayNode();
        for (Extension extension : extensions) {
            json.add(this.toJson(extension, jsonNodeFactory));
        }
        return json;
    }

    private JsonNode toJson(Plugin lockedPlugin, JsonNodeFactory jsonNodeFactory) {
        ObjectNode json = jsonNodeFactory.objectNode();
        json.put("artifact", lockedPlugin.toString_withoutIntegrity());
        ArrayNode dependencies = jsonNodeFactory.arrayNode();
        for (Artifact artifact : lockedPlugin.dependencies) {
            dependencies.add(artifact.getArtifactKey());
        }
        json.set("dependencies", (JsonNode)dependencies);
        return json;
    }

    private JsonNode toJson(Extension lockedExtension, JsonNodeFactory jsonNodeFactory) {
        ObjectNode json = jsonNodeFactory.objectNode();
        json.put("artifact", lockedExtension.getArtifactKey());
        return json;
    }

    private JsonNode toJson(Dependency dependency, JsonNodeFactory jsonNodeFactory) {
        ObjectNode json = jsonNodeFactory.objectNode();
        json.put("artifact", dependency.getArtifactKey());
        json.put("scope", dependency.scope);
        json.put("optional", dependency.optional);
        return json;
    }

    private JsonNode toJson(Parents lockedParents, JsonNodeFactory jsonNodeFactory) {
        ArrayNode jsonParentsArray = jsonNodeFactory.arrayNode(lockedParents.size());
        for (Parent lockedParent : lockedParents) {
            ObjectNode json = jsonNodeFactory.objectNode();
            ArtifactIdentifier artifactIdentifier = lockedParent.getArtifactIdentifier();
            json.put("groupId", artifactIdentifier.groupId);
            json.put("artifactId", artifactIdentifier.artifactId);
            json.put("version", lockedParent.getVersion());
            json.put("type", artifactIdentifier.type);
            json.put("integrity", lockedParent.getIntegrityForLockFile());
            jsonParentsArray.add((JsonNode)json);
        }
        return jsonParentsArray;
    }
}

