/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven.mojos;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.ExtensionRealmCache;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.StrictPatternIncludesArtifactFilter;
import se.vandmo.dependencylock.maven.Dependencies;
import se.vandmo.dependencylock.maven.DependencySetConfiguration;
import se.vandmo.dependencylock.maven.Extensions;
import se.vandmo.dependencylock.maven.Filters;
import se.vandmo.dependencylock.maven.LockFileAccessor;
import se.vandmo.dependencylock.maven.LockFileFormat;
import se.vandmo.dependencylock.maven.MojoExecutionRuntimeException;
import se.vandmo.dependencylock.maven.Plugins;
import se.vandmo.dependencylock.maven.PomMinimums;
import se.vandmo.dependencylock.maven.mojos.DependencySet;
import se.vandmo.dependencylock.maven.mojos.LockProjectHelper;

public abstract class AbstractDependencyLockMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}", required=true, readonly=true)
    private File basedir;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Parameter(property="dependencyLock.filename")
    private String filename;
    @Parameter(property="dependencyLock.format")
    private LockFileFormat format = LockFileFormat.json;
    @Parameter
    private DependencySet[] dependencySets = new DependencySet[0];
    @Component
    private MavenPluginManager mavenPluginManager;

    LockFileAccessor lockFile() {
        return this.format.dependenciesLockFileAccessor_fromBasedirAndFilename(this.basedir, this.filename);
    }

    Dependencies projectDependencies() {
        return Dependencies.fromMavenArtifacts(this.mavenProject().getArtifacts());
    }

    final MavenProject mavenProject() {
        return this.project;
    }

    Extensions projectExtensions() {
        ArrayList<ExtensionRealmCache.CacheRecord> extensionRealms = new ArrayList<ExtensionRealmCache.CacheRecord>(this.mavenProject().getBuildExtensions().size());
        for (Extension extension : this.mavenProject().getBuildExtensions()) {
            Plugin extensionAsAPlugin = new Plugin();
            extensionAsAPlugin.setGroupId(extension.getGroupId());
            extensionAsAPlugin.setArtifactId(extension.getArtifactId());
            extensionAsAPlugin.setVersion(extension.getVersion());
            try {
                extensionRealms.add(this.mavenPluginManager.setupExtensionsRealm(this.mavenProject(), extensionAsAPlugin, this.mavenSession.getRepositorySession()));
            }
            catch (PluginManagerException e) {
                throw new MojoExecutionRuntimeException("Failed loading extension realm for plugin " + extensionAsAPlugin, e);
            }
        }
        return Extensions.fromMavenExtensionRealms(extensionRealms);
    }

    Plugins projectPlugins() {
        return new LockProjectHelper(this.getLog(), this.mavenPluginManager, this.mavenSession).loadPlugins(this.mavenProject());
    }

    PomMinimums pomMinimums() {
        return PomMinimums.from(this.mavenProject());
    }

    String projectVersion() {
        return this.mavenProject().getVersion();
    }

    LockFileFormat format() {
        return this.format;
    }

    Filters filters() {
        List<DependencySetConfiguration> dependencySetConfigurations = Collections.unmodifiableList(Arrays.stream(this.dependencySets).map(this::transform).collect(Collectors.toList()));
        return new Filters(dependencySetConfigurations, this.projectVersion());
    }

    private DependencySetConfiguration transform(DependencySet dependencySet) {
        return new DependencySetConfiguration((ArtifactFilter)new StrictPatternIncludesArtifactFilter(Arrays.asList(dependencySet.includes)), (ArtifactFilter)new StrictPatternIncludesArtifactFilter(Arrays.asList(dependencySet.excludes)), AbstractDependencyLockMojo.transformVersion(dependencySet.version), AbstractDependencyLockMojo.transformIntegrity(dependencySet.integrity), dependencySet.allowMissing, dependencySet.allowExtraneous);
    }

    private static DependencySetConfiguration.Integrity transformIntegrity(DependencySet.Integrity integrity) {
        if (integrity == null) {
            return null;
        }
        switch (integrity) {
            case check: {
                return DependencySetConfiguration.Integrity.check;
            }
            case ignore: {
                return DependencySetConfiguration.Integrity.ignore;
            }
        }
        throw new RuntimeException("Invalid enum value encountered");
    }

    private static DependencySetConfiguration.Version transformVersion(String version) {
        if (version == null) {
            return null;
        }
        switch (version) {
            case "check": {
                return DependencySetConfiguration.Version.check;
            }
            case "ignore": {
                return DependencySetConfiguration.Version.ignore;
            }
            case "use-project-version": {
                return DependencySetConfiguration.Version.useProjectVersion;
            }
            case "snapshot": {
                return DependencySetConfiguration.Version.snapshot;
            }
        }
        throw new RuntimeException("Invalid value for version configuration");
    }
}

