/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven.mojos;

import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import se.vandmo.dependencylock.maven.DiffReport;
import se.vandmo.dependencylock.maven.Extensions;
import se.vandmo.dependencylock.maven.Filters;
import se.vandmo.dependencylock.maven.LockFileAccessor;
import se.vandmo.dependencylock.maven.LockedDependencies;
import se.vandmo.dependencylock.maven.LockedExtensions;
import se.vandmo.dependencylock.maven.LockedParents;
import se.vandmo.dependencylock.maven.LockedPlugins;
import se.vandmo.dependencylock.maven.LockedProject;
import se.vandmo.dependencylock.maven.MojoExecutionRuntimeException;
import se.vandmo.dependencylock.maven.Parents;
import se.vandmo.dependencylock.maven.Plugins;
import se.vandmo.dependencylock.maven.mojos.AbstractDependencyLockMojo;

@Mojo(name="check", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public final class CheckMojo
extends AbstractDependencyLockMojo {
    @Parameter(property="dependencyLock.skipCheck")
    private Boolean skip = false;

    public void execute() throws MojoExecutionException {
        try {
            this.doExecute();
        }
        catch (MojoExecutionRuntimeException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public void doExecute() throws MojoExecutionException {
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping check");
            return;
        }
        LockFileAccessor lockFile = this.lockFile();
        if (!lockFile.exists()) {
            throw new MojoExecutionException("No lock file found, create one by running 'mvn se.vandmo:dependency-lock-maven-plugin:lock'");
        }
        LockedProject lockedProject = this.format().lockFile_from(lockFile, this.pomMinimums(), this.getLog()).read();
        Filters filters = this.filters();
        Log log = this.getLog();
        log.info((CharSequence)"Checking dependencies");
        DiffReport dependenciesDiff = LockedDependencies.from(lockedProject.dependencies, this.getLog()).compareWith(this.projectDependencies(), filters).getReport();
        Optional<DiffReport> parentsDiff = lockedProject.parents.map(lockedParents -> {
            log.info((CharSequence)"Checking parents");
            return LockedParents.from(Parents.from(this.mavenProject()), this.getLog()).compareWith((Parents)lockedParents, filters);
        });
        Optional<DiffReport> pluginsDiff = lockedProject.plugins.map(lockedPlugins -> {
            log.info((CharSequence)"Checking plugins");
            return LockedPlugins.from(this.projectPlugins(), this.getLog()).compareWith((Plugins)lockedPlugins, filters);
        });
        Optional<DiffReport> extensionsDiff = lockedProject.extensions.map(lockedExtensions -> {
            log.info((CharSequence)"Checking extensions");
            return LockedExtensions.from(this.projectExtensions(), this.getLog()).compareWith((Extensions)lockedExtensions, filters);
        });
        LockedProject.Diff diff = new LockedProject.Diff(dependenciesDiff, parentsDiff, pluginsDiff, extensionsDiff);
        if (!diff.equals()) {
            diff.logTo(this.getLog());
            throw new MojoExecutionException("Actual project differ from locked project");
        }
        this.getLog().info((CharSequence)"Actual project matches locked project");
    }
}

