/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven.mojos;

import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import se.vandmo.dependencylock.maven.Artifacts;
import se.vandmo.dependencylock.maven.Dependencies;
import se.vandmo.dependencylock.maven.DependencySetConfiguration;
import se.vandmo.dependencylock.maven.Extensions;
import se.vandmo.dependencylock.maven.Filters;
import se.vandmo.dependencylock.maven.Integrity;
import se.vandmo.dependencylock.maven.LockFileAccessor;
import se.vandmo.dependencylock.maven.LockableEntity;
import se.vandmo.dependencylock.maven.LockedDependencies;
import se.vandmo.dependencylock.maven.LockedProject;
import se.vandmo.dependencylock.maven.Parents;
import se.vandmo.dependencylock.maven.Plugin;
import se.vandmo.dependencylock.maven.Plugins;
import se.vandmo.dependencylock.maven.Project;
import se.vandmo.dependencylock.maven.json.DependenciesLockFileJson;
import se.vandmo.dependencylock.maven.json.LockfileJson;
import se.vandmo.dependencylock.maven.mojos.AbstractDependencyLockMojo;
import se.vandmo.dependencylock.maven.pom.DependenciesLockFilePom;
import se.vandmo.dependencylock.maven.pom.LockFilePom;

@Mojo(name="lock", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public final class LockMojo
extends AbstractDependencyLockMojo {
    @Parameter(property="dependencyLock.markIgnoredAsIgnored")
    private boolean markIgnoredAsIgnored = false;
    @Parameter(property="dependencyLock.skipLock")
    private Boolean skip = false;
    @Parameter(property="dependencyLock.lockBuild")
    private boolean lockBuild;

    public void execute() throws MojoExecutionException {
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"Skipping lock");
            return;
        }
        LockFileAccessor lockFile = this.lockFile();
        this.getLog().info((CharSequence)String.format(Locale.ROOT, "Creating %s", lockFile.filename()));
        switch (this.format()) {
            case json: {
                this.dumpJsonLockfile(lockFile);
                break;
            }
            case pom: {
                this.dumpPomLockfile(lockFile);
                break;
            }
            default: {
                throw new RuntimeException("This should not happen!");
            }
        }
    }

    private void dumpPomLockfile(LockFileAccessor lockFile) throws MojoExecutionException {
        if (this.isLockBuild()) {
            LockFilePom lockFiles = LockFilePom.from(lockFile, this.pomMinimums(), this.getLog());
            LockedProject lockedProject = LockedProject.from(this.project(), this.getLog());
            lockFiles.write(lockedProject);
        } else {
            DependenciesLockFilePom lockFilePom = DependenciesLockFilePom.from(lockFile, this.pomMinimums(), this.getLog());
            lockFilePom.write(this.filteredProjectDependencies());
        }
    }

    boolean isLockBuild() {
        return this.lockBuild;
    }

    Project project() throws MojoExecutionException {
        if (this.isLockBuild()) {
            return Project.from(this.filteredProjectDependencies(), Parents.from(this.mavenProject()), this.filteredProjectPlugins(), this.filteredProjectExtensions());
        }
        return Project.from(this.filteredProjectDependencies());
    }

    private void dumpJsonLockfile(LockFileAccessor lockFile) throws MojoExecutionException {
        if (this.isLockBuild()) {
            LockfileJson lockFileJson = LockfileJson.from(lockFile, this.getLog());
            LockedProject lockedProject = LockedProject.from(this.project(), this.getLog());
            lockFileJson.write(lockedProject);
        } else {
            DependenciesLockFileJson lockFileJson = DependenciesLockFileJson.from(lockFile, this.getLog());
            LockedDependencies lockedDependencies = LockedDependencies.from(this.filteredProjectDependencies(), this.getLog());
            lockFileJson.write(lockedDependencies);
        }
    }

    private Dependencies filteredProjectDependencies() {
        Dependencies projectDependencies = this.projectDependencies();
        if (!this.markIgnoredAsIgnored) {
            return projectDependencies;
        }
        this.getLog().info((CharSequence)"Marking ignored version and integrity as ignored in lock file");
        Filters filters = this.filters();
        return Dependencies.fromDependencies(this.projectDependencies().stream().map(artifact -> LockMojo.modify(artifact, filters)).collect(Collectors.toList()));
    }

    private Plugins filteredProjectPlugins() throws MojoExecutionException {
        Plugins projectPlugins = this.projectPlugins();
        if (!this.markIgnoredAsIgnored) {
            return projectPlugins;
        }
        this.getLog().info((CharSequence)"Marking ignored version and integrity as ignored in lock file");
        Filters filters = this.filters();
        return Plugins.from(projectPlugins.stream().map(plugin -> this.modify((Plugin)plugin, filters)).collect(Collectors.toList()));
    }

    private Extensions filteredProjectExtensions() throws MojoExecutionException {
        Extensions projectExtensions = this.projectExtensions();
        if (!this.markIgnoredAsIgnored) {
            return projectExtensions;
        }
        this.getLog().info((CharSequence)"Marking ignored version and integrity as ignored in lock file");
        Filters filters = this.filters();
        return Extensions.from(projectExtensions.stream().map(plugin -> LockMojo.modify(plugin, filters)).collect(Collectors.toList()));
    }

    private static <T extends LockableEntity<T>> T modify(T lockableEntity, Filters filters) {
        T result = lockableEntity;
        result = LockMojo.ignoreVersionIfRelevant(result, filters);
        result = LockMojo.ignoreIntegrityIfRelevant(result, filters);
        return result;
    }

    private static <T extends LockableEntity<T>> T ignoreIntegrityIfRelevant(T lockableEntity, Filters filters) {
        if (filters.integrityConfiguration(lockableEntity).equals((Object)DependencySetConfiguration.Integrity.ignore)) {
            return lockableEntity.withIntegrity(Integrity.Ignored());
        }
        return lockableEntity;
    }

    private static <T extends LockableEntity<T>> T ignoreVersionIfRelevant(T lockableEntity, Filters filters) {
        if (filters.versionConfiguration(lockableEntity).type.equals((Object)DependencySetConfiguration.Version.ignore)) {
            return lockableEntity.withVersion("ignored");
        }
        return lockableEntity;
    }

    private Plugin modify(Plugin plugin, Filters filters) {
        Plugin result = plugin;
        result = LockMojo.ignoreVersionIfRelevant(result, filters);
        result = LockMojo.ignoreIntegrityIfRelevant(result, filters);
        result = result.withDependencies(Artifacts.fromArtifacts(result.dependencies.stream().map(artifact -> LockMojo.modify(artifact, filters)).collect(Collectors.toList())));
        return result;
    }
}

