/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven.mojos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import se.vandmo.dependencylock.maven.Artifact;
import se.vandmo.dependencylock.maven.Artifacts;
import se.vandmo.dependencylock.maven.MojoExecutionRuntimeException;
import se.vandmo.dependencylock.maven.Plugin;
import se.vandmo.dependencylock.maven.Plugins;

final class LockProjectHelper {
    private final Log log;
    private final MavenPluginManager mavenPluginManager;
    private final MavenSession mavenSession;

    LockProjectHelper(Log log, MavenPluginManager mavenPluginManager, MavenSession mavenSession) {
        this.log = log;
        this.mavenPluginManager = mavenPluginManager;
        this.mavenSession = mavenSession;
    }

    private Plugin loadPlugin(MavenProject project, org.apache.maven.model.Plugin plugin, Map<String, Artifact> artifactCache) {
        try {
            PluginDescriptor descriptor = this.mavenPluginManager.getPluginDescriptor(plugin, project.getRemotePluginRepositories(), this.mavenSession.getRepositorySession());
            this.mavenPluginManager.setupPluginRealm(descriptor, this.mavenSession, null, null, null);
            org.apache.maven.artifact.Artifact pluginArtifact = descriptor.getPluginArtifact();
            return Plugin.forArtifact(Artifact.from(pluginArtifact)).artifacts(Artifacts.fromArtifacts(descriptor.getArtifacts().stream().filter(a -> !a.equals(pluginArtifact)).map(mavenArtifact -> {
                String artifactId = mavenArtifact.getId();
                Artifact cachedValue = (Artifact)artifactCache.get(artifactId);
                if (null == cachedValue) {
                    cachedValue = Artifact.from(mavenArtifact);
                    artifactCache.put(artifactId, cachedValue);
                }
                return cachedValue;
            }).collect(Collectors.toList()))).build();
        }
        catch (PluginResolutionException e) {
            throw new MojoExecutionRuntimeException("Failed resolving plugin " + plugin, e);
        }
        catch (PluginDescriptorParsingException e) {
            throw new MojoExecutionRuntimeException("Failed parsing plugin descriptor of plugin " + plugin, e);
        }
        catch (InvalidPluginDescriptorException e) {
            throw new MojoExecutionRuntimeException("Invalid plugin descriptor found for plugin " + plugin, e);
        }
        catch (PluginContainerException e) {
            throw new MojoExecutionRuntimeException("Failed loading container for plugin " + plugin, e);
        }
    }

    Plugins loadPlugins(MavenProject project) {
        List buildPlugins = project.getBuildPlugins();
        HashMap<String, Artifact> artifactCache = new HashMap<String, Artifact>();
        ArrayList<Plugin> result = new ArrayList<Plugin>(buildPlugins.size());
        HashMap<String, org.apache.maven.model.Plugin> declaredPlugins = new HashMap<String, org.apache.maven.model.Plugin>();
        for (org.apache.maven.model.Plugin plugin : buildPlugins) {
            declaredPlugins.put(plugin.getId(), plugin);
            result.add(this.loadPlugin(project, plugin, artifactCache));
        }
        for (org.apache.maven.model.Plugin profilePlugin : this.lookupAdditionalProfilePlugins(project, declaredPlugins)) {
            result.add(this.loadPlugin(project, profilePlugin, artifactCache));
        }
        return Plugins.from(result);
    }

    private Collection<org.apache.maven.model.Plugin> lookupAdditionalProfilePlugins(MavenProject project, Map<String, org.apache.maven.model.Plugin> declaredPlugins) {
        List profiles = project.getModel().getProfiles();
        if (profiles.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, String> baseProfilePluginVersions = this.loadCurrentProjectBuildPluginVersions(project);
        HashMap<String, org.apache.maven.model.Plugin> missingPlugins = new HashMap<String, org.apache.maven.model.Plugin>();
        for (Profile profile : profiles) {
            HashMap<String, String> potentialProfilePluginVersions = new HashMap<String, String>(baseProfilePluginVersions);
            BuildBase profileBuild = profile.getBuild();
            if (profileBuild == null) continue;
            PluginManagement profilePluginManagement = profileBuild.getPluginManagement();
            if (profilePluginManagement != null) {
                profilePluginManagement.getPluginsAsMap().forEach((key, value) -> {
                    String profilePluginVersion = value.getVersion();
                    if (profilePluginVersion != null) {
                        this.log.warn((CharSequence)String.format(Locale.ROOT, "Detected version managed at profile level for plugin %s. This is not recommended as it may yield inconsistent behaviours.", key));
                        potentialProfilePluginVersions.put((String)key, profilePluginVersion);
                    }
                });
            }
            for (org.apache.maven.model.Plugin plugin : profileBuild.getPlugins()) {
                if (null != plugin.getVersion()) {
                    String pluginId = plugin.getId();
                    if (declaredPlugins.containsKey(pluginId)) continue;
                    missingPlugins.put(pluginId, plugin);
                    continue;
                }
                String pluginKey = plugin.getKey();
                String potentialVersion = (String)potentialProfilePluginVersions.get(pluginKey);
                if (null == potentialVersion) continue;
                org.apache.maven.model.Plugin forkedPlugin = plugin.clone();
                forkedPlugin.setVersion(potentialVersion);
                String pluginId = forkedPlugin.getId();
                if (declaredPlugins.containsKey(pluginId)) continue;
                missingPlugins.put(pluginId, forkedPlugin);
            }
        }
        return missingPlugins.values();
    }

    private Map<String, String> loadCurrentProjectBuildPluginVersions(MavenProject project) {
        HashMap baseProfilePluginVersions = new HashMap();
        project.getBuild().getPluginsAsMap().forEach((key, value) -> baseProfilePluginVersions.put(key, value.getVersion()));
        PluginManagement projectPluginManagement = project.getBuild().getPluginManagement();
        if (projectPluginManagement != null) {
            projectPluginManagement.getPluginsAsMap().forEach((key, value) -> {
                String managedPluginVersion = value.getVersion();
                if (managedPluginVersion != null) {
                    baseProfilePluginVersions.putIfAbsent(key, managedPluginVersion);
                }
            });
        }
        return Collections.unmodifiableMap(baseProfilePluginVersions);
    }
}

