/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven.pom;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.plugin.logging.Log;
import se.vandmo.dependencylock.maven.Dependencies;
import se.vandmo.dependencylock.maven.DependenciesLockFile;
import se.vandmo.dependencylock.maven.Dependency;
import se.vandmo.dependencylock.maven.LockFileAccessor;
import se.vandmo.dependencylock.maven.LockedDependencies;
import se.vandmo.dependencylock.maven.PomMinimums;
import se.vandmo.dependencylock.maven.pom.InvalidPomLockFile;
import se.vandmo.dependencylock.maven.pom.PomLockFile;

public final class DependenciesLockFilePom
implements DependenciesLockFile {
    private static final Version VERSION = Configuration.VERSION_2_3_31;
    private final LockFileAccessor dependenciesLockFile;
    private final PomMinimums pomMinimums;
    private final Log log;

    private DependenciesLockFilePom(LockFileAccessor dependenciesLockFile, PomMinimums pomMinimums, Log log) {
        this.dependenciesLockFile = dependenciesLockFile;
        this.pomMinimums = pomMinimums;
        this.log = log;
    }

    public static DependenciesLockFilePom from(LockFileAccessor dependenciesLockFile, PomMinimums pomMinimums, Log log) {
        return new DependenciesLockFilePom(Objects.requireNonNull(dependenciesLockFile), Objects.requireNonNull(pomMinimums), Objects.requireNonNull(log));
    }

    @Override
    public void write(Dependencies projectDependencies) {
        Configuration cfg = DependenciesLockFilePom.createConfiguration();
        try {
            Template template = cfg.getTemplate("pom.ftlx");
            try (Writer writer = this.dependenciesLockFile.writer();){
                template.process(DependenciesLockFilePom.makeDataModel(this.pomMinimums, projectDependencies), writer);
            }
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Object> makeDataModel(PomMinimums pomMinimums, Dependencies artifacts) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("pom", pomMinimums);
        dataModel.put("dependencies", artifacts);
        return dataModel;
    }

    private static Configuration createConfiguration() {
        Configuration cfg = new Configuration(VERSION);
        cfg.setClassForTemplateLoading(DependenciesLockFilePom.class, "");
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setFallbackOnNullLoopVariable(false);
        cfg.setObjectWrapper(DependenciesLockFilePom.getObjectWrapper());
        return cfg;
    }

    private static ObjectWrapper getObjectWrapper() {
        DefaultObjectWrapperBuilder builder = new DefaultObjectWrapperBuilder(VERSION);
        builder.setExposeFields(true);
        builder.setIterableSupport(true);
        return builder.build();
    }

    @Override
    public LockedDependencies read() {
        Dependencies artifacts = Dependencies.fromDependencies((Collection<Dependency>)PomLockFile.read((File)this.dependenciesLockFile.file, (boolean)true).dependencies.orElseThrow(() -> new InvalidPomLockFile("Missing 'dependencies' element")));
        return LockedDependencies.from(artifacts, this.log);
    }
}

