/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven.pom;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import se.vandmo.dependencylock.maven.Dependencies;
import se.vandmo.dependencylock.maven.Dependency;
import se.vandmo.dependencylock.maven.Extensions;
import se.vandmo.dependencylock.maven.LockFileAccessor;
import se.vandmo.dependencylock.maven.LockedProject;
import se.vandmo.dependencylock.maven.Lockfile;
import se.vandmo.dependencylock.maven.Parent;
import se.vandmo.dependencylock.maven.Parents;
import se.vandmo.dependencylock.maven.Plugins;
import se.vandmo.dependencylock.maven.PomMinimums;
import se.vandmo.dependencylock.maven.pom.InvalidPomLockFile;
import se.vandmo.dependencylock.maven.pom.PomLockFile;

public final class LockFilePom
implements Lockfile {
    private static final Version VERSION = Configuration.VERSION_2_3_31;
    private final LockFileAccessor dependenciesLockFile;
    private final PomMinimums pomMinimums;
    private final Log log;

    private LockFilePom(LockFileAccessor dependenciesLockFile, PomMinimums pomMinimums, Log log) {
        this.dependenciesLockFile = dependenciesLockFile;
        this.pomMinimums = pomMinimums;
        this.log = log;
    }

    public static LockFilePom from(LockFileAccessor dependenciesLockFile, PomMinimums pomMinimums, Log log) {
        return new LockFilePom(Objects.requireNonNull(dependenciesLockFile), Objects.requireNonNull(pomMinimums), Objects.requireNonNull(log));
    }

    private void writeFromTemplate(Configuration cfg, Map<String, Object> dataModel, String name) throws IOException, TemplateException {
        Template template = cfg.getTemplate(String.format(Locale.ROOT, "%s-pom.ftlx", name));
        try (Writer writer = this.dependenciesLockFile.writer(name, "pom.xml");){
            template.process(dataModel, writer);
        }
    }

    @Override
    public void write(LockedProject projectDependencies) {
        Configuration cfg = LockFilePom.createConfiguration();
        try {
            Map<String, Object> dataModel = LockFilePom.makeDataModel(this.pomMinimums, projectDependencies);
            Template template = cfg.getTemplate("pom.ftlx");
            try (Writer writer = this.dependenciesLockFile.writer();){
                template.process(dataModel, writer);
            }
            this.writeFromTemplate(cfg, dataModel, "extensions");
            this.writeFromTemplate(cfg, dataModel, "parents");
            this.writeFromTemplate(cfg, dataModel, "plugins");
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Object> makeDataModel(PomMinimums pomMinimums, LockedProject lockedProject) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("pom", pomMinimums);
        dataModel.put("dependencies", lockedProject.dependencies);
        lockedProject.parents.ifPresent(parents -> dataModel.put("parents", parents));
        lockedProject.plugins.ifPresent(plugins -> dataModel.put("plugins", plugins));
        lockedProject.extensions.ifPresent(extensions -> dataModel.put("extensions", extensions));
        return dataModel;
    }

    private static Configuration createConfiguration() {
        Configuration cfg = new Configuration(VERSION);
        cfg.setClassForTemplateLoading(LockFilePom.class, "");
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setFallbackOnNullLoopVariable(false);
        cfg.setObjectWrapper(LockFilePom.getObjectWrapper());
        return cfg;
    }

    private static ObjectWrapper getObjectWrapper() {
        DefaultObjectWrapperBuilder builder = new DefaultObjectWrapperBuilder(VERSION);
        builder.setExposeFields(true);
        builder.setIterableSupport(true);
        return builder.build();
    }

    @Override
    public LockedProject read() throws MojoExecutionException {
        PomLockFile.Contents contents = this.readContents(this.dependenciesLockFile.file, true);
        Dependencies artifacts = Dependencies.fromDependencies((Collection<Dependency>)contents.dependencies.orElseThrow(() -> new InvalidPomLockFile("Missing 'dependencies' element")));
        Optional<Parents> parents = this.maybeReadContents(this.dependenciesLockFile.sibling("parents", "pom.xml"), false).map(parentsContent -> new Parents(parentsContent.dependencies.orElseThrow(() -> new InvalidPomLockFile("Missing 'dependencies' element in parents lock file")).stream().map(parent -> {
            if (parent.optional) {
                throw new InvalidPomLockFile("Parent should not be optional");
            }
            if (!parent.getArtifactIdentifier().type.equals("pom")) {
                throw new InvalidPomLockFile("Parent should be a pom");
            }
            return Parent.builder().artifactIdentifier(parent.getArtifactIdentifier()).version(parent.getVersion()).integrity(parent.getIntegrity()).build();
        }).collect(Collectors.toList())));
        Optional<Plugins> plugins = this.maybeReadContents(this.dependenciesLockFile.sibling("plugins", "pom.xml"), true).map(pluginsContent -> pluginsContent.plugins.map(pluginsInContent -> Plugins.from(pluginsInContent)).orElseThrow(() -> new InvalidPomLockFile("Missing plugins section in plugins lock file")));
        Optional<Extensions> extensions = this.maybeReadContents(this.dependenciesLockFile.sibling("extensions", "pom.xml"), true).map(extensionsContent -> extensionsContent.extensions.map(extensionsInContent -> Extensions.from(extensionsInContent)).orElseThrow(() -> new InvalidPomLockFile("Missing extensions section in extensions lock file")));
        return LockedProject.from(artifacts, parents, plugins, extensions, this.log);
    }

    private Optional<PomLockFile.Contents> maybeReadContents(File file, boolean requireScope) throws MojoExecutionException {
        if (file.isFile()) {
            return Optional.of(this.readContents(file, requireScope));
        }
        return Optional.empty();
    }

    private PomLockFile.Contents readContents(File file, boolean requireScope) throws MojoExecutionException {
        try {
            return PomLockFile.read(file, requireScope);
        }
        catch (InvalidPomLockFile e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

