/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven.pom;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax2.XMLEventReader2;
import se.vandmo.dependencylock.maven.Artifact;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;
import se.vandmo.dependencylock.maven.Artifacts;
import se.vandmo.dependencylock.maven.Dependency;
import se.vandmo.dependencylock.maven.Extension;
import se.vandmo.dependencylock.maven.Plugin;
import se.vandmo.dependencylock.maven.pom.InvalidPomLockFile;

public final class PomLockFile {
    private static final String V2 = "2";
    private static final String POM_NS = "http://maven.apache.org/POM/4.0.0";
    private static final String DEPENDENCY_LOCK_NS = "urn:se.vandmo.dependencylock";
    private static final QName LOCKFILE_VERSION = new QName("urn:se.vandmo.dependencylock", "version");
    private static final QName PROJECT = new QName("http://maven.apache.org/POM/4.0.0", "project");
    private static final QName DEPENDENCIES = new QName("http://maven.apache.org/POM/4.0.0", "dependencies");
    private static final QName DEPENDENCY = new QName("http://maven.apache.org/POM/4.0.0", "dependency");
    private static final QName EXTENSIONS = new QName("http://maven.apache.org/POM/4.0.0", "extensions");
    private static final QName BUILD = new QName("http://maven.apache.org/POM/4.0.0", "build");
    private static final QName EXTENSION = new QName("http://maven.apache.org/POM/4.0.0", "extension");
    private static final QName PLUGINS = new QName("http://maven.apache.org/POM/4.0.0", "plugins");
    private static final QName PLUGIN = new QName("http://maven.apache.org/POM/4.0.0", "plugin");
    private static final QName GROUP_ID = new QName("http://maven.apache.org/POM/4.0.0", "groupId");
    private static final QName ARTIFACT_ID = new QName("http://maven.apache.org/POM/4.0.0", "artifactId");
    private static final QName VERSION = new QName("http://maven.apache.org/POM/4.0.0", "version");
    private static final QName TYPE = new QName("http://maven.apache.org/POM/4.0.0", "type");
    private static final QName SCOPE = new QName("http://maven.apache.org/POM/4.0.0", "scope");
    private static final QName CLASSIFIER = new QName("http://maven.apache.org/POM/4.0.0", "classifier");
    private static final QName OPTIONAL = new QName("http://maven.apache.org/POM/4.0.0", "optional");
    private static final QName INTEGRITY = new QName("urn:se.vandmo.dependencylock", "integrity");

    public static Contents read(File file, boolean requireScope) throws InvalidPomLockFile {
        try {
            return PomLockFile.doRead(file, requireScope);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (XMLStreamException e) {
            throw new InvalidPomLockFile(e);
        }
    }

    private static Contents doRead(File file, boolean requireScope) throws IOException, XMLStreamException {
        WstxInputFactory inputFactory = PomLockFile.createInputFactory();
        XMLEventReader2 reader = inputFactory.createXMLEventReader(file);
        while (reader.hasNextEvent()) {
            XMLEvent evt = reader.nextEvent();
            if (!evt.isStartElement()) continue;
            StartElement element = evt.asStartElement();
            QName name = element.getName();
            if (!name.equals(PROJECT)) {
                throw new InvalidPomLockFile("Expected 'project'-element", evt.getLocation());
            }
            Attribute attribute = element.getAttributeByName(LOCKFILE_VERSION);
            if (attribute == null) {
                return PomLockFile.fromProject(reader, requireScope);
            }
            String version = attribute.getValue();
            if (version.equals(V2)) {
                return PomLockFile.fromProjectV2(reader, requireScope);
            }
            throw new InvalidPomLockFile(String.format(Locale.ROOT, "Unexpected lock file version \"%s\". The file might have been generated by a newer version of this plugin than is used for this check.", version));
        }
        throw new InvalidPomLockFile("Ended prematurely");
    }

    private static WstxInputFactory createInputFactory() {
        WstxInputFactory inputFactory = new WstxInputFactory();
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", (Object)false);
        inputFactory.setProperty("javax.xml.stream.supportDTD", (Object)false);
        inputFactory.setProperty("javax.xml.stream.isCoalescing", (Object)true);
        inputFactory.setProperty("javax.xml.stream.isValidating", (Object)false);
        return inputFactory;
    }

    private static Contents fromProject(XMLEventReader2 reader, boolean requireScope) throws XMLStreamException {
        List<Dependency> dependencies = null;
        while (reader.hasNextEvent()) {
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement()) continue;
            QName name = event.asStartElement().getName();
            if (name.equals(DEPENDENCIES)) {
                if (null != dependencies) {
                    throw new InvalidPomLockFile("Duplicate 'dependencies' element");
                }
                dependencies = PomLockFile.fromDependencies(reader, requireScope);
                continue;
            }
            PomLockFile.skipElement(reader);
        }
        if (null == dependencies) {
            throw new InvalidPomLockFile("Missing 'dependencies' element");
        }
        return new Contents(dependencies);
    }

    private static Contents fromProjectV2(XMLEventReader2 reader, boolean requireScope) throws XMLStreamException {
        List<Dependency> dependencies = null;
        List<Plugin> plugins = null;
        List<Extension> extensions = null;
        boolean inBuild = false;
        boolean buildFound = false;
        while (reader.hasNextEvent()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                QName name = event.asStartElement().getName();
                if (name.equals(DEPENDENCIES)) {
                    if (null != dependencies) {
                        throw new InvalidPomLockFile("Duplicate 'dependencies' element");
                    }
                    dependencies = PomLockFile.fromDependencies(reader, requireScope);
                    continue;
                }
                if (name.equals(BUILD)) {
                    if (buildFound) {
                        throw new InvalidPomLockFile("Duplicate 'build' element");
                    }
                    buildFound = true;
                    inBuild = true;
                    continue;
                }
                if (inBuild && name.equals(EXTENSIONS)) {
                    if (null != extensions) {
                        throw new InvalidPomLockFile("Duplicate 'extensions' element");
                    }
                    extensions = PomLockFile.fromExtensions(reader);
                    continue;
                }
                if (inBuild && name.equals(PLUGINS)) {
                    if (null != plugins) {
                        throw new InvalidPomLockFile("Duplicate 'plugins' element");
                    }
                    plugins = PomLockFile.fromPlugins(reader);
                    continue;
                }
                PomLockFile.skipElement(reader);
                continue;
            }
            if (!event.isEndElement() || !event.asEndElement().getName().equals(BUILD)) continue;
            inBuild = false;
        }
        if (buildFound) {
            return new Contents(Optional.ofNullable(dependencies), Optional.ofNullable(plugins), Optional.ofNullable(extensions));
        }
        return new Contents(dependencies);
    }

    private static List<Dependency> fromDependencies(XMLEventReader2 rdr, boolean requireScope) throws XMLStreamException {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        while (rdr.hasNextEvent()) {
            QName name;
            XMLEvent evt = rdr.nextEvent();
            if (evt.isStartElement()) {
                name = evt.asStartElement().getName();
                if (!name.equals(DEPENDENCY)) {
                    PomLockFile.skipElement(rdr);
                    continue;
                }
                result.add(PomLockFile.fromDependency(rdr, requireScope));
                continue;
            }
            if (!evt.isEndElement() || !(name = evt.asEndElement().getName()).equals(DEPENDENCIES)) continue;
            return result;
        }
        throw new InvalidPomLockFile("Ended prematurely");
    }

    private static List<Artifact> fromPluginDependencies(XMLEventReader2 rdr) throws XMLStreamException {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        while (rdr.hasNextEvent()) {
            QName name;
            XMLEvent evt = rdr.nextEvent();
            if (evt.isStartElement()) {
                name = evt.asStartElement().getName();
                if (!name.equals(DEPENDENCY)) {
                    PomLockFile.skipElement(rdr);
                    continue;
                }
                result.add(PomLockFile.fromPluginDependency(rdr));
                continue;
            }
            if (!evt.isEndElement() || !(name = evt.asEndElement().getName()).equals(DEPENDENCIES)) continue;
            return result;
        }
        throw new InvalidPomLockFile("Ended prematurely");
    }

    private static List<Extension> fromExtensions(XMLEventReader2 rdr) throws XMLStreamException {
        ArrayList<Extension> result = new ArrayList<Extension>();
        while (rdr.hasNextEvent()) {
            QName name;
            XMLEvent evt = rdr.nextEvent();
            if (evt.isStartElement()) {
                name = evt.asStartElement().getName();
                if (!name.equals(EXTENSION)) {
                    PomLockFile.skipElement(rdr);
                    continue;
                }
                result.add(PomLockFile.fromExtension(rdr));
                continue;
            }
            if (!evt.isEndElement() || !(name = evt.asEndElement().getName()).equals(EXTENSIONS)) continue;
            return result;
        }
        throw new InvalidPomLockFile("Ended prematurely");
    }

    private static List<Plugin> fromPlugins(XMLEventReader2 rdr) throws XMLStreamException {
        ArrayList<Plugin> result = new ArrayList<Plugin>();
        while (rdr.hasNextEvent()) {
            QName name;
            XMLEvent evt = rdr.nextEvent();
            if (evt.isStartElement()) {
                name = evt.asStartElement().getName();
                if (!name.equals(PLUGIN)) {
                    PomLockFile.skipElement(rdr);
                    continue;
                }
                result.add(PomLockFile.fromPlugin(rdr));
                continue;
            }
            if (!evt.isEndElement() || !(name = evt.asEndElement().getName()).equals(PLUGINS)) continue;
            return result;
        }
        throw new InvalidPomLockFile("Ended prematurely");
    }

    private static Dependency fromDependency(XMLEventReader2 rdr, boolean requireScope) throws XMLStreamException {
        String groupId = null;
        String artifactId = null;
        String version = null;
        String type = null;
        String scope = null;
        String classifier = null;
        Boolean optional = null;
        String integrity = null;
        while (rdr.hasNextEvent()) {
            XMLEvent event = rdr.nextEvent();
            if (event.isStartElement()) {
                Location startElementLocation = event.getLocation();
                QName name = event.asStartElement().getName();
                if (name.equals(GROUP_ID)) {
                    groupId = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(ARTIFACT_ID)) {
                    artifactId = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(VERSION)) {
                    version = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(TYPE)) {
                    type = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(SCOPE)) {
                    scope = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(CLASSIFIER)) {
                    classifier = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(OPTIONAL)) {
                    String optionalStr;
                    switch (optionalStr = PomLockFile.readSingleTextElement(rdr)) {
                        case "false": {
                            optional = false;
                            break;
                        }
                        case "true": {
                            optional = true;
                            break;
                        }
                        default: {
                            throw new InvalidPomLockFile(String.format(Locale.ROOT, "Invalid optional value '%s' for dependency", optionalStr), startElementLocation);
                        }
                    }
                    continue;
                }
                if (name.equals(INTEGRITY)) {
                    integrity = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                PomLockFile.skipElement(rdr);
                continue;
            }
            if (!event.isEndElement()) continue;
            if (!event.asEndElement().getName().equals(DEPENDENCY)) {
                throw new InvalidPomLockFile("Expected '</dependency>'", event.getLocation());
            }
            PomLockFile.validateArtifact(groupId, artifactId, version, event);
            if (type == null) {
                throw new InvalidPomLockFile("Missing type", event.getLocation());
            }
            if (scope == null) {
                if (requireScope) {
                    throw new InvalidPomLockFile("Missing scope", event.getLocation());
                }
                scope = "";
            }
            if (optional == null) {
                if (requireScope) {
                    throw new InvalidPomLockFile("Missing optional", event.getLocation());
                }
                optional = false;
            }
            if (integrity == null) {
                throw new InvalidPomLockFile("Missing integrity", event.getLocation());
            }
            return Dependency.builder().artifactIdentifier(ArtifactIdentifier.builder().groupId(groupId).artifactId(artifactId).classifier(Optional.ofNullable(classifier)).type(type).build()).version(version).integrity(integrity).scope(scope).optional(optional).build();
        }
        throw new InvalidPomLockFile("Ended prematurely");
    }

    private static Artifact fromPluginDependency(XMLEventReader2 rdr) throws XMLStreamException {
        String groupId = null;
        String artifactId = null;
        String version = null;
        String type = null;
        String classifier = null;
        String integrity = null;
        while (rdr.hasNextEvent()) {
            XMLEvent event = rdr.nextEvent();
            if (event.isStartElement()) {
                QName name = event.asStartElement().getName();
                if (name.equals(GROUP_ID)) {
                    groupId = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(ARTIFACT_ID)) {
                    artifactId = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(VERSION)) {
                    version = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(TYPE)) {
                    type = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(CLASSIFIER)) {
                    classifier = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(INTEGRITY)) {
                    integrity = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                PomLockFile.skipElement(rdr);
                continue;
            }
            if (!event.isEndElement()) continue;
            if (!event.asEndElement().getName().equals(DEPENDENCY)) {
                throw new InvalidPomLockFile("Expected '</dependency>'", event.getLocation());
            }
            PomLockFile.validateArtifact(groupId, artifactId, version, event);
            if (type == null) {
                throw new InvalidPomLockFile("Missing type", event.getLocation());
            }
            if (integrity == null) {
                throw new InvalidPomLockFile("Missing integrity", event.getLocation());
            }
            return Artifact.builder().artifactIdentifier(ArtifactIdentifier.builder().groupId(groupId).artifactId(artifactId).classifier(Optional.ofNullable(classifier)).type(type).build()).version(version).integrity(integrity).build();
        }
        throw new InvalidPomLockFile("Ended prematurely");
    }

    private static Extension fromExtension(XMLEventReader2 rdr) throws XMLStreamException {
        String groupId = null;
        String artifactId = null;
        String version = null;
        String integrity = null;
        while (rdr.hasNextEvent()) {
            XMLEvent event = rdr.nextEvent();
            if (event.isStartElement()) {
                QName name = event.asStartElement().getName();
                if (name.equals(GROUP_ID)) {
                    groupId = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(ARTIFACT_ID)) {
                    artifactId = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(VERSION)) {
                    version = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(INTEGRITY)) {
                    integrity = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                PomLockFile.skipElement(rdr);
                continue;
            }
            if (!event.isEndElement()) continue;
            if (!event.asEndElement().getName().equals(EXTENSION)) {
                throw new InvalidPomLockFile("Expected '</extension>'", event.getLocation());
            }
            PomLockFile.validateArtifactWithIntegrity(groupId, artifactId, version, integrity, event);
            return Extension.builder().artifactIdentifier(ArtifactIdentifier.builder().groupId(groupId).artifactId(artifactId).type("maven-plugin").build()).version(version).integrity(integrity).build();
        }
        throw new InvalidPomLockFile("Ended prematurely");
    }

    private static void validateArtifactWithIntegrity(String groupId, String artifactId, String version, String integrity, XMLEvent event) {
        PomLockFile.validateArtifact(groupId, artifactId, version, event);
        if (integrity == null) {
            throw new InvalidPomLockFile("Missing integrity", event.getLocation());
        }
    }

    private static void validateArtifact(String groupId, String artifactId, String version, XMLEvent event) {
        if (groupId == null) {
            throw new InvalidPomLockFile("Missing groupId", event.getLocation());
        }
        if (artifactId == null) {
            throw new InvalidPomLockFile("Missing artifactId", event.getLocation());
        }
        if (version == null) {
            throw new InvalidPomLockFile("Missing version", event.getLocation());
        }
    }

    private static Plugin fromPlugin(XMLEventReader2 rdr) throws XMLStreamException {
        String groupId = null;
        String artifactId = null;
        String version = null;
        String integrity = null;
        List<Artifact> artifacts = Collections.emptyList();
        while (rdr.hasNextEvent()) {
            XMLEvent event = rdr.nextEvent();
            if (event.isStartElement()) {
                QName name = event.asStartElement().getName();
                if (name.equals(GROUP_ID)) {
                    groupId = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(ARTIFACT_ID)) {
                    artifactId = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(VERSION)) {
                    version = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(INTEGRITY)) {
                    integrity = PomLockFile.readSingleTextElement(rdr);
                    continue;
                }
                if (name.equals(DEPENDENCIES)) {
                    artifacts = PomLockFile.fromPluginDependencies(rdr);
                    continue;
                }
                PomLockFile.skipElement(rdr);
                continue;
            }
            if (!event.isEndElement()) continue;
            if (!event.asEndElement().getName().equals(PLUGIN)) {
                throw new InvalidPomLockFile("Expected '</plugin>'", event.getLocation());
            }
            PomLockFile.validateArtifactWithIntegrity(groupId, artifactId, version, integrity, event);
            return Plugin.builder().artifactIdentifier(ArtifactIdentifier.builder().groupId(groupId).artifactId(artifactId).type("maven-plugin").build()).version(version).integrity(integrity).artifacts(Artifacts.fromArtifacts(artifacts)).build();
        }
        throw new InvalidPomLockFile("Ended prematurely");
    }

    private static String readSingleTextElement(XMLEventReader2 reader) throws XMLStreamException {
        XMLEvent characterEvent = PomLockFile.expectEvent(reader);
        if (!characterEvent.isCharacters()) {
            throw new InvalidPomLockFile("Expected characters", characterEvent.getLocation());
        }
        String content = characterEvent.asCharacters().getData();
        XMLEvent endElementEvent = PomLockFile.expectEvent(reader);
        if (!endElementEvent.isEndElement()) {
            throw new InvalidPomLockFile("Expected end of text element", endElementEvent.getLocation());
        }
        return content;
    }

    private static XMLEvent expectEvent(XMLEventReader2 reader) throws XMLStreamException {
        if (!reader.hasNextEvent()) {
            throw new InvalidPomLockFile("Ended prematurely");
        }
        return reader.nextEvent();
    }

    private static void skipElement(XMLEventReader2 reader) throws XMLStreamException {
        int level = 0;
        while (reader.hasNextEvent() && level >= 0) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                ++level;
                continue;
            }
            if (!event.isEndElement()) continue;
            --level;
        }
    }

    public static final class Contents {
        public final Optional<List<Dependency>> dependencies;
        public final Optional<List<Plugin>> plugins;
        public final Optional<List<Extension>> extensions;

        public Contents(List<Dependency> dependencies) {
            this(Optional.of(dependencies), Optional.empty(), Optional.empty());
        }

        public Contents(Optional<List<Dependency>> dependencies, Optional<List<Plugin>> plugins, Optional<List<Extension>> extensions) {
            this.dependencies = dependencies.map(d -> Collections.unmodifiableList(new ArrayList(d)));
            this.plugins = plugins;
            this.extensions = extensions;
        }
    }
}

