/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.repl.ConstructorCleaner;
import org.apache.spark.util.ParentClassLoader;
import org.apache.spark.util.Utils$;
import org.apache.xbean.asm6.ClassReader;
import org.apache.xbean.asm6.ClassVisitor;
import org.apache.xbean.asm6.ClassWriter;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u000e\u001d\u0001\u0015B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003'\u0011!a\u0005A!A!\u0002\u0013i\u0005\"B)\u0001\t\u0003\u0011\u0006b\u0002.\u0001\u0005\u0004%\ta\u0017\u0005\u0007E\u0002\u0001\u000b\u0011\u0002/\t\u000f\r\u0004!\u0019!C\u0001I\"1q\r\u0001Q\u0001\n\u0015Dq\u0001\u001b\u0001C\u0002\u0013\u0005\u0011\u000e\u0003\u0004q\u0001\u0001\u0006IA\u001b\u0005\tc\u0002\u0001\r\u0011\"\u0001\u001de\"Aa\u000f\u0001a\u0001\n\u0003ar\u000f\u0003\u0004~\u0001\u0001\u0006Ka\u001d\u0005\b}\u0002\u0011\r\u0011\"\u0003\u0000\u0011!\t\u0019\u0002\u0001Q\u0001\n\u0005\u0005\u0001bBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u0003G\u0001A\u0011IA\u0013\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!a\u0016\u0001\t\u0013\tI\u0006C\u0004\u0002`\u0001!I!!\u0019\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u00111\u0011\u0001\u0005\u0002\u0005\u0015\u0005bBAM\u0001\u0011\u0005\u00111\u0014\u0005\b\u0003_\u0003A\u0011AAY\u0005M)\u00050Z2vi>\u00148\t\\1tg2{\u0017\rZ3s\u0015\tib$\u0001\u0003sKBd'BA\u0010!\u0003\u0015\u0019\b/\u0019:l\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\n\u0018\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013\u0001\u00027b]\u001eT\u0011aK\u0001\u0005U\u00064\u0018-\u0003\u0002.Q\tY1\t\\1tg2{\u0017\rZ3s!\ty#'D\u00011\u0015\t\td$\u0001\u0005j]R,'O\\1m\u0013\t\u0019\u0004GA\u0004M_\u001e<\u0017N\\4\u0002\t\r|gN\u001a\t\u0003m]j\u0011AH\u0005\u0003qy\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\u0007\u0015tg\u000f\u0005\u00027w%\u0011AH\b\u0002\t'B\f'o[#om\u0006A1\r\\1tgV\u0013\u0018\u000e\u0005\u0002@\u0011:\u0011\u0001I\u0012\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007\u0012\na\u0001\u0010:p_Rt$\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#\u0015A\u0002)sK\u0012,g-\u0003\u0002J\u0015\n11\u000b\u001e:j]\u001eT!a\u0012#\u0002\rA\f'/\u001a8u\u0003I)8/\u001a:DY\u0006\u001c8\u000fU1uQ\u001aK'o\u001d;\u0011\u00059{U\"\u0001#\n\u0005A#%a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\rM+fk\u0016-Z!\t!\u0006!D\u0001\u001d\u0011\u0015!d\u00011\u00016\u0011\u0015Id\u00011\u0001;\u0011\u0015id\u00011\u0001?\u0011\u0015Ye\u00011\u0001'\u0011\u0015ae\u00011\u0001N\u0003\r)(/[\u000b\u00029B\u0011Q\fY\u0007\u0002=*\u0011qLK\u0001\u0004]\u0016$\u0018BA1_\u0005\r)&+S\u0001\u0005kJL\u0007%A\u0005eSJ,7\r^8ssV\tQ\r\u0005\u0002(M&\u0011\u0011\nK\u0001\u000bI&\u0014Xm\u0019;pef\u0004\u0013\u0001\u00049be\u0016tG\u000fT8bI\u0016\u0014X#\u00016\u0011\u0005-tW\"\u00017\u000b\u00055t\u0012\u0001B;uS2L!a\u001c7\u0003#A\u000b'/\u001a8u\u00072\f7o\u001d'pC\u0012,'/A\u0007qCJ,g\u000e\u001e'pC\u0012,'\u000fI\u0001\u001fQR$\b/\u0016:m\u0007>tg.Z2uS>tG+[7f_V$X*\u001b7mSN,\u0012a\u001d\t\u0003\u001dRL!!\u001e#\u0003\u0007%sG/\u0001\u0012iiR\u0004XK\u001d7D_:tWm\u0019;j_:$\u0016.\\3pkRl\u0015\u000e\u001c7jg~#S-\u001d\u000b\u0003qn\u0004\"AT=\n\u0005i$%\u0001B+oSRDq\u0001 \b\u0002\u0002\u0003\u00071/A\u0002yIE\nq\u0004\u001b;uaV\u0013HnQ8o]\u0016\u001cG/[8o)&lWm\\;u\u001b&dG.[:!\u0003\u001d1W\r^2i\r:,\"!!\u0001\u0011\r9\u000b\u0019APA\u0004\u0013\r\t)\u0001\u0012\u0002\n\rVt7\r^5p]F\u0002B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001bQ\u0013AA5p\u0013\u0011\t\t\"a\u0003\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\tM\u0016$8\r\u001b$oA\u0005Yq-\u001a;SKN|WO]2f)\u0011\tI\"a\b\u0011\u0007u\u000bY\"C\u0002\u0002\u001ey\u00131!\u0016*M\u0011\u0019\t\tC\u0005a\u0001}\u0005!a.Y7f\u000319W\r\u001e*fg>,(oY3t)\u0011\t9#!\r\u0011\r\u0005%\u0012QFA\r\u001b\t\tYC\u0003\u0002nU%!\u0011qFA\u0016\u0005-)e.^7fe\u0006$\u0018n\u001c8\t\r\u0005\u00052\u00031\u0001?\u0003%1\u0017N\u001c3DY\u0006\u001c8\u000f\u0006\u0003\u00028\u0005U\u0003\u0007BA\u001d\u0003\u0007\u0002RaPA\u001e\u0003\u007fI1!!\u0010K\u0005\u0015\u0019E.Y:t!\u0011\t\t%a\u0011\r\u0001\u0011Y\u0011Q\t\u000b\u0002\u0002\u0003\u0005)\u0011AA$\u0005\ryF%M\t\u0005\u0003\u0013\ny\u0005E\u0002O\u0003\u0017J1!!\u0014E\u0005\u001dqu\u000e\u001e5j]\u001e\u00042ATA)\u0013\r\t\u0019\u0006\u0012\u0002\u0004\u0003:L\bBBA\u0011)\u0001\u0007a(A\u0012hKR\u001cE.Y:t\r&dW-\u00138qkR\u001cFO]3b[\u001a\u0013x.\\*qCJ\\'\u000bU\"\u0015\t\u0005\u001d\u00111\f\u0005\u0007\u0003;*\u0002\u0019\u0001 \u0002\tA\fG\u000f[\u0001&O\u0016$8\t\\1tg\u001aKG.Z%oaV$8\u000b\u001e:fC64%o\\7IiR\u00048+\u001a:wKJ$B!a\u0002\u0002d!1\u0011Q\r\fA\u0002y\nq\u0002]1uQ&sG)\u001b:fGR|'/_\u0001&O\u0016$8\t\\1tg\u001aKG.Z%oaV$8\u000b\u001e:fC64%o\\7GS2,7+_:uK6$B!a\u001b\u0002pQ!\u0011qAA7\u0011\u0019\t)g\u0006a\u0001}!9\u0011\u0011O\fA\u0002\u0005M\u0014A\u00034jY\u0016\u001c\u0016p\u001d;f[B!\u0011QOA@\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014A\u00014t\u0015\r\ti\bI\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005\u0005\u0015q\u000f\u0002\u000b\r&dWmU=ti\u0016l\u0017\u0001\u00054j]\u0012\u001cE.Y:t\u0019>\u001c\u0017\r\u001c7z)\u0011\t9)a&\u0011\u000b9\u000bI)!$\n\u0007\u0005-EI\u0001\u0004PaRLwN\u001c\u0019\u0005\u0003\u001f\u000b\u0019\nE\u0003@\u0003w\t\t\n\u0005\u0003\u0002B\u0005MEaCAK1\u0005\u0005\t\u0011!B\u0001\u0003\u000f\u00121a\u0018\u00133\u0011\u0019\t\t\u0003\u0007a\u0001}\u0005)\"/Z1e\u0003:$GK]1og\u001a|'/\\\"mCN\u001cHCBAO\u0003S\u000bY\u000bE\u0003O\u0003?\u000b\u0019+C\u0002\u0002\"\u0012\u0013Q!\u0011:sCf\u00042ATAS\u0013\r\t9\u000b\u0012\u0002\u0005\u0005f$X\r\u0003\u0004\u0002\"e\u0001\rA\u0010\u0005\b\u0003[K\u0002\u0019AA\u0004\u0003\tIg.A\u0005ve2,enY8eKR\u0019a(a-\t\r\u0005U&\u00041\u0001?\u0003\r\u0019HO\u001d")
public class ExecutorClassLoader
extends ClassLoader
implements Logging {
    private final SparkEnv env;
    private final String classUri;
    private final boolean userClassPathFirst;
    private final URI uri;
    private final String directory;
    private final ParentClassLoader parentLoader;
    private int httpUrlConnectionTimeoutMillis;
    private final Function1<String, InputStream> fetchFn;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public URI uri() {
        return this.uri;
    }

    public String directory() {
        return this.directory;
    }

    public ParentClassLoader parentLoader() {
        return this.parentLoader;
    }

    public int httpUrlConnectionTimeoutMillis() {
        return this.httpUrlConnectionTimeoutMillis;
    }

    public void httpUrlConnectionTimeoutMillis_$eq(int x$1) {
        this.httpUrlConnectionTimeoutMillis = x$1;
    }

    private Function1<String, InputStream> fetchFn() {
        return this.fetchFn;
    }

    @Override
    public URL getResource(String name) {
        return this.parentLoader().getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        return this.parentLoader().getResources(name);
    }

    @Override
    public Class<?> findClass(String name) {
        Class clazz;
        if (this.userClassPathFirst) {
            clazz = (Class)this.findClassLocally(name).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.parentLoader().loadClass(name));
        } else {
            try {
                clazz = this.parentLoader().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                Class a;
                Option<Class<?>> classOption;
                Option<Class<?>> option = classOption = this.findClassLocally(name);
                if (None$.MODULE$.equals(option)) {
                    throw new ClassNotFoundException(name, e);
                }
                if (!(option instanceof Some)) {
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                Class clazz2 = a = (Class)some.value();
                clazz = clazz2;
            }
        }
        return clazz;
    }

    private InputStream getClassFileInputStreamFromSparkRPC(String path) {
        ReadableByteChannel channel = this.env.rpcEnv().openChannel(new StringBuilder(1).append(this.classUri).append("/").append(path).toString());
        return new FilterInputStream(null, channel, path){
            private final String path$1;

            private /* synthetic */ int super$read() {
                return super.read();
            }

            private /* synthetic */ int super$read(byte[] x$1) {
                return super.read(x$1);
            }

            private /* synthetic */ int super$read(byte[] x$1, int x$2, int x$3) {
                return super.read(x$1, x$2, x$3);
            }

            public int read() {
                return this.toClassNotFound((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.super$read());
            }

            public int read(byte[] b) {
                return this.toClassNotFound((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.super$read(b));
            }

            public int read(byte[] b, int offset, int len) {
                return this.toClassNotFound((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.super$read(b, offset, len));
            }

            private int toClassNotFound(Function0<Object> fn) {
                int n;
                try {
                    n = fn.apply$mcI$sp();
                }
                catch (Exception e) {
                    throw new ClassNotFoundException(this.path$1, e);
                }
                return n;
            }
            {
                this.path$1 = path$1;
                super(Channels.newInputStream(channel$1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$1(org.apache.spark.repl.ExecutorClassLoader$$anon$1 ), $anonfun$read$2(org.apache.spark.repl.ExecutorClassLoader$$anon$1 byte[] ), $anonfun$read$3(org.apache.spark.repl.ExecutorClassLoader$$anon$1 byte[] int int )}, serializedLambda);
            }
        };
    }

    private InputStream getClassFileInputStreamFromHttpServer(String pathInDirectory) {
        InputStream inputStream;
        URL uRL;
        if (SparkEnv$.MODULE$.get().securityManager().isAuthenticationEnabled()) {
            URI uri = new URI(new StringBuilder(1).append(this.classUri).append("/").append(this.urlEncode(pathInDirectory)).toString());
            URI newuri = Utils$.MODULE$.constructURIForAuthentication(uri, SparkEnv$.MODULE$.get().securityManager());
            uRL = newuri.toURL();
        } else {
            uRL = new URL(new StringBuilder(1).append(this.classUri).append("/").append(this.urlEncode(pathInDirectory)).toString());
        }
        URL url = uRL;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (this.httpUrlConnectionTimeoutMillis() != -1) {
            connection.setConnectTimeout(this.httpUrlConnectionTimeoutMillis());
            connection.setReadTimeout(this.httpUrlConnectionTimeoutMillis());
        }
        connection.connect();
        try {
            if (connection.getResponseCode() != 200) {
                try {
                    connection.getErrorStream().close();
                }
                catch (IOException ioe) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while closing error stream", ioe);
                }
                throw new ClassNotFoundException(new StringBuilder(28).append("Class file not found at URL ").append(url).toString());
            }
            inputStream = connection.getInputStream();
        }
        catch (Throwable throwable) {
            Throwable e;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty() && !((e = (Throwable)option.get()) instanceof ClassNotFoundException)) {
                connection.disconnect();
                throw e;
            }
            throw throwable;
        }
        return inputStream;
    }

    private InputStream getClassFileInputStreamFromFileSystem(FileSystem fileSystem, String pathInDirectory) {
        FSDataInputStream fSDataInputStream;
        Path path = new Path(this.directory(), pathInDirectory);
        try {
            fSDataInputStream = fileSystem.open(path);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ClassNotFoundException(new StringBuilder(29).append("Class file not found at path ").append(path).toString());
        }
        return fSDataInputStream;
    }

    public Option<Class<?>> findClassLocally(String name) {
        None$ none$;
        block10: {
            None$ none$2;
            String pathInDirectory = new StringBuilder(6).append(name.replace('.', '/')).append(".class").toString();
            InputStream inputStream = null;
            try {
                try {
                    inputStream = (InputStream)this.fetchFn().apply((Object)pathInDirectory);
                    byte[] bytes = this.readAndTransformClass(name, inputStream);
                    none$2 = new Some(this.defineClass(name, bytes, 0, bytes.length));
                }
                catch (ClassNotFoundException e) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Did not load class ").append(name).append(" from REPL class server at ").append(this.uri()).toString(), e);
                    none$2 = None$.MODULE$;
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Failed to check existence of class ").append(name).append(" on REPL class server at ").append(this.uri()).toString(), e);
                    none$2 = None$.MODULE$;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while closing inputStream", e);
                    }
                }
                throw throwable;
            }
            none$ = none$2;
            if (inputStream == null) break block10;
            try {
                inputStream.close();
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while closing inputStream", e);
            }
        }
        return none$;
    }

    public byte[] readAndTransformClass(String name, InputStream in) {
        if (name.startsWith("line") && name.endsWith("$iw$")) {
            ClassReader cr = new ClassReader(in);
            ClassWriter cw = new ClassWriter(3);
            ConstructorCleaner cleaner = new ConstructorCleaner(name, (ClassVisitor)cw);
            cr.accept((ClassVisitor)cleaner, 0);
            return cw.toByteArray();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] bytes = new byte[4096];
        boolean done = false;
        while (!done) {
            int num = in.read(bytes);
            if (num >= 0) {
                bos.write(bytes, 0, num);
                continue;
            }
            done = true;
        }
        return bos.toByteArray();
    }

    public String urlEncode(String str) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(str)).split('/'))).map((Function1 & Serializable & scala.Serializable)part -> URLEncoder.encode(part, "UTF-8"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("/");
    }

    public ExecutorClassLoader(SparkConf conf, SparkEnv env, String classUri, ClassLoader parent, boolean userClassPathFirst) {
        Function1 & Serializable & scala.Serializable intersect;
        this.env = env;
        this.classUri = classUri;
        this.userClassPathFirst = userClassPathFirst;
        super(null);
        Logging.$init$((Logging)this);
        this.uri = new URI(classUri);
        this.directory = this.uri().getPath();
        this.parentLoader = new ParentClassLoader(parent);
        this.httpUrlConnectionTimeoutMillis = -1;
        String string = this.uri().getScheme();
        if ("spark".equals(string)) {
            intersect = (Function1 & Serializable & scala.Serializable)path -> this.getClassFileInputStreamFromSparkRPC((String)path);
        } else {
            boolean bl = "http".equals(string) ? true : ("https".equals(string) ? true : "ftp".equals(string));
            if (bl) {
                intersect = (Function1 & Serializable & scala.Serializable)pathInDirectory -> this.getClassFileInputStreamFromHttpServer((String)pathInDirectory);
            } else {
                FileSystem fileSystem = FileSystem.get((URI)this.uri(), (Configuration)SparkHadoopUtil$.MODULE$.get().newConfiguration(conf));
                intersect = (Function1 & Serializable & scala.Serializable)pathInDirectory -> this.getClassFileInputStreamFromFileSystem(fileSystem, (String)pathInDirectory);
            }
        }
        this.fetchFn = intersect;
    }
}

