/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import sh.ory.hydra.ApiCallback;
import sh.ory.hydra.ApiClient;
import sh.ory.hydra.ApiException;
import sh.ory.hydra.ApiResponse;
import sh.ory.hydra.Configuration;
import sh.ory.hydra.Pair;
import sh.ory.hydra.model.JSONWebKeySet;
import sh.ory.hydra.model.OAuth2Client;
import sh.ory.hydra.model.Oauth2TokenResponse;
import sh.ory.hydra.model.UserinfoResponse;
import sh.ory.hydra.model.WellKnown;

public class PublicApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PublicApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PublicApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call disconnectUserCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/sessions/logout";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call disconnectUserValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.disconnectUserCall(_callback);
        return localVarCall;
    }

    public void disconnectUser() throws ApiException {
        this.disconnectUserWithHttpInfo();
    }

    public ApiResponse<Void> disconnectUserWithHttpInfo() throws ApiException {
        Call localVarCall = this.disconnectUserValidateBeforeCall(null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call disconnectUserAsync(ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.disconnectUserValidateBeforeCall(_callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call discoverOpenIDConfigurationCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/.well-known/openid-configuration";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call discoverOpenIDConfigurationValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.discoverOpenIDConfigurationCall(_callback);
        return localVarCall;
    }

    public WellKnown discoverOpenIDConfiguration() throws ApiException {
        ApiResponse<WellKnown> localVarResp = this.discoverOpenIDConfigurationWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<WellKnown> discoverOpenIDConfigurationWithHttpInfo() throws ApiException {
        Call localVarCall = this.discoverOpenIDConfigurationValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<WellKnown>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call discoverOpenIDConfigurationAsync(ApiCallback<WellKnown> _callback) throws ApiException {
        Call localVarCall = this.discoverOpenIDConfigurationValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<WellKnown>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call dynamicClientRegistrationCreateOAuth2ClientCall(OAuth2Client oauth2Client, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OAuth2Client localVarPostBody = oauth2Client;
        String localVarPath = "/connect/register";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call dynamicClientRegistrationCreateOAuth2ClientValidateBeforeCall(OAuth2Client oauth2Client, ApiCallback _callback) throws ApiException {
        if (oauth2Client == null) {
            throw new ApiException("Missing the required parameter 'oauth2Client' when calling dynamicClientRegistrationCreateOAuth2Client(Async)");
        }
        Call localVarCall = this.dynamicClientRegistrationCreateOAuth2ClientCall(oauth2Client, _callback);
        return localVarCall;
    }

    public OAuth2Client dynamicClientRegistrationCreateOAuth2Client(OAuth2Client oauth2Client) throws ApiException {
        ApiResponse<OAuth2Client> localVarResp = this.dynamicClientRegistrationCreateOAuth2ClientWithHttpInfo(oauth2Client);
        return localVarResp.getData();
    }

    public ApiResponse<OAuth2Client> dynamicClientRegistrationCreateOAuth2ClientWithHttpInfo(OAuth2Client oauth2Client) throws ApiException {
        Call localVarCall = this.dynamicClientRegistrationCreateOAuth2ClientValidateBeforeCall(oauth2Client, null);
        Type localVarReturnType = new TypeToken<OAuth2Client>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call dynamicClientRegistrationCreateOAuth2ClientAsync(OAuth2Client oauth2Client, ApiCallback<OAuth2Client> _callback) throws ApiException {
        Call localVarCall = this.dynamicClientRegistrationCreateOAuth2ClientValidateBeforeCall(oauth2Client, _callback);
        Type localVarReturnType = new TypeToken<OAuth2Client>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call dynamicClientRegistrationDeleteOAuth2ClientCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/connect/register/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call dynamicClientRegistrationDeleteOAuth2ClientValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling dynamicClientRegistrationDeleteOAuth2Client(Async)");
        }
        Call localVarCall = this.dynamicClientRegistrationDeleteOAuth2ClientCall(id, _callback);
        return localVarCall;
    }

    public void dynamicClientRegistrationDeleteOAuth2Client(String id) throws ApiException {
        this.dynamicClientRegistrationDeleteOAuth2ClientWithHttpInfo(id);
    }

    public ApiResponse<Void> dynamicClientRegistrationDeleteOAuth2ClientWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.dynamicClientRegistrationDeleteOAuth2ClientValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call dynamicClientRegistrationDeleteOAuth2ClientAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.dynamicClientRegistrationDeleteOAuth2ClientValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call dynamicClientRegistrationGetOAuth2ClientCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/connect/register/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call dynamicClientRegistrationGetOAuth2ClientValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling dynamicClientRegistrationGetOAuth2Client(Async)");
        }
        Call localVarCall = this.dynamicClientRegistrationGetOAuth2ClientCall(id, _callback);
        return localVarCall;
    }

    public OAuth2Client dynamicClientRegistrationGetOAuth2Client(String id) throws ApiException {
        ApiResponse<OAuth2Client> localVarResp = this.dynamicClientRegistrationGetOAuth2ClientWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<OAuth2Client> dynamicClientRegistrationGetOAuth2ClientWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.dynamicClientRegistrationGetOAuth2ClientValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<OAuth2Client>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call dynamicClientRegistrationGetOAuth2ClientAsync(String id, ApiCallback<OAuth2Client> _callback) throws ApiException {
        Call localVarCall = this.dynamicClientRegistrationGetOAuth2ClientValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<OAuth2Client>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call dynamicClientRegistrationUpdateOAuth2ClientCall(String id, OAuth2Client oauth2Client, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        OAuth2Client localVarPostBody = oauth2Client;
        String localVarPath = "/connect/register/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call dynamicClientRegistrationUpdateOAuth2ClientValidateBeforeCall(String id, OAuth2Client oauth2Client, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling dynamicClientRegistrationUpdateOAuth2Client(Async)");
        }
        if (oauth2Client == null) {
            throw new ApiException("Missing the required parameter 'oauth2Client' when calling dynamicClientRegistrationUpdateOAuth2Client(Async)");
        }
        Call localVarCall = this.dynamicClientRegistrationUpdateOAuth2ClientCall(id, oauth2Client, _callback);
        return localVarCall;
    }

    public OAuth2Client dynamicClientRegistrationUpdateOAuth2Client(String id, OAuth2Client oauth2Client) throws ApiException {
        ApiResponse<OAuth2Client> localVarResp = this.dynamicClientRegistrationUpdateOAuth2ClientWithHttpInfo(id, oauth2Client);
        return localVarResp.getData();
    }

    public ApiResponse<OAuth2Client> dynamicClientRegistrationUpdateOAuth2ClientWithHttpInfo(String id, OAuth2Client oauth2Client) throws ApiException {
        Call localVarCall = this.dynamicClientRegistrationUpdateOAuth2ClientValidateBeforeCall(id, oauth2Client, null);
        Type localVarReturnType = new TypeToken<OAuth2Client>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call dynamicClientRegistrationUpdateOAuth2ClientAsync(String id, OAuth2Client oauth2Client, ApiCallback<OAuth2Client> _callback) throws ApiException {
        Call localVarCall = this.dynamicClientRegistrationUpdateOAuth2ClientValidateBeforeCall(id, oauth2Client, _callback);
        Type localVarReturnType = new TypeToken<OAuth2Client>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call oauth2TokenCall(String grantType, String clientId, String code, String redirectUri, String refreshToken, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/token";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (clientId != null) {
            localVarFormParams.put("client_id", clientId);
        }
        if (code != null) {
            localVarFormParams.put("code", code);
        }
        if (grantType != null) {
            localVarFormParams.put("grant_type", grantType);
        }
        if (redirectUri != null) {
            localVarFormParams.put("redirect_uri", redirectUri);
        }
        if (refreshToken != null) {
            localVarFormParams.put("refresh_token", refreshToken);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call oauth2TokenValidateBeforeCall(String grantType, String clientId, String code, String redirectUri, String refreshToken, ApiCallback _callback) throws ApiException {
        if (grantType == null) {
            throw new ApiException("Missing the required parameter 'grantType' when calling oauth2Token(Async)");
        }
        Call localVarCall = this.oauth2TokenCall(grantType, clientId, code, redirectUri, refreshToken, _callback);
        return localVarCall;
    }

    public Oauth2TokenResponse oauth2Token(String grantType, String clientId, String code, String redirectUri, String refreshToken) throws ApiException {
        ApiResponse<Oauth2TokenResponse> localVarResp = this.oauth2TokenWithHttpInfo(grantType, clientId, code, redirectUri, refreshToken);
        return localVarResp.getData();
    }

    public ApiResponse<Oauth2TokenResponse> oauth2TokenWithHttpInfo(String grantType, String clientId, String code, String redirectUri, String refreshToken) throws ApiException {
        Call localVarCall = this.oauth2TokenValidateBeforeCall(grantType, clientId, code, redirectUri, refreshToken, null);
        Type localVarReturnType = new TypeToken<Oauth2TokenResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call oauth2TokenAsync(String grantType, String clientId, String code, String redirectUri, String refreshToken, ApiCallback<Oauth2TokenResponse> _callback) throws ApiException {
        Call localVarCall = this.oauth2TokenValidateBeforeCall(grantType, clientId, code, redirectUri, refreshToken, _callback);
        Type localVarReturnType = new TypeToken<Oauth2TokenResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call oauthAuthCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/auth";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call oauthAuthValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.oauthAuthCall(_callback);
        return localVarCall;
    }

    public void oauthAuth() throws ApiException {
        this.oauthAuthWithHttpInfo();
    }

    public ApiResponse<Void> oauthAuthWithHttpInfo() throws ApiException {
        Call localVarCall = this.oauthAuthValidateBeforeCall(null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call oauthAuthAsync(ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.oauthAuthValidateBeforeCall(_callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call revokeOAuth2TokenCall(String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/revoke";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarFormParams.put("token", token);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/x-www-form-urlencoded"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basic", "oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call revokeOAuth2TokenValidateBeforeCall(String token, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling revokeOAuth2Token(Async)");
        }
        Call localVarCall = this.revokeOAuth2TokenCall(token, _callback);
        return localVarCall;
    }

    public void revokeOAuth2Token(String token) throws ApiException {
        this.revokeOAuth2TokenWithHttpInfo(token);
    }

    public ApiResponse<Void> revokeOAuth2TokenWithHttpInfo(String token) throws ApiException {
        Call localVarCall = this.revokeOAuth2TokenValidateBeforeCall(token, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call revokeOAuth2TokenAsync(String token, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.revokeOAuth2TokenValidateBeforeCall(token, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call userinfoCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/userinfo";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"oauth2"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call userinfoValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.userinfoCall(_callback);
        return localVarCall;
    }

    public UserinfoResponse userinfo() throws ApiException {
        ApiResponse<UserinfoResponse> localVarResp = this.userinfoWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<UserinfoResponse> userinfoWithHttpInfo() throws ApiException {
        Call localVarCall = this.userinfoValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<UserinfoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call userinfoAsync(ApiCallback<UserinfoResponse> _callback) throws ApiException {
        Call localVarCall = this.userinfoValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<UserinfoResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call wellKnownCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/.well-known/jwks.json";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call wellKnownValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.wellKnownCall(_callback);
        return localVarCall;
    }

    public JSONWebKeySet wellKnown() throws ApiException {
        ApiResponse<JSONWebKeySet> localVarResp = this.wellKnownWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<JSONWebKeySet> wellKnownWithHttpInfo() throws ApiException {
        Call localVarCall = this.wellKnownValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<JSONWebKeySet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call wellKnownAsync(ApiCallback<JSONWebKeySet> _callback) throws ApiException {
        Call localVarCall = this.wellKnownValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<JSONWebKeySet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

