/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sh.ory.hydra.model.OAuth2Client;
import sh.ory.hydra.model.OpenIDConnectContext;

public class ConsentRequest {
    public static final String SERIALIZED_NAME_ACR = "acr";
    @SerializedName(value="acr")
    private String acr;
    public static final String SERIALIZED_NAME_AMR = "amr";
    @SerializedName(value="amr")
    private List<String> amr = null;
    public static final String SERIALIZED_NAME_CHALLENGE = "challenge";
    @SerializedName(value="challenge")
    private String challenge;
    public static final String SERIALIZED_NAME_CLIENT = "client";
    @SerializedName(value="client")
    private OAuth2Client client;
    public static final String SERIALIZED_NAME_CONTEXT = "context";
    @SerializedName(value="context")
    private Object context;
    public static final String SERIALIZED_NAME_LOGIN_CHALLENGE = "login_challenge";
    @SerializedName(value="login_challenge")
    private String loginChallenge;
    public static final String SERIALIZED_NAME_LOGIN_SESSION_ID = "login_session_id";
    @SerializedName(value="login_session_id")
    private String loginSessionId;
    public static final String SERIALIZED_NAME_OIDC_CONTEXT = "oidc_context";
    @SerializedName(value="oidc_context")
    private OpenIDConnectContext oidcContext;
    public static final String SERIALIZED_NAME_REQUEST_URL = "request_url";
    @SerializedName(value="request_url")
    private String requestUrl;
    public static final String SERIALIZED_NAME_REQUESTED_ACCESS_TOKEN_AUDIENCE = "requested_access_token_audience";
    @SerializedName(value="requested_access_token_audience")
    private List<String> requestedAccessTokenAudience = null;
    public static final String SERIALIZED_NAME_REQUESTED_SCOPE = "requested_scope";
    @SerializedName(value="requested_scope")
    private List<String> requestedScope = null;
    public static final String SERIALIZED_NAME_SKIP = "skip";
    @SerializedName(value="skip")
    private Boolean skip;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;

    public ConsentRequest acr(String acr) {
        this.acr = acr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ACR represents the Authentication AuthorizationContext Class Reference value for this authentication session. You can use it to express that, for example, a user authenticated using two factor authentication.")
    public String getAcr() {
        return this.acr;
    }

    public void setAcr(String acr) {
        this.acr = acr;
    }

    public ConsentRequest amr(List<String> amr) {
        this.amr = amr;
        return this;
    }

    public ConsentRequest addAmrItem(String amrItem) {
        if (this.amr == null) {
            this.amr = new ArrayList<String>();
        }
        this.amr.add(amrItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getAmr() {
        return this.amr;
    }

    public void setAmr(List<String> amr) {
        this.amr = amr;
    }

    public ConsentRequest challenge(String challenge) {
        this.challenge = challenge;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ID is the identifier (\"authorization challenge\") of the consent authorization request. It is used to identify the session.")
    public String getChallenge() {
        return this.challenge;
    }

    public void setChallenge(String challenge) {
        this.challenge = challenge;
    }

    public ConsentRequest client(OAuth2Client client) {
        this.client = client;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OAuth2Client getClient() {
        return this.client;
    }

    public void setClient(OAuth2Client client) {
        this.client = client;
    }

    public ConsentRequest context(Object context) {
        this.context = context;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public ConsentRequest loginChallenge(String loginChallenge) {
        this.loginChallenge = loginChallenge;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="LoginChallenge is the login challenge this consent challenge belongs to. It can be used to associate a login and consent request in the login & consent app.")
    public String getLoginChallenge() {
        return this.loginChallenge;
    }

    public void setLoginChallenge(String loginChallenge) {
        this.loginChallenge = loginChallenge;
    }

    public ConsentRequest loginSessionId(String loginSessionId) {
        this.loginSessionId = loginSessionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="LoginSessionID is the login session ID. If the user-agent reuses a login session (via cookie / remember flag) this ID will remain the same. If the user-agent did not have an existing authentication session (e.g. remember is false) this will be a new random value. This value is used as the \"sid\" parameter in the ID Token and in OIDC Front-/Back- channel logout. It's value can generally be used to associate consecutive login requests by a certain user.")
    public String getLoginSessionId() {
        return this.loginSessionId;
    }

    public void setLoginSessionId(String loginSessionId) {
        this.loginSessionId = loginSessionId;
    }

    public ConsentRequest oidcContext(OpenIDConnectContext oidcContext) {
        this.oidcContext = oidcContext;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OpenIDConnectContext getOidcContext() {
        return this.oidcContext;
    }

    public void setOidcContext(OpenIDConnectContext oidcContext) {
        this.oidcContext = oidcContext;
    }

    public ConsentRequest requestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RequestURL is the original OAuth 2.0 Authorization URL requested by the OAuth 2.0 client. It is the URL which initiates the OAuth 2.0 Authorization Code or OAuth 2.0 Implicit flow. This URL is typically not needed, but might come in handy if you want to deal with additional request parameters.")
    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public ConsentRequest requestedAccessTokenAudience(List<String> requestedAccessTokenAudience) {
        this.requestedAccessTokenAudience = requestedAccessTokenAudience;
        return this;
    }

    public ConsentRequest addRequestedAccessTokenAudienceItem(String requestedAccessTokenAudienceItem) {
        if (this.requestedAccessTokenAudience == null) {
            this.requestedAccessTokenAudience = new ArrayList<String>();
        }
        this.requestedAccessTokenAudience.add(requestedAccessTokenAudienceItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getRequestedAccessTokenAudience() {
        return this.requestedAccessTokenAudience;
    }

    public void setRequestedAccessTokenAudience(List<String> requestedAccessTokenAudience) {
        this.requestedAccessTokenAudience = requestedAccessTokenAudience;
    }

    public ConsentRequest requestedScope(List<String> requestedScope) {
        this.requestedScope = requestedScope;
        return this;
    }

    public ConsentRequest addRequestedScopeItem(String requestedScopeItem) {
        if (this.requestedScope == null) {
            this.requestedScope = new ArrayList<String>();
        }
        this.requestedScope.add(requestedScopeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getRequestedScope() {
        return this.requestedScope;
    }

    public void setRequestedScope(List<String> requestedScope) {
        this.requestedScope = requestedScope;
    }

    public ConsentRequest skip(Boolean skip) {
        this.skip = skip;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Skip, if true, implies that the client has requested the same scopes from the same user previously. If true, you must not ask the user to grant the requested scopes. You must however either allow or deny the consent request using the usual API call.")
    public Boolean getSkip() {
        return this.skip;
    }

    public void setSkip(Boolean skip) {
        this.skip = skip;
    }

    public ConsentRequest subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Subject is the user ID of the end-user that authenticated. Now, that end user needs to grant or deny the scope requested by the OAuth 2.0 client.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsentRequest consentRequest = (ConsentRequest)o;
        return Objects.equals(this.acr, consentRequest.acr) && Objects.equals(this.amr, consentRequest.amr) && Objects.equals(this.challenge, consentRequest.challenge) && Objects.equals(this.client, consentRequest.client) && Objects.equals(this.context, consentRequest.context) && Objects.equals(this.loginChallenge, consentRequest.loginChallenge) && Objects.equals(this.loginSessionId, consentRequest.loginSessionId) && Objects.equals(this.oidcContext, consentRequest.oidcContext) && Objects.equals(this.requestUrl, consentRequest.requestUrl) && Objects.equals(this.requestedAccessTokenAudience, consentRequest.requestedAccessTokenAudience) && Objects.equals(this.requestedScope, consentRequest.requestedScope) && Objects.equals(this.skip, consentRequest.skip) && Objects.equals(this.subject, consentRequest.subject);
    }

    public int hashCode() {
        return Objects.hash(this.acr, this.amr, this.challenge, this.client, this.context, this.loginChallenge, this.loginSessionId, this.oidcContext, this.requestUrl, this.requestedAccessTokenAudience, this.requestedScope, this.skip, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConsentRequest {\n");
        sb.append("    acr: ").append(this.toIndentedString(this.acr)).append("\n");
        sb.append("    amr: ").append(this.toIndentedString(this.amr)).append("\n");
        sb.append("    challenge: ").append(this.toIndentedString(this.challenge)).append("\n");
        sb.append("    client: ").append(this.toIndentedString(this.client)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    loginChallenge: ").append(this.toIndentedString(this.loginChallenge)).append("\n");
        sb.append("    loginSessionId: ").append(this.toIndentedString(this.loginSessionId)).append("\n");
        sb.append("    oidcContext: ").append(this.toIndentedString(this.oidcContext)).append("\n");
        sb.append("    requestUrl: ").append(this.toIndentedString(this.requestUrl)).append("\n");
        sb.append("    requestedAccessTokenAudience: ").append(this.toIndentedString(this.requestedAccessTokenAudience)).append("\n");
        sb.append("    requestedScope: ").append(this.toIndentedString(this.requestedScope)).append("\n");
        sb.append("    skip: ").append(this.toIndentedString(this.skip)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

