/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="It is important that this model object is named JSONWebKey for \"swagger generate spec\" to generate only on definition of a JSONWebKey.")
public class JSONWebKey {
    public static final String SERIALIZED_NAME_ALG = "alg";
    @SerializedName(value="alg")
    private String alg;
    public static final String SERIALIZED_NAME_CRV = "crv";
    @SerializedName(value="crv")
    private String crv;
    public static final String SERIALIZED_NAME_D = "d";
    @SerializedName(value="d")
    private String d;
    public static final String SERIALIZED_NAME_DP = "dp";
    @SerializedName(value="dp")
    private String dp;
    public static final String SERIALIZED_NAME_DQ = "dq";
    @SerializedName(value="dq")
    private String dq;
    public static final String SERIALIZED_NAME_E = "e";
    @SerializedName(value="e")
    private String e;
    public static final String SERIALIZED_NAME_K = "k";
    @SerializedName(value="k")
    private String k;
    public static final String SERIALIZED_NAME_KID = "kid";
    @SerializedName(value="kid")
    private String kid;
    public static final String SERIALIZED_NAME_KTY = "kty";
    @SerializedName(value="kty")
    private String kty;
    public static final String SERIALIZED_NAME_N = "n";
    @SerializedName(value="n")
    private String n;
    public static final String SERIALIZED_NAME_P = "p";
    @SerializedName(value="p")
    private String p;
    public static final String SERIALIZED_NAME_Q = "q";
    @SerializedName(value="q")
    private String q;
    public static final String SERIALIZED_NAME_QI = "qi";
    @SerializedName(value="qi")
    private String qi;
    public static final String SERIALIZED_NAME_USE = "use";
    @SerializedName(value="use")
    private String use;
    public static final String SERIALIZED_NAME_X = "x";
    @SerializedName(value="x")
    private String x;
    public static final String SERIALIZED_NAME_X5C = "x5c";
    @SerializedName(value="x5c")
    private List<String> x5c = null;
    public static final String SERIALIZED_NAME_Y = "y";
    @SerializedName(value="y")
    private String y;

    public JSONWebKey alg(String alg) {
        this.alg = alg;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="RS256", required=true, value="The \"alg\" (algorithm) parameter identifies the algorithm intended for use with the key.  The values used should either be registered in the IANA \"JSON Web Signature and Encryption Algorithms\" registry established by [JWA] or be a value that contains a Collision- Resistant Name.")
    public String getAlg() {
        return this.alg;
    }

    public void setAlg(String alg) {
        this.alg = alg;
    }

    public JSONWebKey crv(String crv) {
        this.crv = crv;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="P-256", value="")
    public String getCrv() {
        return this.crv;
    }

    public void setCrv(String crv) {
        this.crv = crv;
    }

    public JSONWebKey d(String d) {
        this.d = d;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="T_N8I-6He3M8a7X1vWt6TGIx4xB_GP3Mb4SsZSA4v-orvJzzRiQhLlRR81naWYxfQAYt5isDI6_C2L9bdWo4FFPjGQFvNoRX-_sBJyBI_rl-TBgsZYoUlAj3J92WmY2inbA-PwyJfsaIIDceYBC-eX-xiCu6qMqkZi3MwQAFL6bMdPEM0z4JBcwFT3VdiWAIRUuACWQwrXMq672x7fMuaIaHi7XDGgt1ith23CLfaREmJku9PQcchbt_uEY-hqrFY6ntTtS4paWWQj86xLL94S-Tf6v6xkL918PfLSOTq6XCzxvlFwzBJqApnAhbwqLjpPhgUG04EDRrqrSBc5Y1BLevn6Ip5h1AhessBp3wLkQgz_roeckt-ybvzKTjESMuagnpqLvOT7Y9veIug2MwPJZI2VjczRc1vzMs25XrFQ8DpUy-bNdp89TmvAXwctUMiJdgHloJw23Cv03gIUAkDnsTqZmkpbIf-crpgNKFmQP_EDKoe8p_PXZZgfbRri3NoEVGP7Mk6yEu8LjJhClhZaBNjuWw2-KlBfOA3g79mhfBnkInee5KO9mGR50qPk1V-MorUYNTFMZIm0kFE6eYVWFBwJHLKYhHU34DoiK1VP-svZpC2uAMFNA_UJEwM9CQ2b8qe4-5e9aywMvwcuArRkAB5mBIfOaOJao3mfukKAE", value="")
    public String getD() {
        return this.d;
    }

    public void setD(String d) {
        this.d = d;
    }

    public JSONWebKey dp(String dp) {
        this.dp = dp;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="G4sPXkc6Ya9y8oJW9_ILj4xuppu0lzi_H7VTkS8xj5SdX3coE0oimYwxIi2emTAue0UOa5dpgFGyBJ4c8tQ2VF402XRugKDTP8akYhFo5tAA77Qe_NmtuYZc3C3m3I24G2GvR5sSDxUyAN2zq8Lfn9EUms6rY3Ob8YeiKkTiBj0", value="")
    public String getDp() {
        return this.dp;
    }

    public void setDp(String dp) {
        this.dp = dp;
    }

    public JSONWebKey dq(String dq) {
        this.dq = dq;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="s9lAH9fggBsoFR8Oac2R_E2gw282rT2kGOAhvIllETE1efrA6huUUvMfBcMpn8lqeW6vzznYY5SSQF7pMdC_agI3nG8Ibp1BUb0JUiraRNqUfLhcQb_d9GF4Dh7e74WbRsobRonujTYN1xCaP6TO61jvWrX-L18txXw494Q_cgk", value="")
    public String getDq() {
        return this.dq;
    }

    public void setDq(String dq) {
        this.dq = dq;
    }

    public JSONWebKey e(String e) {
        this.e = e;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="AQAB", value="")
    public String getE() {
        return this.e;
    }

    public void setE(String e) {
        this.e = e;
    }

    public JSONWebKey k(String k) {
        this.k = k;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="GawgguFyGrWKav7AX4VKUg", value="")
    public String getK() {
        return this.k;
    }

    public void setK(String k) {
        this.k = k;
    }

    public JSONWebKey kid(String kid) {
        this.kid = kid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1603dfe0af8f4596", required=true, value="The \"kid\" (key ID) parameter is used to match a specific key.  This is used, for instance, to choose among a set of keys within a JWK Set during key rollover.  The structure of the \"kid\" value is unspecified.  When \"kid\" values are used within a JWK Set, different keys within the JWK Set SHOULD use distinct \"kid\" values.  (One example in which different keys might use the same \"kid\" value is if they have different \"kty\" (key type) values but are considered to be equivalent alternatives by the application using them.)  The \"kid\" value is a case-sensitive string.")
    public String getKid() {
        return this.kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public JSONWebKey kty(String kty) {
        this.kty = kty;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="RSA", required=true, value="The \"kty\" (key type) parameter identifies the cryptographic algorithm family used with the key, such as \"RSA\" or \"EC\". \"kty\" values should either be registered in the IANA \"JSON Web Key Types\" registry established by [JWA] or be a value that contains a Collision- Resistant Name.  The \"kty\" value is a case-sensitive string.")
    public String getKty() {
        return this.kty;
    }

    public void setKty(String kty) {
        this.kty = kty;
    }

    public JSONWebKey n(String n) {
        this.n = n;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="vTqrxUyQPl_20aqf5kXHwDZrel-KovIp8s7ewJod2EXHl8tWlRB3_Rem34KwBfqlKQGp1nqah-51H4Jzruqe0cFP58hPEIt6WqrvnmJCXxnNuIB53iX_uUUXXHDHBeaPCSRoNJzNysjoJ30TIUsKBiirhBa7f235PXbKiHducLevV6PcKxJ5cY8zO286qJLBWSPm-OIevwqsIsSIH44Qtm9sioFikhkbLwoqwWORGAY0nl6XvVOlhADdLjBSqSAeT1FPuCDCnXwzCDR8N9IFB_IjdStFkC-rVt2K5BYfPd0c3yFp_vHR15eRd0zJ8XQ7woBC8Vnsac6Et1pKS59pX6256DPWu8UDdEOolKAPgcd_g2NpA76cAaF_jcT80j9KrEzw8Tv0nJBGesuCjPNjGs_KzdkWTUXt23Hn9QJsdc1MZuaW0iqXBepHYfYoqNelzVte117t4BwVp0kUM6we0IqyXClaZgOI8S-WDBw2_Ovdm8e5NmhYAblEVoygcX8Y46oH6bKiaCQfKCFDMcRgChme7AoE1yZZYsPbaG_3IjPrC4LBMHQw8rM9dWjJ8ImjicvZ1pAm0dx-KHCP3y5PVKrxBDf1zSOsBRkOSjB8TPODnJMz6-jd5hTtZxpZPwPoIdCanTZ3ZD6uRBpTmDwtpRGm63UQs1m5FWPwb0T2IF0", value="")
    public String getN() {
        return this.n;
    }

    public void setN(String n) {
        this.n = n;
    }

    public JSONWebKey p(String p) {
        this.p = p;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="6NbkXwDWUhi-eR55Cgbf27FkQDDWIamOaDr0rj1q0f1fFEz1W5A_09YvG09Fiv1AO2-D8Rl8gS1Vkz2i0zCSqnyy8A025XOcRviOMK7nIxE4OH_PEsko8dtIrb3TmE2hUXvCkmzw9EsTF1LQBOGC6iusLTXepIC1x9ukCKFZQvdgtEObQ5kzd9Nhq-cdqmSeMVLoxPLd1blviVT9Vm8-y12CtYpeJHOaIDtVPLlBhJiBoPKWg3vxSm4XxIliNOefqegIlsmTIa3MpS6WWlCK3yHhat0Q-rRxDxdyiVdG_wzJvp0Iw_2wms7pe-PgNPYvUWH9JphWP5K38YqEBiJFXQ", value="")
    public String getP() {
        return this.p;
    }

    public void setP(String p) {
        this.p = p;
    }

    public JSONWebKey q(String q) {
        this.q = q;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0A1FmpOWR91_RAWpqreWSavNaZb9nXeKiBo0DQGBz32DbqKqQ8S4aBJmbRhJcctjCLjain-ivut477tAUMmzJwVJDDq2MZFwC9Q-4VYZmFU4HJityQuSzHYe64RjN-E_NQ02TWhG3QGW6roq6c57c99rrUsETwJJiwS8M5p15Miuz53DaOjv-uqqFAFfywN5WkxHbraBcjHtMiQuyQbQqkCFh-oanHkwYNeytsNhTu2mQmwR5DR2roZ2nPiFjC6nsdk-A7E3S3wMzYYFw7jvbWWoYWo9vB40_MY2Y0FYQSqcDzcBIcq_0tnnasf3VW4Fdx6m80RzOb2Fsnln7vKXAQ", value="")
    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public JSONWebKey qi(String qi) {
        this.qi = qi;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="GyM_p6JrXySiz1toFgKbWV-JdI3jQ4ypu9rbMWx3rQJBfmt0FoYzgUIZEVFEcOqwemRN81zoDAaa-Bk0KWNGDjJHZDdDmFhW3AN7lI-puxk_mHZGJ11rxyR8O55XLSe3SPmRfKwZI6yU24ZxvQKFYItdldUKGzO6Ia6zTKhAVRU", value="")
    public String getQi() {
        return this.qi;
    }

    public void setQi(String qi) {
        this.qi = qi;
    }

    public JSONWebKey use(String use) {
        this.use = use;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="sig", required=true, value="Use (\"public key use\") identifies the intended use of the public key. The \"use\" parameter is employed to indicate whether a public key is used for encrypting data or verifying the signature on data. Values are commonly \"sig\" (signature) or \"enc\" (encryption).")
    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public JSONWebKey x(String x) {
        this.x = x;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="f83OJ3D2xF1Bg8vub9tLe1gHMzV76e8Tus9uPHvRVEU", value="")
    public String getX() {
        return this.x;
    }

    public void setX(String x) {
        this.x = x;
    }

    public JSONWebKey x5c(List<String> x5c) {
        this.x5c = x5c;
        return this;
    }

    public JSONWebKey addX5cItem(String x5cItem) {
        if (this.x5c == null) {
            this.x5c = new ArrayList<String>();
        }
        this.x5c.add(x5cItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The \"x5c\" (X.509 certificate chain) parameter contains a chain of one or more PKIX certificates [RFC5280].  The certificate chain is represented as a JSON array of certificate value strings.  Each string in the array is a base64-encoded (Section 4 of [RFC4648] -- not base64url-encoded) DER [ITU.X690.1994] PKIX certificate value. The PKIX certificate containing the key value MUST be the first certificate.")
    public List<String> getX5c() {
        return this.x5c;
    }

    public void setX5c(List<String> x5c) {
        this.x5c = x5c;
    }

    public JSONWebKey y(String y) {
        this.y = y;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="x_FEzRu9m36HLN_tue659LNpXW6pCyStikYjKIWI5a0", value="")
    public String getY() {
        return this.y;
    }

    public void setY(String y) {
        this.y = y;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONWebKey jsONWebKey = (JSONWebKey)o;
        return Objects.equals(this.alg, jsONWebKey.alg) && Objects.equals(this.crv, jsONWebKey.crv) && Objects.equals(this.d, jsONWebKey.d) && Objects.equals(this.dp, jsONWebKey.dp) && Objects.equals(this.dq, jsONWebKey.dq) && Objects.equals(this.e, jsONWebKey.e) && Objects.equals(this.k, jsONWebKey.k) && Objects.equals(this.kid, jsONWebKey.kid) && Objects.equals(this.kty, jsONWebKey.kty) && Objects.equals(this.n, jsONWebKey.n) && Objects.equals(this.p, jsONWebKey.p) && Objects.equals(this.q, jsONWebKey.q) && Objects.equals(this.qi, jsONWebKey.qi) && Objects.equals(this.use, jsONWebKey.use) && Objects.equals(this.x, jsONWebKey.x) && Objects.equals(this.x5c, jsONWebKey.x5c) && Objects.equals(this.y, jsONWebKey.y);
    }

    public int hashCode() {
        return Objects.hash(this.alg, this.crv, this.d, this.dp, this.dq, this.e, this.k, this.kid, this.kty, this.n, this.p, this.q, this.qi, this.use, this.x, this.x5c, this.y);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JSONWebKey {\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    crv: ").append(this.toIndentedString(this.crv)).append("\n");
        sb.append("    d: ").append(this.toIndentedString(this.d)).append("\n");
        sb.append("    dp: ").append(this.toIndentedString(this.dp)).append("\n");
        sb.append("    dq: ").append(this.toIndentedString(this.dq)).append("\n");
        sb.append("    e: ").append(this.toIndentedString(this.e)).append("\n");
        sb.append("    k: ").append(this.toIndentedString(this.k)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    kty: ").append(this.toIndentedString(this.kty)).append("\n");
        sb.append("    n: ").append(this.toIndentedString(this.n)).append("\n");
        sb.append("    p: ").append(this.toIndentedString(this.p)).append("\n");
        sb.append("    q: ").append(this.toIndentedString(this.q)).append("\n");
        sb.append("    qi: ").append(this.toIndentedString(this.qi)).append("\n");
        sb.append("    use: ").append(this.toIndentedString(this.use)).append("\n");
        sb.append("    x: ").append(this.toIndentedString(this.x)).append("\n");
        sb.append("    x5c: ").append(this.toIndentedString(this.x5c)).append("\n");
        sb.append("    y: ").append(this.toIndentedString(this.y)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

