/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Error responses are sent when an error (e.g. unauthorized, bad request, ...) occurred.")
public class JsonError {
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private String error;
    public static final String SERIALIZED_NAME_ERROR_DEBUG = "error_debug";
    @SerializedName(value="error_debug")
    private String errorDebug;
    public static final String SERIALIZED_NAME_ERROR_DESCRIPTION = "error_description";
    @SerializedName(value="error_description")
    private String errorDescription;
    public static final String SERIALIZED_NAME_STATUS_CODE = "status_code";
    @SerializedName(value="status_code")
    private Long statusCode;

    public JsonError error(String error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="The requested resource could not be found", value="Name is the error name.")
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public JsonError errorDebug(String errorDebug) {
        this.errorDebug = errorDebug;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="The database adapter was unable to find the element", value="Debug contains debug information. This is usually not available and has to be enabled.")
    public String getErrorDebug() {
        return this.errorDebug;
    }

    public void setErrorDebug(String errorDebug) {
        this.errorDebug = errorDebug;
    }

    public JsonError errorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Object with ID 12345 does not exist", value="Description contains further information on the nature of the error.")
    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public JsonError statusCode(Long statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="404", value="Code represents the error status code (404, 403, 401, ...).")
    public Long getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Long statusCode) {
        this.statusCode = statusCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonError jsonError = (JsonError)o;
        return Objects.equals(this.error, jsonError.error) && Objects.equals(this.errorDebug, jsonError.errorDebug) && Objects.equals(this.errorDescription, jsonError.errorDescription) && Objects.equals(this.statusCode, jsonError.statusCode);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.errorDebug, this.errorDescription, this.statusCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JsonError {\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    errorDebug: ").append(this.toIndentedString(this.errorDebug)).append("\n");
        sb.append("    errorDescription: ").append(this.toIndentedString(this.errorDescription)).append("\n");
        sb.append("    statusCode: ").append(this.toIndentedString(this.statusCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

