/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import sh.ory.hydra.model.OAuth2Client;

public class LogoutRequest {
    public static final String SERIALIZED_NAME_CHALLENGE = "challenge";
    @SerializedName(value="challenge")
    private String challenge;
    public static final String SERIALIZED_NAME_CLIENT = "client";
    @SerializedName(value="client")
    private OAuth2Client client;
    public static final String SERIALIZED_NAME_REQUEST_URL = "request_url";
    @SerializedName(value="request_url")
    private String requestUrl;
    public static final String SERIALIZED_NAME_RP_INITIATED = "rp_initiated";
    @SerializedName(value="rp_initiated")
    private Boolean rpInitiated;
    public static final String SERIALIZED_NAME_SID = "sid";
    @SerializedName(value="sid")
    private String sid;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;

    public LogoutRequest challenge(String challenge) {
        this.challenge = challenge;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Challenge is the identifier (\"logout challenge\") of the logout authentication request. It is used to identify the session.")
    public String getChallenge() {
        return this.challenge;
    }

    public void setChallenge(String challenge) {
        this.challenge = challenge;
    }

    public LogoutRequest client(OAuth2Client client) {
        this.client = client;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OAuth2Client getClient() {
        return this.client;
    }

    public void setClient(OAuth2Client client) {
        this.client = client;
    }

    public LogoutRequest requestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RequestURL is the original Logout URL requested.")
    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public LogoutRequest rpInitiated(Boolean rpInitiated) {
        this.rpInitiated = rpInitiated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RPInitiated is set to true if the request was initiated by a Relying Party (RP), also known as an OAuth 2.0 Client.")
    public Boolean getRpInitiated() {
        return this.rpInitiated;
    }

    public void setRpInitiated(Boolean rpInitiated) {
        this.rpInitiated = rpInitiated;
    }

    public LogoutRequest sid(String sid) {
        this.sid = sid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SessionID is the login session ID that was requested to log out.")
    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public LogoutRequest subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Subject is the user for whom the logout was request.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogoutRequest logoutRequest = (LogoutRequest)o;
        return Objects.equals(this.challenge, logoutRequest.challenge) && Objects.equals(this.client, logoutRequest.client) && Objects.equals(this.requestUrl, logoutRequest.requestUrl) && Objects.equals(this.rpInitiated, logoutRequest.rpInitiated) && Objects.equals(this.sid, logoutRequest.sid) && Objects.equals(this.subject, logoutRequest.subject);
    }

    public int hashCode() {
        return Objects.hash(this.challenge, this.client, this.requestUrl, this.rpInitiated, this.sid, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogoutRequest {\n");
        sb.append("    challenge: ").append(this.toIndentedString(this.challenge)).append("\n");
        sb.append("    client: ").append(this.toIndentedString(this.client)).append("\n");
        sb.append("    requestUrl: ").append(this.toIndentedString(this.requestUrl)).append("\n");
        sb.append("    rpInitiated: ").append(this.toIndentedString(this.rpInitiated)).append("\n");
        sb.append("    sid: ").append(this.toIndentedString(this.sid)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

