/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The token response")
public class OauthTokenResponse {
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_EXPIRES_IN = "expires_in";
    @SerializedName(value="expires_in")
    private Long expiresIn;
    public static final String SERIALIZED_NAME_ID_TOKEN = "id_token";
    @SerializedName(value="id_token")
    private Long idToken;
    public static final String SERIALIZED_NAME_REFRESH_TOKEN = "refresh_token";
    @SerializedName(value="refresh_token")
    private String refreshToken;
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    private Long scope;
    public static final String SERIALIZED_NAME_TOKEN_TYPE = "token_type";
    @SerializedName(value="token_type")
    private String tokenType;

    public OauthTokenResponse accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The access token issued by the authorization server.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public OauthTokenResponse expiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The lifetime in seconds of the access token.  For example, the value \"3600\" denotes that the access token will expire in one hour from the time the response was generated.")
    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public OauthTokenResponse idToken(Long idToken) {
        this.idToken = idToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="To retrieve a refresh token request the id_token scope.")
    public Long getIdToken() {
        return this.idToken;
    }

    public void setIdToken(Long idToken) {
        this.idToken = idToken;
    }

    public OauthTokenResponse refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The refresh token, which can be used to obtain new access tokens. To retrieve it add the scope \"offline\" to your access token request.")
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public OauthTokenResponse scope(Long scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The scope of the access token")
    public Long getScope() {
        return this.scope;
    }

    public void setScope(Long scope) {
        this.scope = scope;
    }

    public OauthTokenResponse tokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of the token issued")
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OauthTokenResponse oauthTokenResponse = (OauthTokenResponse)o;
        return Objects.equals(this.accessToken, oauthTokenResponse.accessToken) && Objects.equals(this.expiresIn, oauthTokenResponse.expiresIn) && Objects.equals(this.idToken, oauthTokenResponse.idToken) && Objects.equals(this.refreshToken, oauthTokenResponse.refreshToken) && Objects.equals(this.scope, oauthTokenResponse.scope) && Objects.equals(this.tokenType, oauthTokenResponse.tokenType);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.expiresIn, this.idToken, this.refreshToken, this.scope, this.tokenType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OauthTokenResponse {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    idToken: ").append(this.toIndentedString(this.idToken)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

