/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="A JSONPatch document as defined by RFC 6902")
public class PatchDocument {
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private String from;
    public static final String SERIALIZED_NAME_OP = "op";
    @SerializedName(value="op")
    private String op;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private Object value;

    public PatchDocument from(String from) {
        this.from = from;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON-pointer")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public PatchDocument op(String op) {
        this.op = op;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="\"replace\"", required=true, value="The operation to be performed")
    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public PatchDocument path(String path) {
        this.path = path;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="\"/name\"", required=true, value="A JSON-pointer")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public PatchDocument value(Object value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The value to be used within the operations")
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchDocument patchDocument = (PatchDocument)o;
        return Objects.equals(this.from, patchDocument.from) && Objects.equals(this.op, patchDocument.op) && Objects.equals(this.path, patchDocument.path) && Objects.equals(this.value, patchDocument.value);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.op, this.path, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatchDocument {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    op: ").append(this.toIndentedString(this.op)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

