/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class RefreshTokenHookRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_GRANTED_AUDIENCE = "granted_audience";
    @SerializedName(value="granted_audience")
    private List<String> grantedAudience = null;
    public static final String SERIALIZED_NAME_GRANTED_SCOPES = "granted_scopes";
    @SerializedName(value="granted_scopes")
    private List<String> grantedScopes = null;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;

    public RefreshTokenHookRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ClientID is the identifier of the OAuth 2.0 client.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public RefreshTokenHookRequest grantedAudience(List<String> grantedAudience) {
        this.grantedAudience = grantedAudience;
        return this;
    }

    public RefreshTokenHookRequest addGrantedAudienceItem(String grantedAudienceItem) {
        if (this.grantedAudience == null) {
            this.grantedAudience = new ArrayList<String>();
        }
        this.grantedAudience.add(grantedAudienceItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GrantedAudience is the list of audiences granted to the OAuth 2.0 client.")
    public List<String> getGrantedAudience() {
        return this.grantedAudience;
    }

    public void setGrantedAudience(List<String> grantedAudience) {
        this.grantedAudience = grantedAudience;
    }

    public RefreshTokenHookRequest grantedScopes(List<String> grantedScopes) {
        this.grantedScopes = grantedScopes;
        return this;
    }

    public RefreshTokenHookRequest addGrantedScopesItem(String grantedScopesItem) {
        if (this.grantedScopes == null) {
            this.grantedScopes = new ArrayList<String>();
        }
        this.grantedScopes.add(grantedScopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GrantedScopes is the list of scopes granted to the OAuth 2.0 client.")
    public List<String> getGrantedScopes() {
        return this.grantedScopes;
    }

    public void setGrantedScopes(List<String> grantedScopes) {
        this.grantedScopes = grantedScopes;
    }

    public RefreshTokenHookRequest subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Subject is the identifier of the authenticated end-user.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefreshTokenHookRequest refreshTokenHookRequest = (RefreshTokenHookRequest)o;
        return Objects.equals(this.clientId, refreshTokenHookRequest.clientId) && Objects.equals(this.grantedAudience, refreshTokenHookRequest.grantedAudience) && Objects.equals(this.grantedScopes, refreshTokenHookRequest.grantedScopes) && Objects.equals(this.subject, refreshTokenHookRequest.subject);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.grantedAudience, this.grantedScopes, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RefreshTokenHookRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    grantedAudience: ").append(this.toIndentedString(this.grantedAudience)).append("\n");
        sb.append("    grantedScopes: ").append(this.toIndentedString(this.grantedScopes)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

