/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sh.ory.hydra.model.JSONWebKey;

public class TrustJwtGrantIssuerBody {
    public static final String SERIALIZED_NAME_ALLOW_ANY_SUBJECT = "allow_any_subject";
    @SerializedName(value="allow_any_subject")
    private Boolean allowAnySubject;
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expires_at";
    @SerializedName(value="expires_at")
    private OffsetDateTime expiresAt;
    public static final String SERIALIZED_NAME_ISSUER = "issuer";
    @SerializedName(value="issuer")
    private String issuer;
    public static final String SERIALIZED_NAME_JWK = "jwk";
    @SerializedName(value="jwk")
    private JSONWebKey jwk;
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    private List<String> scope = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;

    public TrustJwtGrantIssuerBody allowAnySubject(Boolean allowAnySubject) {
        this.allowAnySubject = allowAnySubject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The \"allow_any_subject\" indicates that the issuer is allowed to have any principal as the subject of the JWT.")
    public Boolean getAllowAnySubject() {
        return this.allowAnySubject;
    }

    public void setAllowAnySubject(Boolean allowAnySubject) {
        this.allowAnySubject = allowAnySubject;
    }

    public TrustJwtGrantIssuerBody expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The \"expires_at\" indicates, when grant will expire, so we will reject assertion from \"issuer\" targeting \"subject\".")
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public TrustJwtGrantIssuerBody issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://jwt-idp.example.com", required=true, value="The \"issuer\" identifies the principal that issued the JWT assertion (same as \"iss\" claim in JWT).")
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public TrustJwtGrantIssuerBody jwk(JSONWebKey jwk) {
        this.jwk = jwk;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public JSONWebKey getJwk() {
        return this.jwk;
    }

    public void setJwk(JSONWebKey jwk) {
        this.jwk = jwk;
    }

    public TrustJwtGrantIssuerBody scope(List<String> scope) {
        this.scope = scope;
        return this;
    }

    public TrustJwtGrantIssuerBody addScopeItem(String scopeItem) {
        this.scope.add(scopeItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="[\"openid\",\"offline\"]", required=true, value="The \"scope\" contains list of scope values (as described in Section 3.3 of OAuth 2.0 [RFC6749])")
    public List<String> getScope() {
        return this.scope;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    public TrustJwtGrantIssuerBody subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="mike@example.com", value="The \"subject\" identifies the principal that is the subject of the JWT.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustJwtGrantIssuerBody trustJwtGrantIssuerBody = (TrustJwtGrantIssuerBody)o;
        return Objects.equals(this.allowAnySubject, trustJwtGrantIssuerBody.allowAnySubject) && Objects.equals(this.expiresAt, trustJwtGrantIssuerBody.expiresAt) && Objects.equals(this.issuer, trustJwtGrantIssuerBody.issuer) && Objects.equals(this.jwk, trustJwtGrantIssuerBody.jwk) && Objects.equals(this.scope, trustJwtGrantIssuerBody.scope) && Objects.equals(this.subject, trustJwtGrantIssuerBody.subject);
    }

    public int hashCode() {
        return Objects.hash(this.allowAnySubject, this.expiresAt, this.issuer, this.jwk, this.scope, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrustJwtGrantIssuerBody {\n");
        sb.append("    allowAnySubject: ").append(this.toIndentedString(this.allowAnySubject)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    jwk: ").append(this.toIndentedString(this.jwk)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

