/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import sh.ory.hydra.model.TrustedJsonWebKey;

public class TrustedJwtGrantIssuer {
    public static final String SERIALIZED_NAME_ALLOW_ANY_SUBJECT = "allow_any_subject";
    @SerializedName(value="allow_any_subject")
    private Boolean allowAnySubject;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expires_at";
    @SerializedName(value="expires_at")
    private OffsetDateTime expiresAt;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ISSUER = "issuer";
    @SerializedName(value="issuer")
    private String issuer;
    public static final String SERIALIZED_NAME_PUBLIC_KEY = "public_key";
    @SerializedName(value="public_key")
    private TrustedJsonWebKey publicKey;
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    private List<String> scope = null;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;

    public TrustedJwtGrantIssuer allowAnySubject(Boolean allowAnySubject) {
        this.allowAnySubject = allowAnySubject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The \"allow_any_subject\" indicates that the issuer is allowed to have any principal as the subject of the JWT.")
    public Boolean getAllowAnySubject() {
        return this.allowAnySubject;
    }

    public void setAllowAnySubject(Boolean allowAnySubject) {
        this.allowAnySubject = allowAnySubject;
    }

    public TrustedJwtGrantIssuer createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The \"created_at\" indicates, when grant was created.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public TrustedJwtGrantIssuer expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The \"expires_at\" indicates, when grant will expire, so we will reject assertion from \"issuer\" targeting \"subject\".")
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public TrustedJwtGrantIssuer id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="9edc811f-4e28-453c-9b46-4de65f00217f", value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TrustedJwtGrantIssuer issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://jwt-idp.example.com", value="The \"issuer\" identifies the principal that issued the JWT assertion (same as \"iss\" claim in JWT).")
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public TrustedJwtGrantIssuer publicKey(TrustedJsonWebKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TrustedJsonWebKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(TrustedJsonWebKey publicKey) {
        this.publicKey = publicKey;
    }

    public TrustedJwtGrantIssuer scope(List<String> scope) {
        this.scope = scope;
        return this;
    }

    public TrustedJwtGrantIssuer addScopeItem(String scopeItem) {
        if (this.scope == null) {
            this.scope = new ArrayList<String>();
        }
        this.scope.add(scopeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"openid\",\"offline\"]", value="The \"scope\" contains list of scope values (as described in Section 3.3 of OAuth 2.0 [RFC6749])")
    public List<String> getScope() {
        return this.scope;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    public TrustedJwtGrantIssuer subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="mike@example.com", value="The \"subject\" identifies the principal that is the subject of the JWT.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustedJwtGrantIssuer trustedJwtGrantIssuer = (TrustedJwtGrantIssuer)o;
        return Objects.equals(this.allowAnySubject, trustedJwtGrantIssuer.allowAnySubject) && Objects.equals(this.createdAt, trustedJwtGrantIssuer.createdAt) && Objects.equals(this.expiresAt, trustedJwtGrantIssuer.expiresAt) && Objects.equals(this.id, trustedJwtGrantIssuer.id) && Objects.equals(this.issuer, trustedJwtGrantIssuer.issuer) && Objects.equals(this.publicKey, trustedJwtGrantIssuer.publicKey) && Objects.equals(this.scope, trustedJwtGrantIssuer.scope) && Objects.equals(this.subject, trustedJwtGrantIssuer.subject);
    }

    public int hashCode() {
        return Objects.hash(this.allowAnySubject, this.createdAt, this.expiresAt, this.id, this.issuer, this.publicKey, this.scope, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrustedJwtGrantIssuer {\n");
        sb.append("    allowAnySubject: ").append(this.toIndentedString(this.allowAnySubject)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    publicKey: ").append(this.toIndentedString(this.publicKey)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

