/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import sh.ory.hydra.ApiCallback;
import sh.ory.hydra.ApiClient;
import sh.ory.hydra.ApiException;
import sh.ory.hydra.ApiResponse;
import sh.ory.hydra.Configuration;
import sh.ory.hydra.Pair;
import sh.ory.hydra.model.AcceptConsentRequest;
import sh.ory.hydra.model.AcceptLoginRequest;
import sh.ory.hydra.model.CompletedRequest;
import sh.ory.hydra.model.ConsentRequest;
import sh.ory.hydra.model.FlushInactiveOAuth2TokensRequest;
import sh.ory.hydra.model.HealthStatus;
import sh.ory.hydra.model.JSONWebKey;
import sh.ory.hydra.model.JSONWebKeySet;
import sh.ory.hydra.model.JsonWebKeySetGeneratorRequest;
import sh.ory.hydra.model.LoginRequest;
import sh.ory.hydra.model.LogoutRequest;
import sh.ory.hydra.model.OAuth2Client;
import sh.ory.hydra.model.OAuth2TokenIntrospection;
import sh.ory.hydra.model.PreviousConsentSession;
import sh.ory.hydra.model.RejectRequest;
import sh.ory.hydra.model.Version;

public class AdminApi {
    private ApiClient localVarApiClient;

    public AdminApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AdminApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call acceptConsentRequestCall(String consentChallenge, AcceptConsentRequest body, ApiCallback _callback) throws ApiException {
        AcceptConsentRequest localVarPostBody = body;
        String localVarPath = "/oauth2/auth/requests/consent/accept";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (consentChallenge != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("consent_challenge", consentChallenge));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call acceptConsentRequestValidateBeforeCall(String consentChallenge, AcceptConsentRequest body, ApiCallback _callback) throws ApiException {
        if (consentChallenge == null) {
            throw new ApiException("Missing the required parameter 'consentChallenge' when calling acceptConsentRequest(Async)");
        }
        Call localVarCall = this.acceptConsentRequestCall(consentChallenge, body, _callback);
        return localVarCall;
    }

    public CompletedRequest acceptConsentRequest(String consentChallenge, AcceptConsentRequest body) throws ApiException {
        ApiResponse<CompletedRequest> localVarResp = this.acceptConsentRequestWithHttpInfo(consentChallenge, body);
        return localVarResp.getData();
    }

    public ApiResponse<CompletedRequest> acceptConsentRequestWithHttpInfo(String consentChallenge, AcceptConsentRequest body) throws ApiException {
        Call localVarCall = this.acceptConsentRequestValidateBeforeCall(consentChallenge, body, null);
        Type localVarReturnType = new TypeToken<CompletedRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call acceptConsentRequestAsync(String consentChallenge, AcceptConsentRequest body, ApiCallback<CompletedRequest> _callback) throws ApiException {
        Call localVarCall = this.acceptConsentRequestValidateBeforeCall(consentChallenge, body, _callback);
        Type localVarReturnType = new TypeToken<CompletedRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call acceptLoginRequestCall(String loginChallenge, AcceptLoginRequest body, ApiCallback _callback) throws ApiException {
        AcceptLoginRequest localVarPostBody = body;
        String localVarPath = "/oauth2/auth/requests/login/accept";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (loginChallenge != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("login_challenge", loginChallenge));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call acceptLoginRequestValidateBeforeCall(String loginChallenge, AcceptLoginRequest body, ApiCallback _callback) throws ApiException {
        if (loginChallenge == null) {
            throw new ApiException("Missing the required parameter 'loginChallenge' when calling acceptLoginRequest(Async)");
        }
        Call localVarCall = this.acceptLoginRequestCall(loginChallenge, body, _callback);
        return localVarCall;
    }

    public CompletedRequest acceptLoginRequest(String loginChallenge, AcceptLoginRequest body) throws ApiException {
        ApiResponse<CompletedRequest> localVarResp = this.acceptLoginRequestWithHttpInfo(loginChallenge, body);
        return localVarResp.getData();
    }

    public ApiResponse<CompletedRequest> acceptLoginRequestWithHttpInfo(String loginChallenge, AcceptLoginRequest body) throws ApiException {
        Call localVarCall = this.acceptLoginRequestValidateBeforeCall(loginChallenge, body, null);
        Type localVarReturnType = new TypeToken<CompletedRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call acceptLoginRequestAsync(String loginChallenge, AcceptLoginRequest body, ApiCallback<CompletedRequest> _callback) throws ApiException {
        Call localVarCall = this.acceptLoginRequestValidateBeforeCall(loginChallenge, body, _callback);
        Type localVarReturnType = new TypeToken<CompletedRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call acceptLogoutRequestCall(String logoutChallenge, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/auth/requests/logout/accept";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (logoutChallenge != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logout_challenge", logoutChallenge));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call acceptLogoutRequestValidateBeforeCall(String logoutChallenge, ApiCallback _callback) throws ApiException {
        if (logoutChallenge == null) {
            throw new ApiException("Missing the required parameter 'logoutChallenge' when calling acceptLogoutRequest(Async)");
        }
        Call localVarCall = this.acceptLogoutRequestCall(logoutChallenge, _callback);
        return localVarCall;
    }

    public CompletedRequest acceptLogoutRequest(String logoutChallenge) throws ApiException {
        ApiResponse<CompletedRequest> localVarResp = this.acceptLogoutRequestWithHttpInfo(logoutChallenge);
        return localVarResp.getData();
    }

    public ApiResponse<CompletedRequest> acceptLogoutRequestWithHttpInfo(String logoutChallenge) throws ApiException {
        Call localVarCall = this.acceptLogoutRequestValidateBeforeCall(logoutChallenge, null);
        Type localVarReturnType = new TypeToken<CompletedRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call acceptLogoutRequestAsync(String logoutChallenge, ApiCallback<CompletedRequest> _callback) throws ApiException {
        Call localVarCall = this.acceptLogoutRequestValidateBeforeCall(logoutChallenge, _callback);
        Type localVarReturnType = new TypeToken<CompletedRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createJsonWebKeySetCall(String set, JsonWebKeySetGeneratorRequest body, ApiCallback _callback) throws ApiException {
        JsonWebKeySetGeneratorRequest localVarPostBody = body;
        String localVarPath = "/keys/{set}".replaceAll("\\{set\\}", this.localVarApiClient.escapeString(set.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createJsonWebKeySetValidateBeforeCall(String set, JsonWebKeySetGeneratorRequest body, ApiCallback _callback) throws ApiException {
        if (set == null) {
            throw new ApiException("Missing the required parameter 'set' when calling createJsonWebKeySet(Async)");
        }
        Call localVarCall = this.createJsonWebKeySetCall(set, body, _callback);
        return localVarCall;
    }

    public JSONWebKeySet createJsonWebKeySet(String set, JsonWebKeySetGeneratorRequest body) throws ApiException {
        ApiResponse<JSONWebKeySet> localVarResp = this.createJsonWebKeySetWithHttpInfo(set, body);
        return localVarResp.getData();
    }

    public ApiResponse<JSONWebKeySet> createJsonWebKeySetWithHttpInfo(String set, JsonWebKeySetGeneratorRequest body) throws ApiException {
        Call localVarCall = this.createJsonWebKeySetValidateBeforeCall(set, body, null);
        Type localVarReturnType = new TypeToken<JSONWebKeySet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createJsonWebKeySetAsync(String set, JsonWebKeySetGeneratorRequest body, ApiCallback<JSONWebKeySet> _callback) throws ApiException {
        Call localVarCall = this.createJsonWebKeySetValidateBeforeCall(set, body, _callback);
        Type localVarReturnType = new TypeToken<JSONWebKeySet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createOAuth2ClientCall(OAuth2Client body, ApiCallback _callback) throws ApiException {
        OAuth2Client localVarPostBody = body;
        String localVarPath = "/clients";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOAuth2ClientValidateBeforeCall(OAuth2Client body, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createOAuth2Client(Async)");
        }
        Call localVarCall = this.createOAuth2ClientCall(body, _callback);
        return localVarCall;
    }

    public OAuth2Client createOAuth2Client(OAuth2Client body) throws ApiException {
        ApiResponse<OAuth2Client> localVarResp = this.createOAuth2ClientWithHttpInfo(body);
        return localVarResp.getData();
    }

    public ApiResponse<OAuth2Client> createOAuth2ClientWithHttpInfo(OAuth2Client body) throws ApiException {
        Call localVarCall = this.createOAuth2ClientValidateBeforeCall(body, null);
        Type localVarReturnType = new TypeToken<OAuth2Client>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createOAuth2ClientAsync(OAuth2Client body, ApiCallback<OAuth2Client> _callback) throws ApiException {
        Call localVarCall = this.createOAuth2ClientValidateBeforeCall(body, _callback);
        Type localVarReturnType = new TypeToken<OAuth2Client>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteJsonWebKeyCall(String kid, String set, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/keys/{set}/{kid}".replaceAll("\\{kid\\}", this.localVarApiClient.escapeString(kid.toString())).replaceAll("\\{set\\}", this.localVarApiClient.escapeString(set.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteJsonWebKeyValidateBeforeCall(String kid, String set, ApiCallback _callback) throws ApiException {
        if (kid == null) {
            throw new ApiException("Missing the required parameter 'kid' when calling deleteJsonWebKey(Async)");
        }
        if (set == null) {
            throw new ApiException("Missing the required parameter 'set' when calling deleteJsonWebKey(Async)");
        }
        Call localVarCall = this.deleteJsonWebKeyCall(kid, set, _callback);
        return localVarCall;
    }

    public void deleteJsonWebKey(String kid, String set) throws ApiException {
        this.deleteJsonWebKeyWithHttpInfo(kid, set);
    }

    public ApiResponse<Void> deleteJsonWebKeyWithHttpInfo(String kid, String set) throws ApiException {
        Call localVarCall = this.deleteJsonWebKeyValidateBeforeCall(kid, set, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteJsonWebKeyAsync(String kid, String set, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteJsonWebKeyValidateBeforeCall(kid, set, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteJsonWebKeySetCall(String set, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/keys/{set}".replaceAll("\\{set\\}", this.localVarApiClient.escapeString(set.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteJsonWebKeySetValidateBeforeCall(String set, ApiCallback _callback) throws ApiException {
        if (set == null) {
            throw new ApiException("Missing the required parameter 'set' when calling deleteJsonWebKeySet(Async)");
        }
        Call localVarCall = this.deleteJsonWebKeySetCall(set, _callback);
        return localVarCall;
    }

    public void deleteJsonWebKeySet(String set) throws ApiException {
        this.deleteJsonWebKeySetWithHttpInfo(set);
    }

    public ApiResponse<Void> deleteJsonWebKeySetWithHttpInfo(String set) throws ApiException {
        Call localVarCall = this.deleteJsonWebKeySetValidateBeforeCall(set, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteJsonWebKeySetAsync(String set, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteJsonWebKeySetValidateBeforeCall(set, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteOAuth2ClientCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clients/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteOAuth2ClientValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteOAuth2Client(Async)");
        }
        Call localVarCall = this.deleteOAuth2ClientCall(id, _callback);
        return localVarCall;
    }

    public void deleteOAuth2Client(String id) throws ApiException {
        this.deleteOAuth2ClientWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteOAuth2ClientWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.deleteOAuth2ClientValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteOAuth2ClientAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteOAuth2ClientValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteOAuth2TokenCall(String clientId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/tokens";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (clientId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("client_id", clientId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteOAuth2TokenValidateBeforeCall(String clientId, ApiCallback _callback) throws ApiException {
        if (clientId == null) {
            throw new ApiException("Missing the required parameter 'clientId' when calling deleteOAuth2Token(Async)");
        }
        Call localVarCall = this.deleteOAuth2TokenCall(clientId, _callback);
        return localVarCall;
    }

    public void deleteOAuth2Token(String clientId) throws ApiException {
        this.deleteOAuth2TokenWithHttpInfo(clientId);
    }

    public ApiResponse<Void> deleteOAuth2TokenWithHttpInfo(String clientId) throws ApiException {
        Call localVarCall = this.deleteOAuth2TokenValidateBeforeCall(clientId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteOAuth2TokenAsync(String clientId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteOAuth2TokenValidateBeforeCall(clientId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call flushInactiveOAuth2TokensCall(FlushInactiveOAuth2TokensRequest body, ApiCallback _callback) throws ApiException {
        FlushInactiveOAuth2TokensRequest localVarPostBody = body;
        String localVarPath = "/oauth2/flush";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call flushInactiveOAuth2TokensValidateBeforeCall(FlushInactiveOAuth2TokensRequest body, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.flushInactiveOAuth2TokensCall(body, _callback);
        return localVarCall;
    }

    public void flushInactiveOAuth2Tokens(FlushInactiveOAuth2TokensRequest body) throws ApiException {
        this.flushInactiveOAuth2TokensWithHttpInfo(body);
    }

    public ApiResponse<Void> flushInactiveOAuth2TokensWithHttpInfo(FlushInactiveOAuth2TokensRequest body) throws ApiException {
        Call localVarCall = this.flushInactiveOAuth2TokensValidateBeforeCall(body, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call flushInactiveOAuth2TokensAsync(FlushInactiveOAuth2TokensRequest body, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.flushInactiveOAuth2TokensValidateBeforeCall(body, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getConsentRequestCall(String consentChallenge, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/auth/requests/consent";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (consentChallenge != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("consent_challenge", consentChallenge));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getConsentRequestValidateBeforeCall(String consentChallenge, ApiCallback _callback) throws ApiException {
        if (consentChallenge == null) {
            throw new ApiException("Missing the required parameter 'consentChallenge' when calling getConsentRequest(Async)");
        }
        Call localVarCall = this.getConsentRequestCall(consentChallenge, _callback);
        return localVarCall;
    }

    public ConsentRequest getConsentRequest(String consentChallenge) throws ApiException {
        ApiResponse<ConsentRequest> localVarResp = this.getConsentRequestWithHttpInfo(consentChallenge);
        return localVarResp.getData();
    }

    public ApiResponse<ConsentRequest> getConsentRequestWithHttpInfo(String consentChallenge) throws ApiException {
        Call localVarCall = this.getConsentRequestValidateBeforeCall(consentChallenge, null);
        Type localVarReturnType = new TypeToken<ConsentRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getConsentRequestAsync(String consentChallenge, ApiCallback<ConsentRequest> _callback) throws ApiException {
        Call localVarCall = this.getConsentRequestValidateBeforeCall(consentChallenge, _callback);
        Type localVarReturnType = new TypeToken<ConsentRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getJsonWebKeyCall(String kid, String set, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/keys/{set}/{kid}".replaceAll("\\{kid\\}", this.localVarApiClient.escapeString(kid.toString())).replaceAll("\\{set\\}", this.localVarApiClient.escapeString(set.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getJsonWebKeyValidateBeforeCall(String kid, String set, ApiCallback _callback) throws ApiException {
        if (kid == null) {
            throw new ApiException("Missing the required parameter 'kid' when calling getJsonWebKey(Async)");
        }
        if (set == null) {
            throw new ApiException("Missing the required parameter 'set' when calling getJsonWebKey(Async)");
        }
        Call localVarCall = this.getJsonWebKeyCall(kid, set, _callback);
        return localVarCall;
    }

    public JSONWebKeySet getJsonWebKey(String kid, String set) throws ApiException {
        ApiResponse<JSONWebKeySet> localVarResp = this.getJsonWebKeyWithHttpInfo(kid, set);
        return localVarResp.getData();
    }

    public ApiResponse<JSONWebKeySet> getJsonWebKeyWithHttpInfo(String kid, String set) throws ApiException {
        Call localVarCall = this.getJsonWebKeyValidateBeforeCall(kid, set, null);
        Type localVarReturnType = new TypeToken<JSONWebKeySet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getJsonWebKeyAsync(String kid, String set, ApiCallback<JSONWebKeySet> _callback) throws ApiException {
        Call localVarCall = this.getJsonWebKeyValidateBeforeCall(kid, set, _callback);
        Type localVarReturnType = new TypeToken<JSONWebKeySet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getJsonWebKeySetCall(String set, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/keys/{set}".replaceAll("\\{set\\}", this.localVarApiClient.escapeString(set.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getJsonWebKeySetValidateBeforeCall(String set, ApiCallback _callback) throws ApiException {
        if (set == null) {
            throw new ApiException("Missing the required parameter 'set' when calling getJsonWebKeySet(Async)");
        }
        Call localVarCall = this.getJsonWebKeySetCall(set, _callback);
        return localVarCall;
    }

    public JSONWebKeySet getJsonWebKeySet(String set) throws ApiException {
        ApiResponse<JSONWebKeySet> localVarResp = this.getJsonWebKeySetWithHttpInfo(set);
        return localVarResp.getData();
    }

    public ApiResponse<JSONWebKeySet> getJsonWebKeySetWithHttpInfo(String set) throws ApiException {
        Call localVarCall = this.getJsonWebKeySetValidateBeforeCall(set, null);
        Type localVarReturnType = new TypeToken<JSONWebKeySet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getJsonWebKeySetAsync(String set, ApiCallback<JSONWebKeySet> _callback) throws ApiException {
        Call localVarCall = this.getJsonWebKeySetValidateBeforeCall(set, _callback);
        Type localVarReturnType = new TypeToken<JSONWebKeySet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLoginRequestCall(String loginChallenge, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/auth/requests/login";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (loginChallenge != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("login_challenge", loginChallenge));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLoginRequestValidateBeforeCall(String loginChallenge, ApiCallback _callback) throws ApiException {
        if (loginChallenge == null) {
            throw new ApiException("Missing the required parameter 'loginChallenge' when calling getLoginRequest(Async)");
        }
        Call localVarCall = this.getLoginRequestCall(loginChallenge, _callback);
        return localVarCall;
    }

    public LoginRequest getLoginRequest(String loginChallenge) throws ApiException {
        ApiResponse<LoginRequest> localVarResp = this.getLoginRequestWithHttpInfo(loginChallenge);
        return localVarResp.getData();
    }

    public ApiResponse<LoginRequest> getLoginRequestWithHttpInfo(String loginChallenge) throws ApiException {
        Call localVarCall = this.getLoginRequestValidateBeforeCall(loginChallenge, null);
        Type localVarReturnType = new TypeToken<LoginRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLoginRequestAsync(String loginChallenge, ApiCallback<LoginRequest> _callback) throws ApiException {
        Call localVarCall = this.getLoginRequestValidateBeforeCall(loginChallenge, _callback);
        Type localVarReturnType = new TypeToken<LoginRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLogoutRequestCall(String logoutChallenge, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/auth/requests/logout";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (logoutChallenge != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logout_challenge", logoutChallenge));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLogoutRequestValidateBeforeCall(String logoutChallenge, ApiCallback _callback) throws ApiException {
        if (logoutChallenge == null) {
            throw new ApiException("Missing the required parameter 'logoutChallenge' when calling getLogoutRequest(Async)");
        }
        Call localVarCall = this.getLogoutRequestCall(logoutChallenge, _callback);
        return localVarCall;
    }

    public LogoutRequest getLogoutRequest(String logoutChallenge) throws ApiException {
        ApiResponse<LogoutRequest> localVarResp = this.getLogoutRequestWithHttpInfo(logoutChallenge);
        return localVarResp.getData();
    }

    public ApiResponse<LogoutRequest> getLogoutRequestWithHttpInfo(String logoutChallenge) throws ApiException {
        Call localVarCall = this.getLogoutRequestValidateBeforeCall(logoutChallenge, null);
        Type localVarReturnType = new TypeToken<LogoutRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLogoutRequestAsync(String logoutChallenge, ApiCallback<LogoutRequest> _callback) throws ApiException {
        Call localVarCall = this.getLogoutRequestValidateBeforeCall(logoutChallenge, _callback);
        Type localVarReturnType = new TypeToken<LogoutRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getOAuth2ClientCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clients/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOAuth2ClientValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getOAuth2Client(Async)");
        }
        Call localVarCall = this.getOAuth2ClientCall(id, _callback);
        return localVarCall;
    }

    public OAuth2Client getOAuth2Client(String id) throws ApiException {
        ApiResponse<OAuth2Client> localVarResp = this.getOAuth2ClientWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<OAuth2Client> getOAuth2ClientWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getOAuth2ClientValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<OAuth2Client>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOAuth2ClientAsync(String id, ApiCallback<OAuth2Client> _callback) throws ApiException {
        Call localVarCall = this.getOAuth2ClientValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<OAuth2Client>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getVersionCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/version";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getVersionValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getVersionCall(_callback);
        return localVarCall;
    }

    public Version getVersion() throws ApiException {
        ApiResponse<Version> localVarResp = this.getVersionWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<Version> getVersionWithHttpInfo() throws ApiException {
        Call localVarCall = this.getVersionValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Version>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getVersionAsync(ApiCallback<Version> _callback) throws ApiException {
        Call localVarCall = this.getVersionValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Version>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call introspectOAuth2TokenCall(String token, String scope, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/introspect";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (token != null) {
            localVarFormParams.put("token", token);
        }
        if (scope != null) {
            localVarFormParams.put("scope", scope);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call introspectOAuth2TokenValidateBeforeCall(String token, String scope, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling introspectOAuth2Token(Async)");
        }
        Call localVarCall = this.introspectOAuth2TokenCall(token, scope, _callback);
        return localVarCall;
    }

    public OAuth2TokenIntrospection introspectOAuth2Token(String token, String scope) throws ApiException {
        ApiResponse<OAuth2TokenIntrospection> localVarResp = this.introspectOAuth2TokenWithHttpInfo(token, scope);
        return localVarResp.getData();
    }

    public ApiResponse<OAuth2TokenIntrospection> introspectOAuth2TokenWithHttpInfo(String token, String scope) throws ApiException {
        Call localVarCall = this.introspectOAuth2TokenValidateBeforeCall(token, scope, null);
        Type localVarReturnType = new TypeToken<OAuth2TokenIntrospection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call introspectOAuth2TokenAsync(String token, String scope, ApiCallback<OAuth2TokenIntrospection> _callback) throws ApiException {
        Call localVarCall = this.introspectOAuth2TokenValidateBeforeCall(token, scope, _callback);
        Type localVarReturnType = new TypeToken<OAuth2TokenIntrospection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call isInstanceAliveCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/health/alive";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call isInstanceAliveValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.isInstanceAliveCall(_callback);
        return localVarCall;
    }

    public HealthStatus isInstanceAlive() throws ApiException {
        ApiResponse<HealthStatus> localVarResp = this.isInstanceAliveWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<HealthStatus> isInstanceAliveWithHttpInfo() throws ApiException {
        Call localVarCall = this.isInstanceAliveValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<HealthStatus>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call isInstanceAliveAsync(ApiCallback<HealthStatus> _callback) throws ApiException {
        Call localVarCall = this.isInstanceAliveValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<HealthStatus>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listOAuth2ClientsCall(Long limit, Long offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clients";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOAuth2ClientsValidateBeforeCall(Long limit, Long offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listOAuth2ClientsCall(limit, offset, _callback);
        return localVarCall;
    }

    public List<OAuth2Client> listOAuth2Clients(Long limit, Long offset) throws ApiException {
        ApiResponse<List<OAuth2Client>> localVarResp = this.listOAuth2ClientsWithHttpInfo(limit, offset);
        return localVarResp.getData();
    }

    public ApiResponse<List<OAuth2Client>> listOAuth2ClientsWithHttpInfo(Long limit, Long offset) throws ApiException {
        Call localVarCall = this.listOAuth2ClientsValidateBeforeCall(limit, offset, null);
        Type localVarReturnType = new TypeToken<List<OAuth2Client>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listOAuth2ClientsAsync(Long limit, Long offset, ApiCallback<List<OAuth2Client>> _callback) throws ApiException {
        Call localVarCall = this.listOAuth2ClientsValidateBeforeCall(limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<OAuth2Client>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSubjectConsentSessionsCall(String subject, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/auth/sessions/consent";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subject != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subject", subject));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSubjectConsentSessionsValidateBeforeCall(String subject, ApiCallback _callback) throws ApiException {
        if (subject == null) {
            throw new ApiException("Missing the required parameter 'subject' when calling listSubjectConsentSessions(Async)");
        }
        Call localVarCall = this.listSubjectConsentSessionsCall(subject, _callback);
        return localVarCall;
    }

    public List<PreviousConsentSession> listSubjectConsentSessions(String subject) throws ApiException {
        ApiResponse<List<PreviousConsentSession>> localVarResp = this.listSubjectConsentSessionsWithHttpInfo(subject);
        return localVarResp.getData();
    }

    public ApiResponse<List<PreviousConsentSession>> listSubjectConsentSessionsWithHttpInfo(String subject) throws ApiException {
        Call localVarCall = this.listSubjectConsentSessionsValidateBeforeCall(subject, null);
        Type localVarReturnType = new TypeToken<List<PreviousConsentSession>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSubjectConsentSessionsAsync(String subject, ApiCallback<List<PreviousConsentSession>> _callback) throws ApiException {
        Call localVarCall = this.listSubjectConsentSessionsValidateBeforeCall(subject, _callback);
        Type localVarReturnType = new TypeToken<List<PreviousConsentSession>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call prometheusCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/metrics/prometheus";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call prometheusValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.prometheusCall(_callback);
        return localVarCall;
    }

    public void prometheus() throws ApiException {
        this.prometheusWithHttpInfo();
    }

    public ApiResponse<Void> prometheusWithHttpInfo() throws ApiException {
        Call localVarCall = this.prometheusValidateBeforeCall(null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call prometheusAsync(ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.prometheusValidateBeforeCall(_callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call rejectConsentRequestCall(String consentChallenge, RejectRequest body, ApiCallback _callback) throws ApiException {
        RejectRequest localVarPostBody = body;
        String localVarPath = "/oauth2/auth/requests/consent/reject";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (consentChallenge != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("consent_challenge", consentChallenge));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call rejectConsentRequestValidateBeforeCall(String consentChallenge, RejectRequest body, ApiCallback _callback) throws ApiException {
        if (consentChallenge == null) {
            throw new ApiException("Missing the required parameter 'consentChallenge' when calling rejectConsentRequest(Async)");
        }
        Call localVarCall = this.rejectConsentRequestCall(consentChallenge, body, _callback);
        return localVarCall;
    }

    public CompletedRequest rejectConsentRequest(String consentChallenge, RejectRequest body) throws ApiException {
        ApiResponse<CompletedRequest> localVarResp = this.rejectConsentRequestWithHttpInfo(consentChallenge, body);
        return localVarResp.getData();
    }

    public ApiResponse<CompletedRequest> rejectConsentRequestWithHttpInfo(String consentChallenge, RejectRequest body) throws ApiException {
        Call localVarCall = this.rejectConsentRequestValidateBeforeCall(consentChallenge, body, null);
        Type localVarReturnType = new TypeToken<CompletedRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call rejectConsentRequestAsync(String consentChallenge, RejectRequest body, ApiCallback<CompletedRequest> _callback) throws ApiException {
        Call localVarCall = this.rejectConsentRequestValidateBeforeCall(consentChallenge, body, _callback);
        Type localVarReturnType = new TypeToken<CompletedRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call rejectLoginRequestCall(String loginChallenge, RejectRequest body, ApiCallback _callback) throws ApiException {
        RejectRequest localVarPostBody = body;
        String localVarPath = "/oauth2/auth/requests/login/reject";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (loginChallenge != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("login_challenge", loginChallenge));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call rejectLoginRequestValidateBeforeCall(String loginChallenge, RejectRequest body, ApiCallback _callback) throws ApiException {
        if (loginChallenge == null) {
            throw new ApiException("Missing the required parameter 'loginChallenge' when calling rejectLoginRequest(Async)");
        }
        Call localVarCall = this.rejectLoginRequestCall(loginChallenge, body, _callback);
        return localVarCall;
    }

    public CompletedRequest rejectLoginRequest(String loginChallenge, RejectRequest body) throws ApiException {
        ApiResponse<CompletedRequest> localVarResp = this.rejectLoginRequestWithHttpInfo(loginChallenge, body);
        return localVarResp.getData();
    }

    public ApiResponse<CompletedRequest> rejectLoginRequestWithHttpInfo(String loginChallenge, RejectRequest body) throws ApiException {
        Call localVarCall = this.rejectLoginRequestValidateBeforeCall(loginChallenge, body, null);
        Type localVarReturnType = new TypeToken<CompletedRequest>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call rejectLoginRequestAsync(String loginChallenge, RejectRequest body, ApiCallback<CompletedRequest> _callback) throws ApiException {
        Call localVarCall = this.rejectLoginRequestValidateBeforeCall(loginChallenge, body, _callback);
        Type localVarReturnType = new TypeToken<CompletedRequest>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call rejectLogoutRequestCall(String logoutChallenge, RejectRequest body, ApiCallback _callback) throws ApiException {
        RejectRequest localVarPostBody = body;
        String localVarPath = "/oauth2/auth/requests/logout/reject";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (logoutChallenge != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logout_challenge", logoutChallenge));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json", "application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call rejectLogoutRequestValidateBeforeCall(String logoutChallenge, RejectRequest body, ApiCallback _callback) throws ApiException {
        if (logoutChallenge == null) {
            throw new ApiException("Missing the required parameter 'logoutChallenge' when calling rejectLogoutRequest(Async)");
        }
        Call localVarCall = this.rejectLogoutRequestCall(logoutChallenge, body, _callback);
        return localVarCall;
    }

    public void rejectLogoutRequest(String logoutChallenge, RejectRequest body) throws ApiException {
        this.rejectLogoutRequestWithHttpInfo(logoutChallenge, body);
    }

    public ApiResponse<Void> rejectLogoutRequestWithHttpInfo(String logoutChallenge, RejectRequest body) throws ApiException {
        Call localVarCall = this.rejectLogoutRequestValidateBeforeCall(logoutChallenge, body, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call rejectLogoutRequestAsync(String logoutChallenge, RejectRequest body, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.rejectLogoutRequestValidateBeforeCall(logoutChallenge, body, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call revokeAuthenticationSessionCall(String subject, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/auth/sessions/login";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subject != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subject", subject));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call revokeAuthenticationSessionValidateBeforeCall(String subject, ApiCallback _callback) throws ApiException {
        if (subject == null) {
            throw new ApiException("Missing the required parameter 'subject' when calling revokeAuthenticationSession(Async)");
        }
        Call localVarCall = this.revokeAuthenticationSessionCall(subject, _callback);
        return localVarCall;
    }

    public void revokeAuthenticationSession(String subject) throws ApiException {
        this.revokeAuthenticationSessionWithHttpInfo(subject);
    }

    public ApiResponse<Void> revokeAuthenticationSessionWithHttpInfo(String subject) throws ApiException {
        Call localVarCall = this.revokeAuthenticationSessionValidateBeforeCall(subject, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call revokeAuthenticationSessionAsync(String subject, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.revokeAuthenticationSessionValidateBeforeCall(subject, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call revokeConsentSessionsCall(String subject, String client, Boolean all, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/oauth2/auth/sessions/consent";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subject != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subject", subject));
        }
        if (client != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("client", client));
        }
        if (all != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("all", all));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call revokeConsentSessionsValidateBeforeCall(String subject, String client, Boolean all, ApiCallback _callback) throws ApiException {
        if (subject == null) {
            throw new ApiException("Missing the required parameter 'subject' when calling revokeConsentSessions(Async)");
        }
        Call localVarCall = this.revokeConsentSessionsCall(subject, client, all, _callback);
        return localVarCall;
    }

    public void revokeConsentSessions(String subject, String client, Boolean all) throws ApiException {
        this.revokeConsentSessionsWithHttpInfo(subject, client, all);
    }

    public ApiResponse<Void> revokeConsentSessionsWithHttpInfo(String subject, String client, Boolean all) throws ApiException {
        Call localVarCall = this.revokeConsentSessionsValidateBeforeCall(subject, client, all, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call revokeConsentSessionsAsync(String subject, String client, Boolean all, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.revokeConsentSessionsValidateBeforeCall(subject, client, all, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateJsonWebKeyCall(String kid, String set, JSONWebKey body, ApiCallback _callback) throws ApiException {
        JSONWebKey localVarPostBody = body;
        String localVarPath = "/keys/{set}/{kid}".replaceAll("\\{kid\\}", this.localVarApiClient.escapeString(kid.toString())).replaceAll("\\{set\\}", this.localVarApiClient.escapeString(set.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateJsonWebKeyValidateBeforeCall(String kid, String set, JSONWebKey body, ApiCallback _callback) throws ApiException {
        if (kid == null) {
            throw new ApiException("Missing the required parameter 'kid' when calling updateJsonWebKey(Async)");
        }
        if (set == null) {
            throw new ApiException("Missing the required parameter 'set' when calling updateJsonWebKey(Async)");
        }
        Call localVarCall = this.updateJsonWebKeyCall(kid, set, body, _callback);
        return localVarCall;
    }

    public JSONWebKey updateJsonWebKey(String kid, String set, JSONWebKey body) throws ApiException {
        ApiResponse<JSONWebKey> localVarResp = this.updateJsonWebKeyWithHttpInfo(kid, set, body);
        return localVarResp.getData();
    }

    public ApiResponse<JSONWebKey> updateJsonWebKeyWithHttpInfo(String kid, String set, JSONWebKey body) throws ApiException {
        Call localVarCall = this.updateJsonWebKeyValidateBeforeCall(kid, set, body, null);
        Type localVarReturnType = new TypeToken<JSONWebKey>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateJsonWebKeyAsync(String kid, String set, JSONWebKey body, ApiCallback<JSONWebKey> _callback) throws ApiException {
        Call localVarCall = this.updateJsonWebKeyValidateBeforeCall(kid, set, body, _callback);
        Type localVarReturnType = new TypeToken<JSONWebKey>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateJsonWebKeySetCall(String set, JSONWebKeySet body, ApiCallback _callback) throws ApiException {
        JSONWebKeySet localVarPostBody = body;
        String localVarPath = "/keys/{set}".replaceAll("\\{set\\}", this.localVarApiClient.escapeString(set.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateJsonWebKeySetValidateBeforeCall(String set, JSONWebKeySet body, ApiCallback _callback) throws ApiException {
        if (set == null) {
            throw new ApiException("Missing the required parameter 'set' when calling updateJsonWebKeySet(Async)");
        }
        Call localVarCall = this.updateJsonWebKeySetCall(set, body, _callback);
        return localVarCall;
    }

    public JSONWebKeySet updateJsonWebKeySet(String set, JSONWebKeySet body) throws ApiException {
        ApiResponse<JSONWebKeySet> localVarResp = this.updateJsonWebKeySetWithHttpInfo(set, body);
        return localVarResp.getData();
    }

    public ApiResponse<JSONWebKeySet> updateJsonWebKeySetWithHttpInfo(String set, JSONWebKeySet body) throws ApiException {
        Call localVarCall = this.updateJsonWebKeySetValidateBeforeCall(set, body, null);
        Type localVarReturnType = new TypeToken<JSONWebKeySet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateJsonWebKeySetAsync(String set, JSONWebKeySet body, ApiCallback<JSONWebKeySet> _callback) throws ApiException {
        Call localVarCall = this.updateJsonWebKeySetValidateBeforeCall(set, body, _callback);
        Type localVarReturnType = new TypeToken<JSONWebKeySet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateOAuth2ClientCall(String id, OAuth2Client body, ApiCallback _callback) throws ApiException {
        OAuth2Client localVarPostBody = body;
        String localVarPath = "/clients/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateOAuth2ClientValidateBeforeCall(String id, OAuth2Client body, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateOAuth2Client(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updateOAuth2Client(Async)");
        }
        Call localVarCall = this.updateOAuth2ClientCall(id, body, _callback);
        return localVarCall;
    }

    public OAuth2Client updateOAuth2Client(String id, OAuth2Client body) throws ApiException {
        ApiResponse<OAuth2Client> localVarResp = this.updateOAuth2ClientWithHttpInfo(id, body);
        return localVarResp.getData();
    }

    public ApiResponse<OAuth2Client> updateOAuth2ClientWithHttpInfo(String id, OAuth2Client body) throws ApiException {
        Call localVarCall = this.updateOAuth2ClientValidateBeforeCall(id, body, null);
        Type localVarReturnType = new TypeToken<OAuth2Client>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateOAuth2ClientAsync(String id, OAuth2Client body, ApiCallback<OAuth2Client> _callback) throws ApiException {
        Call localVarCall = this.updateOAuth2ClientValidateBeforeCall(id, body, _callback);
        Type localVarReturnType = new TypeToken<OAuth2Client>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

