/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class ConsentRequestSession {
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private Object accessToken;
    public static final String SERIALIZED_NAME_ID_TOKEN = "id_token";
    @SerializedName(value="id_token")
    private Object idToken;

    public ConsentRequestSession accessToken(Object accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AccessToken sets session data for the access and refresh token, as well as any future tokens issued by the refresh grant. Keep in mind that this data will be available to anyone performing OAuth 2.0 Challenge Introspection. If only your services can perform OAuth 2.0 Challenge Introspection, this is usually fine. But if third parties can access that endpoint as well, sensitive data from the session might be exposed to them. Use with care!")
    public Object getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(Object accessToken) {
        this.accessToken = accessToken;
    }

    public ConsentRequestSession idToken(Object idToken) {
        this.idToken = idToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IDToken sets session data for the OpenID Connect ID token. Keep in mind that the session'id payloads are readable by anyone that has access to the ID Challenge. Use with care!")
    public Object getIdToken() {
        return this.idToken;
    }

    public void setIdToken(Object idToken) {
        this.idToken = idToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsentRequestSession consentRequestSession = (ConsentRequestSession)o;
        return Objects.equals(this.accessToken, consentRequestSession.accessToken) && Objects.equals(this.idToken, consentRequestSession.idToken);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.idToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConsentRequestSession {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    idToken: ").append(this.toIndentedString(this.idToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

