/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class JsonWebKeySetGeneratorRequest {
    public static final String SERIALIZED_NAME_ALG = "alg";
    @SerializedName(value="alg")
    private String alg;
    public static final String SERIALIZED_NAME_KID = "kid";
    @SerializedName(value="kid")
    private String kid;
    public static final String SERIALIZED_NAME_USE = "use";
    @SerializedName(value="use")
    private String use;

    public JsonWebKeySetGeneratorRequest alg(String alg) {
        this.alg = alg;
        return this;
    }

    @ApiModelProperty(required=true, value="The algorithm to be used for creating the key. Supports \"RS256\", \"ES512\", \"HS512\", and \"HS256\"")
    public String getAlg() {
        return this.alg;
    }

    public void setAlg(String alg) {
        this.alg = alg;
    }

    public JsonWebKeySetGeneratorRequest kid(String kid) {
        this.kid = kid;
        return this;
    }

    @ApiModelProperty(required=true, value="The kid of the key to be created")
    public String getKid() {
        return this.kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public JsonWebKeySetGeneratorRequest use(String use) {
        this.use = use;
        return this;
    }

    @ApiModelProperty(required=true, value="The \"use\" (public key use) parameter identifies the intended use of the public key. The \"use\" parameter is employed to indicate whether a public key is used for encrypting data or verifying the signature on data. Valid values are \"enc\" and \"sig\".")
    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonWebKeySetGeneratorRequest jsonWebKeySetGeneratorRequest = (JsonWebKeySetGeneratorRequest)o;
        return Objects.equals(this.alg, jsonWebKeySetGeneratorRequest.alg) && Objects.equals(this.kid, jsonWebKeySetGeneratorRequest.kid) && Objects.equals(this.use, jsonWebKeySetGeneratorRequest.use);
    }

    public int hashCode() {
        return Objects.hash(this.alg, this.kid, this.use);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JsonWebKeySetGeneratorRequest {\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    use: ").append(this.toIndentedString(this.use)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

