/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="https://tools.ietf.org/html/rfc7662")
public class OAuth2TokenIntrospection {
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_AUD = "aud";
    @SerializedName(value="aud")
    private List<String> aud = null;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_EXP = "exp";
    @SerializedName(value="exp")
    private Long exp;
    public static final String SERIALIZED_NAME_EXT = "ext";
    @SerializedName(value="ext")
    private Object ext;
    public static final String SERIALIZED_NAME_IAT = "iat";
    @SerializedName(value="iat")
    private Long iat;
    public static final String SERIALIZED_NAME_ISS = "iss";
    @SerializedName(value="iss")
    private String iss;
    public static final String SERIALIZED_NAME_NBF = "nbf";
    @SerializedName(value="nbf")
    private Long nbf;
    public static final String SERIALIZED_NAME_OBFUSCATED_SUBJECT = "obfuscated_subject";
    @SerializedName(value="obfuscated_subject")
    private String obfuscatedSubject;
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    private String scope;
    public static final String SERIALIZED_NAME_SUB = "sub";
    @SerializedName(value="sub")
    private String sub;
    public static final String SERIALIZED_NAME_TOKEN_TYPE = "token_type";
    @SerializedName(value="token_type")
    private String tokenType;
    public static final String SERIALIZED_NAME_TOKEN_USE = "token_use";
    @SerializedName(value="token_use")
    private String tokenUse;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;

    public OAuth2TokenIntrospection active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(required=true, value="Active is a boolean indicator of whether or not the presented token is currently active.  The specifics of a token's \"active\" state will vary depending on the implementation of the authorization server and the information it keeps about its tokens, but a \"true\" value return for the \"active\" property will generally indicate that a given token has been issued by this authorization server, has not been revoked by the resource owner, and is within its given time window of validity (e.g., after its issuance time and before its expiration time).")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public OAuth2TokenIntrospection aud(List<String> aud) {
        this.aud = aud;
        return this;
    }

    public OAuth2TokenIntrospection addAudItem(String audItem) {
        if (this.aud == null) {
            this.aud = new ArrayList<String>();
        }
        this.aud.add(audItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Audience contains a list of the token's intended audiences.")
    public List<String> getAud() {
        return this.aud;
    }

    public void setAud(List<String> aud) {
        this.aud = aud;
    }

    public OAuth2TokenIntrospection clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID is aclient identifier for the OAuth 2.0 client that requested this token.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OAuth2TokenIntrospection exp(Long exp) {
        this.exp = exp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Expires at is an integer timestamp, measured in the number of seconds since January 1 1970 UTC, indicating when this token will expire.")
    public Long getExp() {
        return this.exp;
    }

    public void setExp(Long exp) {
        this.exp = exp;
    }

    public OAuth2TokenIntrospection ext(Object ext) {
        this.ext = ext;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Extra is arbitrary data set by the session.")
    public Object getExt() {
        return this.ext;
    }

    public void setExt(Object ext) {
        this.ext = ext;
    }

    public OAuth2TokenIntrospection iat(Long iat) {
        this.iat = iat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Issued at is an integer timestamp, measured in the number of seconds since January 1 1970 UTC, indicating when this token was originally issued.")
    public Long getIat() {
        return this.iat;
    }

    public void setIat(Long iat) {
        this.iat = iat;
    }

    public OAuth2TokenIntrospection iss(String iss) {
        this.iss = iss;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IssuerURL is a string representing the issuer of this token")
    public String getIss() {
        return this.iss;
    }

    public void setIss(String iss) {
        this.iss = iss;
    }

    public OAuth2TokenIntrospection nbf(Long nbf) {
        this.nbf = nbf;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NotBefore is an integer timestamp, measured in the number of seconds since January 1 1970 UTC, indicating when this token is not to be used before.")
    public Long getNbf() {
        return this.nbf;
    }

    public void setNbf(Long nbf) {
        this.nbf = nbf;
    }

    public OAuth2TokenIntrospection obfuscatedSubject(String obfuscatedSubject) {
        this.obfuscatedSubject = obfuscatedSubject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ObfuscatedSubject is set when the subject identifier algorithm was set to \"pairwise\" during authorization. It is the `sub` value of the ID Token that was issued.")
    public String getObfuscatedSubject() {
        return this.obfuscatedSubject;
    }

    public void setObfuscatedSubject(String obfuscatedSubject) {
        this.obfuscatedSubject = obfuscatedSubject;
    }

    public OAuth2TokenIntrospection scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Scope is a JSON string containing a space-separated list of scopes associated with this token.")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public OAuth2TokenIntrospection sub(String sub) {
        this.sub = sub;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Subject of the token, as defined in JWT [RFC7519]. Usually a machine-readable identifier of the resource owner who authorized this token.")
    public String getSub() {
        return this.sub;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public OAuth2TokenIntrospection tokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TokenType is the introspected token's type, typically `Bearer`.")
    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public OAuth2TokenIntrospection tokenUse(String tokenUse) {
        this.tokenUse = tokenUse;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TokenUse is the introspected token's use, for example `access_token` or `refresh_token`.")
    public String getTokenUse() {
        return this.tokenUse;
    }

    public void setTokenUse(String tokenUse) {
        this.tokenUse = tokenUse;
    }

    public OAuth2TokenIntrospection username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Username is a human-readable identifier for the resource owner who authorized this token.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2TokenIntrospection oAuth2TokenIntrospection = (OAuth2TokenIntrospection)o;
        return Objects.equals(this.active, oAuth2TokenIntrospection.active) && Objects.equals(this.aud, oAuth2TokenIntrospection.aud) && Objects.equals(this.clientId, oAuth2TokenIntrospection.clientId) && Objects.equals(this.exp, oAuth2TokenIntrospection.exp) && Objects.equals(this.ext, oAuth2TokenIntrospection.ext) && Objects.equals(this.iat, oAuth2TokenIntrospection.iat) && Objects.equals(this.iss, oAuth2TokenIntrospection.iss) && Objects.equals(this.nbf, oAuth2TokenIntrospection.nbf) && Objects.equals(this.obfuscatedSubject, oAuth2TokenIntrospection.obfuscatedSubject) && Objects.equals(this.scope, oAuth2TokenIntrospection.scope) && Objects.equals(this.sub, oAuth2TokenIntrospection.sub) && Objects.equals(this.tokenType, oAuth2TokenIntrospection.tokenType) && Objects.equals(this.tokenUse, oAuth2TokenIntrospection.tokenUse) && Objects.equals(this.username, oAuth2TokenIntrospection.username);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.aud, this.clientId, this.exp, this.ext, this.iat, this.iss, this.nbf, this.obfuscatedSubject, this.scope, this.sub, this.tokenType, this.tokenUse, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2TokenIntrospection {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    aud: ").append(this.toIndentedString(this.aud)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    exp: ").append(this.toIndentedString(this.exp)).append("\n");
        sb.append("    ext: ").append(this.toIndentedString(this.ext)).append("\n");
        sb.append("    iat: ").append(this.toIndentedString(this.iat)).append("\n");
        sb.append("    iss: ").append(this.toIndentedString(this.iss)).append("\n");
        sb.append("    nbf: ").append(this.toIndentedString(this.nbf)).append("\n");
        sb.append("    obfuscatedSubject: ").append(this.toIndentedString(this.obfuscatedSubject)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    sub: ").append(this.toIndentedString(this.sub)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString(this.tokenType)).append("\n");
        sb.append("    tokenUse: ").append(this.toIndentedString(this.tokenUse)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

