/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class RejectRequest {
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private String error;
    public static final String SERIALIZED_NAME_ERROR_DEBUG = "error_debug";
    @SerializedName(value="error_debug")
    private String errorDebug;
    public static final String SERIALIZED_NAME_ERROR_DESCRIPTION = "error_description";
    @SerializedName(value="error_description")
    private String errorDescription;
    public static final String SERIALIZED_NAME_ERROR_HINT = "error_hint";
    @SerializedName(value="error_hint")
    private String errorHint;
    public static final String SERIALIZED_NAME_STATUS_CODE = "status_code";
    @SerializedName(value="status_code")
    private Long statusCode;

    public RejectRequest error(String error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The error should follow the OAuth2 error format (e.g. `invalid_request`, `login_required`).  Defaults to `request_denied`.")
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public RejectRequest errorDebug(String errorDebug) {
        this.errorDebug = errorDebug;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Debug contains information to help resolve the problem as a developer. Usually not exposed to the public but only in the server logs.")
    public String getErrorDebug() {
        return this.errorDebug;
    }

    public void setErrorDebug(String errorDebug) {
        this.errorDebug = errorDebug;
    }

    public RejectRequest errorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the error in a human readable format.")
    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public RejectRequest errorHint(String errorHint) {
        this.errorHint = errorHint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Hint to help resolve the error.")
    public String getErrorHint() {
        return this.errorHint;
    }

    public void setErrorHint(String errorHint) {
        this.errorHint = errorHint;
    }

    public RejectRequest statusCode(Long statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the HTTP status code of the error (e.g. 401 or 403)  Defaults to 400")
    public Long getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Long statusCode) {
        this.statusCode = statusCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RejectRequest rejectRequest = (RejectRequest)o;
        return Objects.equals(this.error, rejectRequest.error) && Objects.equals(this.errorDebug, rejectRequest.errorDebug) && Objects.equals(this.errorDescription, rejectRequest.errorDescription) && Objects.equals(this.errorHint, rejectRequest.errorHint) && Objects.equals(this.statusCode, rejectRequest.statusCode);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.errorDebug, this.errorDescription, this.errorHint, this.statusCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RejectRequest {\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    errorDebug: ").append(this.toIndentedString(this.errorDebug)).append("\n");
        sb.append("    errorDescription: ").append(this.toIndentedString(this.errorDescription)).append("\n");
        sb.append("    errorHint: ").append(this.toIndentedString(this.errorHint)).append("\n");
        sb.append("    statusCode: ").append(this.toIndentedString(this.statusCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

