/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="It includes links to several endpoints (e.g. /oauth2/token) and exposes information on supported signature algorithms among others.")
public class WellKnown {
    public static final String SERIALIZED_NAME_AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    @SerializedName(value="authorization_endpoint")
    private String authorizationEndpoint;
    public static final String SERIALIZED_NAME_BACKCHANNEL_LOGOUT_SESSION_SUPPORTED = "backchannel_logout_session_supported";
    @SerializedName(value="backchannel_logout_session_supported")
    private Boolean backchannelLogoutSessionSupported;
    public static final String SERIALIZED_NAME_BACKCHANNEL_LOGOUT_SUPPORTED = "backchannel_logout_supported";
    @SerializedName(value="backchannel_logout_supported")
    private Boolean backchannelLogoutSupported;
    public static final String SERIALIZED_NAME_CLAIMS_PARAMETER_SUPPORTED = "claims_parameter_supported";
    @SerializedName(value="claims_parameter_supported")
    private Boolean claimsParameterSupported;
    public static final String SERIALIZED_NAME_CLAIMS_SUPPORTED = "claims_supported";
    @SerializedName(value="claims_supported")
    private List<String> claimsSupported = null;
    public static final String SERIALIZED_NAME_END_SESSION_ENDPOINT = "end_session_endpoint";
    @SerializedName(value="end_session_endpoint")
    private String endSessionEndpoint;
    public static final String SERIALIZED_NAME_FRONTCHANNEL_LOGOUT_SESSION_SUPPORTED = "frontchannel_logout_session_supported";
    @SerializedName(value="frontchannel_logout_session_supported")
    private Boolean frontchannelLogoutSessionSupported;
    public static final String SERIALIZED_NAME_FRONTCHANNEL_LOGOUT_SUPPORTED = "frontchannel_logout_supported";
    @SerializedName(value="frontchannel_logout_supported")
    private Boolean frontchannelLogoutSupported;
    public static final String SERIALIZED_NAME_GRANT_TYPES_SUPPORTED = "grant_types_supported";
    @SerializedName(value="grant_types_supported")
    private List<String> grantTypesSupported = null;
    public static final String SERIALIZED_NAME_ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED = "id_token_signing_alg_values_supported";
    @SerializedName(value="id_token_signing_alg_values_supported")
    private List<String> idTokenSigningAlgValuesSupported = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ISSUER = "issuer";
    @SerializedName(value="issuer")
    private String issuer;
    public static final String SERIALIZED_NAME_JWKS_URI = "jwks_uri";
    @SerializedName(value="jwks_uri")
    private String jwksUri;
    public static final String SERIALIZED_NAME_REGISTRATION_ENDPOINT = "registration_endpoint";
    @SerializedName(value="registration_endpoint")
    private String registrationEndpoint;
    public static final String SERIALIZED_NAME_REQUEST_OBJECT_SIGNING_ALG_VALUES_SUPPORTED = "request_object_signing_alg_values_supported";
    @SerializedName(value="request_object_signing_alg_values_supported")
    private List<String> requestObjectSigningAlgValuesSupported = null;
    public static final String SERIALIZED_NAME_REQUEST_PARAMETER_SUPPORTED = "request_parameter_supported";
    @SerializedName(value="request_parameter_supported")
    private Boolean requestParameterSupported;
    public static final String SERIALIZED_NAME_REQUEST_URI_PARAMETER_SUPPORTED = "request_uri_parameter_supported";
    @SerializedName(value="request_uri_parameter_supported")
    private Boolean requestUriParameterSupported;
    public static final String SERIALIZED_NAME_REQUIRE_REQUEST_URI_REGISTRATION = "require_request_uri_registration";
    @SerializedName(value="require_request_uri_registration")
    private Boolean requireRequestUriRegistration;
    public static final String SERIALIZED_NAME_RESPONSE_MODES_SUPPORTED = "response_modes_supported";
    @SerializedName(value="response_modes_supported")
    private List<String> responseModesSupported = null;
    public static final String SERIALIZED_NAME_RESPONSE_TYPES_SUPPORTED = "response_types_supported";
    @SerializedName(value="response_types_supported")
    private List<String> responseTypesSupported = new ArrayList<String>();
    public static final String SERIALIZED_NAME_REVOCATION_ENDPOINT = "revocation_endpoint";
    @SerializedName(value="revocation_endpoint")
    private String revocationEndpoint;
    public static final String SERIALIZED_NAME_SCOPES_SUPPORTED = "scopes_supported";
    @SerializedName(value="scopes_supported")
    private List<String> scopesSupported = null;
    public static final String SERIALIZED_NAME_SUBJECT_TYPES_SUPPORTED = "subject_types_supported";
    @SerializedName(value="subject_types_supported")
    private List<String> subjectTypesSupported = new ArrayList<String>();
    public static final String SERIALIZED_NAME_TOKEN_ENDPOINT = "token_endpoint";
    @SerializedName(value="token_endpoint")
    private String tokenEndpoint;
    public static final String SERIALIZED_NAME_TOKEN_ENDPOINT_AUTH_METHODS_SUPPORTED = "token_endpoint_auth_methods_supported";
    @SerializedName(value="token_endpoint_auth_methods_supported")
    private List<String> tokenEndpointAuthMethodsSupported = null;
    public static final String SERIALIZED_NAME_USERINFO_ENDPOINT = "userinfo_endpoint";
    @SerializedName(value="userinfo_endpoint")
    private String userinfoEndpoint;
    public static final String SERIALIZED_NAME_USERINFO_SIGNING_ALG_VALUES_SUPPORTED = "userinfo_signing_alg_values_supported";
    @SerializedName(value="userinfo_signing_alg_values_supported")
    private List<String> userinfoSigningAlgValuesSupported = null;

    public WellKnown authorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
        return this;
    }

    @ApiModelProperty(example="https://playground.ory.sh/ory-hydra/public/oauth2/auth", required=true, value="URL of the OP's OAuth 2.0 Authorization Endpoint.")
    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public WellKnown backchannelLogoutSessionSupported(Boolean backchannelLogoutSessionSupported) {
        this.backchannelLogoutSessionSupported = backchannelLogoutSessionSupported;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean value specifying whether the OP can pass a sid (session ID) Claim in the Logout Token to identify the RP session with the OP. If supported, the sid Claim is also included in ID Tokens issued by the OP")
    public Boolean getBackchannelLogoutSessionSupported() {
        return this.backchannelLogoutSessionSupported;
    }

    public void setBackchannelLogoutSessionSupported(Boolean backchannelLogoutSessionSupported) {
        this.backchannelLogoutSessionSupported = backchannelLogoutSessionSupported;
    }

    public WellKnown backchannelLogoutSupported(Boolean backchannelLogoutSupported) {
        this.backchannelLogoutSupported = backchannelLogoutSupported;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean value specifying whether the OP supports back-channel logout, with true indicating support.")
    public Boolean getBackchannelLogoutSupported() {
        return this.backchannelLogoutSupported;
    }

    public void setBackchannelLogoutSupported(Boolean backchannelLogoutSupported) {
        this.backchannelLogoutSupported = backchannelLogoutSupported;
    }

    public WellKnown claimsParameterSupported(Boolean claimsParameterSupported) {
        this.claimsParameterSupported = claimsParameterSupported;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean value specifying whether the OP supports use of the claims parameter, with true indicating support.")
    public Boolean getClaimsParameterSupported() {
        return this.claimsParameterSupported;
    }

    public void setClaimsParameterSupported(Boolean claimsParameterSupported) {
        this.claimsParameterSupported = claimsParameterSupported;
    }

    public WellKnown claimsSupported(List<String> claimsSupported) {
        this.claimsSupported = claimsSupported;
        return this;
    }

    public WellKnown addClaimsSupportedItem(String claimsSupportedItem) {
        if (this.claimsSupported == null) {
            this.claimsSupported = new ArrayList<String>();
        }
        this.claimsSupported.add(claimsSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="JSON array containing a list of the Claim Names of the Claims that the OpenID Provider MAY be able to supply values for. Note that for privacy or other reasons, this might not be an exhaustive list.")
    public List<String> getClaimsSupported() {
        return this.claimsSupported;
    }

    public void setClaimsSupported(List<String> claimsSupported) {
        this.claimsSupported = claimsSupported;
    }

    public WellKnown endSessionEndpoint(String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL at the OP to which an RP can perform a redirect to request that the End-User be logged out at the OP.")
    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpoint(String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
    }

    public WellKnown frontchannelLogoutSessionSupported(Boolean frontchannelLogoutSessionSupported) {
        this.frontchannelLogoutSessionSupported = frontchannelLogoutSessionSupported;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean value specifying whether the OP can pass iss (issuer) and sid (session ID) query parameters to identify the RP session with the OP when the frontchannel_logout_uri is used. If supported, the sid Claim is also included in ID Tokens issued by the OP.")
    public Boolean getFrontchannelLogoutSessionSupported() {
        return this.frontchannelLogoutSessionSupported;
    }

    public void setFrontchannelLogoutSessionSupported(Boolean frontchannelLogoutSessionSupported) {
        this.frontchannelLogoutSessionSupported = frontchannelLogoutSessionSupported;
    }

    public WellKnown frontchannelLogoutSupported(Boolean frontchannelLogoutSupported) {
        this.frontchannelLogoutSupported = frontchannelLogoutSupported;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean value specifying whether the OP supports HTTP-based logout, with true indicating support.")
    public Boolean getFrontchannelLogoutSupported() {
        return this.frontchannelLogoutSupported;
    }

    public void setFrontchannelLogoutSupported(Boolean frontchannelLogoutSupported) {
        this.frontchannelLogoutSupported = frontchannelLogoutSupported;
    }

    public WellKnown grantTypesSupported(List<String> grantTypesSupported) {
        this.grantTypesSupported = grantTypesSupported;
        return this;
    }

    public WellKnown addGrantTypesSupportedItem(String grantTypesSupportedItem) {
        if (this.grantTypesSupported == null) {
            this.grantTypesSupported = new ArrayList<String>();
        }
        this.grantTypesSupported.add(grantTypesSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="JSON array containing a list of the OAuth 2.0 Grant Type values that this OP supports.")
    public List<String> getGrantTypesSupported() {
        return this.grantTypesSupported;
    }

    public void setGrantTypesSupported(List<String> grantTypesSupported) {
        this.grantTypesSupported = grantTypesSupported;
    }

    public WellKnown idTokenSigningAlgValuesSupported(List<String> idTokenSigningAlgValuesSupported) {
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
        return this;
    }

    public WellKnown addIdTokenSigningAlgValuesSupportedItem(String idTokenSigningAlgValuesSupportedItem) {
        this.idTokenSigningAlgValuesSupported.add(idTokenSigningAlgValuesSupportedItem);
        return this;
    }

    @ApiModelProperty(required=true, value="JSON array containing a list of the JWS signing algorithms (alg values) supported by the OP for the ID Token to encode the Claims in a JWT.")
    public List<String> getIdTokenSigningAlgValuesSupported() {
        return this.idTokenSigningAlgValuesSupported;
    }

    public void setIdTokenSigningAlgValuesSupported(List<String> idTokenSigningAlgValuesSupported) {
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
    }

    public WellKnown issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @ApiModelProperty(example="https://playground.ory.sh/ory-hydra/public/", required=true, value="URL using the https scheme with no query or fragment component that the OP asserts as its IssuerURL Identifier. If IssuerURL discovery is supported , this value MUST be identical to the issuer value returned by WebFinger. This also MUST be identical to the iss Claim value in ID Tokens issued from this IssuerURL.")
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public WellKnown jwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
        return this;
    }

    @ApiModelProperty(example="https://playground.ory.sh/ory-hydra/public/.well-known/jwks.json", required=true, value="URL of the OP's JSON Web Key Set [JWK] document. This contains the signing key(s) the RP uses to validate signatures from the OP. The JWK Set MAY also contain the Server's encryption key(s), which are used by RPs to encrypt requests to the Server. When both signing and encryption keys are made available, a use (Key Use) parameter value is REQUIRED for all keys in the referenced JWK Set to indicate each key's intended usage. Although some algorithms allow the same key to be used for both signatures and encryption, doing so is NOT RECOMMENDED, as it is less secure. The JWK x5c parameter MAY be used to provide X.509 representations of keys provided. When used, the bare key values MUST still be present and MUST match those in the certificate.")
    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public WellKnown registrationEndpoint(String registrationEndpoint) {
        this.registrationEndpoint = registrationEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://playground.ory.sh/ory-hydra/admin/client", value="URL of the OP's Dynamic Client Registration Endpoint.")
    public String getRegistrationEndpoint() {
        return this.registrationEndpoint;
    }

    public void setRegistrationEndpoint(String registrationEndpoint) {
        this.registrationEndpoint = registrationEndpoint;
    }

    public WellKnown requestObjectSigningAlgValuesSupported(List<String> requestObjectSigningAlgValuesSupported) {
        this.requestObjectSigningAlgValuesSupported = requestObjectSigningAlgValuesSupported;
        return this;
    }

    public WellKnown addRequestObjectSigningAlgValuesSupportedItem(String requestObjectSigningAlgValuesSupportedItem) {
        if (this.requestObjectSigningAlgValuesSupported == null) {
            this.requestObjectSigningAlgValuesSupported = new ArrayList<String>();
        }
        this.requestObjectSigningAlgValuesSupported.add(requestObjectSigningAlgValuesSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="JSON array containing a list of the JWS signing algorithms (alg values) supported by the OP for Request Objects, which are described in Section 6.1 of OpenID Connect Core 1.0 [OpenID.Core]. These algorithms are used both when the Request Object is passed by value (using the request parameter) and when it is passed by reference (using the request_uri parameter).")
    public List<String> getRequestObjectSigningAlgValuesSupported() {
        return this.requestObjectSigningAlgValuesSupported;
    }

    public void setRequestObjectSigningAlgValuesSupported(List<String> requestObjectSigningAlgValuesSupported) {
        this.requestObjectSigningAlgValuesSupported = requestObjectSigningAlgValuesSupported;
    }

    public WellKnown requestParameterSupported(Boolean requestParameterSupported) {
        this.requestParameterSupported = requestParameterSupported;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean value specifying whether the OP supports use of the request parameter, with true indicating support.")
    public Boolean getRequestParameterSupported() {
        return this.requestParameterSupported;
    }

    public void setRequestParameterSupported(Boolean requestParameterSupported) {
        this.requestParameterSupported = requestParameterSupported;
    }

    public WellKnown requestUriParameterSupported(Boolean requestUriParameterSupported) {
        this.requestUriParameterSupported = requestUriParameterSupported;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean value specifying whether the OP supports use of the request_uri parameter, with true indicating support.")
    public Boolean getRequestUriParameterSupported() {
        return this.requestUriParameterSupported;
    }

    public void setRequestUriParameterSupported(Boolean requestUriParameterSupported) {
        this.requestUriParameterSupported = requestUriParameterSupported;
    }

    public WellKnown requireRequestUriRegistration(Boolean requireRequestUriRegistration) {
        this.requireRequestUriRegistration = requireRequestUriRegistration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean value specifying whether the OP requires any request_uri values used to be pre-registered using the request_uris registration parameter.")
    public Boolean getRequireRequestUriRegistration() {
        return this.requireRequestUriRegistration;
    }

    public void setRequireRequestUriRegistration(Boolean requireRequestUriRegistration) {
        this.requireRequestUriRegistration = requireRequestUriRegistration;
    }

    public WellKnown responseModesSupported(List<String> responseModesSupported) {
        this.responseModesSupported = responseModesSupported;
        return this;
    }

    public WellKnown addResponseModesSupportedItem(String responseModesSupportedItem) {
        if (this.responseModesSupported == null) {
            this.responseModesSupported = new ArrayList<String>();
        }
        this.responseModesSupported.add(responseModesSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="JSON array containing a list of the OAuth 2.0 response_mode values that this OP supports.")
    public List<String> getResponseModesSupported() {
        return this.responseModesSupported;
    }

    public void setResponseModesSupported(List<String> responseModesSupported) {
        this.responseModesSupported = responseModesSupported;
    }

    public WellKnown responseTypesSupported(List<String> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
        return this;
    }

    public WellKnown addResponseTypesSupportedItem(String responseTypesSupportedItem) {
        this.responseTypesSupported.add(responseTypesSupportedItem);
        return this;
    }

    @ApiModelProperty(required=true, value="JSON array containing a list of the OAuth 2.0 response_type values that this OP supports. Dynamic OpenID Providers MUST support the code, id_token, and the token id_token Response Type values.")
    public List<String> getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    public void setResponseTypesSupported(List<String> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
    }

    public WellKnown revocationEndpoint(String revocationEndpoint) {
        this.revocationEndpoint = revocationEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL of the authorization server's OAuth 2.0 revocation endpoint.")
    public String getRevocationEndpoint() {
        return this.revocationEndpoint;
    }

    public void setRevocationEndpoint(String revocationEndpoint) {
        this.revocationEndpoint = revocationEndpoint;
    }

    public WellKnown scopesSupported(List<String> scopesSupported) {
        this.scopesSupported = scopesSupported;
        return this;
    }

    public WellKnown addScopesSupportedItem(String scopesSupportedItem) {
        if (this.scopesSupported == null) {
            this.scopesSupported = new ArrayList<String>();
        }
        this.scopesSupported.add(scopesSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SON array containing a list of the OAuth 2.0 [RFC6749] scope values that this server supports. The server MUST support the openid scope value. Servers MAY choose not to advertise some supported scope values even when this parameter is used")
    public List<String> getScopesSupported() {
        return this.scopesSupported;
    }

    public void setScopesSupported(List<String> scopesSupported) {
        this.scopesSupported = scopesSupported;
    }

    public WellKnown subjectTypesSupported(List<String> subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
        return this;
    }

    public WellKnown addSubjectTypesSupportedItem(String subjectTypesSupportedItem) {
        this.subjectTypesSupported.add(subjectTypesSupportedItem);
        return this;
    }

    @ApiModelProperty(required=true, value="JSON array containing a list of the Subject Identifier types that this OP supports. Valid types include pairwise and public.")
    public List<String> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    public void setSubjectTypesSupported(List<String> subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
    }

    public WellKnown tokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    @ApiModelProperty(example="https://playground.ory.sh/ory-hydra/public/oauth2/token", required=true, value="URL of the OP's OAuth 2.0 Token Endpoint")
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public WellKnown tokenEndpointAuthMethodsSupported(List<String> tokenEndpointAuthMethodsSupported) {
        this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
        return this;
    }

    public WellKnown addTokenEndpointAuthMethodsSupportedItem(String tokenEndpointAuthMethodsSupportedItem) {
        if (this.tokenEndpointAuthMethodsSupported == null) {
            this.tokenEndpointAuthMethodsSupported = new ArrayList<String>();
        }
        this.tokenEndpointAuthMethodsSupported.add(tokenEndpointAuthMethodsSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="JSON array containing a list of Client Authentication methods supported by this Token Endpoint. The options are client_secret_post, client_secret_basic, client_secret_jwt, and private_key_jwt, as described in Section 9 of OpenID Connect Core 1.0")
    public List<String> getTokenEndpointAuthMethodsSupported() {
        return this.tokenEndpointAuthMethodsSupported;
    }

    public void setTokenEndpointAuthMethodsSupported(List<String> tokenEndpointAuthMethodsSupported) {
        this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
    }

    public WellKnown userinfoEndpoint(String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL of the OP's UserInfo Endpoint.")
    public String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public void setUserinfoEndpoint(String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
    }

    public WellKnown userinfoSigningAlgValuesSupported(List<String> userinfoSigningAlgValuesSupported) {
        this.userinfoSigningAlgValuesSupported = userinfoSigningAlgValuesSupported;
        return this;
    }

    public WellKnown addUserinfoSigningAlgValuesSupportedItem(String userinfoSigningAlgValuesSupportedItem) {
        if (this.userinfoSigningAlgValuesSupported == null) {
            this.userinfoSigningAlgValuesSupported = new ArrayList<String>();
        }
        this.userinfoSigningAlgValuesSupported.add(userinfoSigningAlgValuesSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="JSON array containing a list of the JWS [JWS] signing algorithms (alg values) [JWA] supported by the UserInfo Endpoint to encode the Claims in a JWT [JWT].")
    public List<String> getUserinfoSigningAlgValuesSupported() {
        return this.userinfoSigningAlgValuesSupported;
    }

    public void setUserinfoSigningAlgValuesSupported(List<String> userinfoSigningAlgValuesSupported) {
        this.userinfoSigningAlgValuesSupported = userinfoSigningAlgValuesSupported;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WellKnown wellKnown = (WellKnown)o;
        return Objects.equals(this.authorizationEndpoint, wellKnown.authorizationEndpoint) && Objects.equals(this.backchannelLogoutSessionSupported, wellKnown.backchannelLogoutSessionSupported) && Objects.equals(this.backchannelLogoutSupported, wellKnown.backchannelLogoutSupported) && Objects.equals(this.claimsParameterSupported, wellKnown.claimsParameterSupported) && Objects.equals(this.claimsSupported, wellKnown.claimsSupported) && Objects.equals(this.endSessionEndpoint, wellKnown.endSessionEndpoint) && Objects.equals(this.frontchannelLogoutSessionSupported, wellKnown.frontchannelLogoutSessionSupported) && Objects.equals(this.frontchannelLogoutSupported, wellKnown.frontchannelLogoutSupported) && Objects.equals(this.grantTypesSupported, wellKnown.grantTypesSupported) && Objects.equals(this.idTokenSigningAlgValuesSupported, wellKnown.idTokenSigningAlgValuesSupported) && Objects.equals(this.issuer, wellKnown.issuer) && Objects.equals(this.jwksUri, wellKnown.jwksUri) && Objects.equals(this.registrationEndpoint, wellKnown.registrationEndpoint) && Objects.equals(this.requestObjectSigningAlgValuesSupported, wellKnown.requestObjectSigningAlgValuesSupported) && Objects.equals(this.requestParameterSupported, wellKnown.requestParameterSupported) && Objects.equals(this.requestUriParameterSupported, wellKnown.requestUriParameterSupported) && Objects.equals(this.requireRequestUriRegistration, wellKnown.requireRequestUriRegistration) && Objects.equals(this.responseModesSupported, wellKnown.responseModesSupported) && Objects.equals(this.responseTypesSupported, wellKnown.responseTypesSupported) && Objects.equals(this.revocationEndpoint, wellKnown.revocationEndpoint) && Objects.equals(this.scopesSupported, wellKnown.scopesSupported) && Objects.equals(this.subjectTypesSupported, wellKnown.subjectTypesSupported) && Objects.equals(this.tokenEndpoint, wellKnown.tokenEndpoint) && Objects.equals(this.tokenEndpointAuthMethodsSupported, wellKnown.tokenEndpointAuthMethodsSupported) && Objects.equals(this.userinfoEndpoint, wellKnown.userinfoEndpoint) && Objects.equals(this.userinfoSigningAlgValuesSupported, wellKnown.userinfoSigningAlgValuesSupported);
    }

    public int hashCode() {
        return Objects.hash(this.authorizationEndpoint, this.backchannelLogoutSessionSupported, this.backchannelLogoutSupported, this.claimsParameterSupported, this.claimsSupported, this.endSessionEndpoint, this.frontchannelLogoutSessionSupported, this.frontchannelLogoutSupported, this.grantTypesSupported, this.idTokenSigningAlgValuesSupported, this.issuer, this.jwksUri, this.registrationEndpoint, this.requestObjectSigningAlgValuesSupported, this.requestParameterSupported, this.requestUriParameterSupported, this.requireRequestUriRegistration, this.responseModesSupported, this.responseTypesSupported, this.revocationEndpoint, this.scopesSupported, this.subjectTypesSupported, this.tokenEndpoint, this.tokenEndpointAuthMethodsSupported, this.userinfoEndpoint, this.userinfoSigningAlgValuesSupported);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WellKnown {\n");
        sb.append("    authorizationEndpoint: ").append(this.toIndentedString(this.authorizationEndpoint)).append("\n");
        sb.append("    backchannelLogoutSessionSupported: ").append(this.toIndentedString(this.backchannelLogoutSessionSupported)).append("\n");
        sb.append("    backchannelLogoutSupported: ").append(this.toIndentedString(this.backchannelLogoutSupported)).append("\n");
        sb.append("    claimsParameterSupported: ").append(this.toIndentedString(this.claimsParameterSupported)).append("\n");
        sb.append("    claimsSupported: ").append(this.toIndentedString(this.claimsSupported)).append("\n");
        sb.append("    endSessionEndpoint: ").append(this.toIndentedString(this.endSessionEndpoint)).append("\n");
        sb.append("    frontchannelLogoutSessionSupported: ").append(this.toIndentedString(this.frontchannelLogoutSessionSupported)).append("\n");
        sb.append("    frontchannelLogoutSupported: ").append(this.toIndentedString(this.frontchannelLogoutSupported)).append("\n");
        sb.append("    grantTypesSupported: ").append(this.toIndentedString(this.grantTypesSupported)).append("\n");
        sb.append("    idTokenSigningAlgValuesSupported: ").append(this.toIndentedString(this.idTokenSigningAlgValuesSupported)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    jwksUri: ").append(this.toIndentedString(this.jwksUri)).append("\n");
        sb.append("    registrationEndpoint: ").append(this.toIndentedString(this.registrationEndpoint)).append("\n");
        sb.append("    requestObjectSigningAlgValuesSupported: ").append(this.toIndentedString(this.requestObjectSigningAlgValuesSupported)).append("\n");
        sb.append("    requestParameterSupported: ").append(this.toIndentedString(this.requestParameterSupported)).append("\n");
        sb.append("    requestUriParameterSupported: ").append(this.toIndentedString(this.requestUriParameterSupported)).append("\n");
        sb.append("    requireRequestUriRegistration: ").append(this.toIndentedString(this.requireRequestUriRegistration)).append("\n");
        sb.append("    responseModesSupported: ").append(this.toIndentedString(this.responseModesSupported)).append("\n");
        sb.append("    responseTypesSupported: ").append(this.toIndentedString(this.responseTypesSupported)).append("\n");
        sb.append("    revocationEndpoint: ").append(this.toIndentedString(this.revocationEndpoint)).append("\n");
        sb.append("    scopesSupported: ").append(this.toIndentedString(this.scopesSupported)).append("\n");
        sb.append("    subjectTypesSupported: ").append(this.toIndentedString(this.subjectTypesSupported)).append("\n");
        sb.append("    tokenEndpoint: ").append(this.toIndentedString(this.tokenEndpoint)).append("\n");
        sb.append("    tokenEndpointAuthMethodsSupported: ").append(this.toIndentedString(this.tokenEndpointAuthMethodsSupported)).append("\n");
        sb.append("    userinfoEndpoint: ").append(this.toIndentedString(this.userinfoEndpoint)).append("\n");
        sb.append("    userinfoSigningAlgValuesSupported: ").append(this.toIndentedString(this.userinfoSigningAlgValuesSupported)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

