/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.keto.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class OryAccessControlPolicy {
    public static final String SERIALIZED_NAME_ACTIONS = "actions";
    @SerializedName(value="actions")
    private List<String> actions = null;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private Map<String, Object> conditions = null;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_EFFECT = "effect";
    @SerializedName(value="effect")
    private String effect;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private List<String> resources = null;
    public static final String SERIALIZED_NAME_SUBJECTS = "subjects";
    @SerializedName(value="subjects")
    private List<String> subjects = null;

    public OryAccessControlPolicy actions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    public OryAccessControlPolicy addActionsItem(String actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<String>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Actions is an array representing all the actions this ORY Access Policy applies to.")
    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public OryAccessControlPolicy conditions(Map<String, Object> conditions) {
        this.conditions = conditions;
        return this;
    }

    public OryAccessControlPolicy putConditionsItem(String key, Object conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new HashMap<String, Object>();
        }
        this.conditions.put(key, conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Conditions represents a keyed object of conditions under which this ORY Access Policy is active.")
    public Map<String, Object> getConditions() {
        return this.conditions;
    }

    public void setConditions(Map<String, Object> conditions) {
        this.conditions = conditions;
    }

    public OryAccessControlPolicy description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description is an optional, human-readable description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OryAccessControlPolicy effect(String effect) {
        this.effect = effect;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Effect is the effect of this ORY Access Policy. It can be \"allow\" or \"deny\".")
    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public OryAccessControlPolicy id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID is the unique identifier of the ORY Access Policy. It is used to query, update, and remove the ORY Access Policy.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OryAccessControlPolicy resources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public OryAccessControlPolicy addResourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Resources is an array representing all the resources this ORY Access Policy applies to.")
    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public OryAccessControlPolicy subjects(List<String> subjects) {
        this.subjects = subjects;
        return this;
    }

    public OryAccessControlPolicy addSubjectsItem(String subjectsItem) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<String>();
        }
        this.subjects.add(subjectsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Subjects is an array representing all the subjects this ORY Access Policy applies to.")
    public List<String> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<String> subjects) {
        this.subjects = subjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OryAccessControlPolicy oryAccessControlPolicy = (OryAccessControlPolicy)o;
        return Objects.equals(this.actions, oryAccessControlPolicy.actions) && Objects.equals(this.conditions, oryAccessControlPolicy.conditions) && Objects.equals(this.description, oryAccessControlPolicy.description) && Objects.equals(this.effect, oryAccessControlPolicy.effect) && Objects.equals(this.id, oryAccessControlPolicy.id) && Objects.equals(this.resources, oryAccessControlPolicy.resources) && Objects.equals(this.subjects, oryAccessControlPolicy.subjects);
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.conditions, this.description, this.effect, this.id, this.resources, this.subjects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OryAccessControlPolicy {\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    effect: ").append(this.toIndentedString(this.effect)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    subjects: ").append(this.toIndentedString(this.subjects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

