/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.kratos;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.GsonFireBuilder;
import io.gsonfire.TypeSelector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import okio.ByteString;
import sh.ory.kratos.model.SubmitSelfServiceLoginFlowBody;
import sh.ory.kratos.model.SubmitSelfServiceLoginFlowWithOidcMethodBody;
import sh.ory.kratos.model.SubmitSelfServiceLoginFlowWithPasswordMethodBody;
import sh.ory.kratos.model.SubmitSelfServiceRecoveryFlowBody;
import sh.ory.kratos.model.SubmitSelfServiceRecoveryFlowWithLinkMethodBody;
import sh.ory.kratos.model.SubmitSelfServiceRegistrationFlowBody;
import sh.ory.kratos.model.SubmitSelfServiceRegistrationFlowWithOidcMethodBody;
import sh.ory.kratos.model.SubmitSelfServiceRegistrationFlowWithPasswordMethodBody;
import sh.ory.kratos.model.SubmitSelfServiceSettingsFlowBody;
import sh.ory.kratos.model.SubmitSelfServiceSettingsFlowWithOidcMethodBody;
import sh.ory.kratos.model.SubmitSelfServiceSettingsFlowWithPasswordMethodBody;
import sh.ory.kratos.model.SubmitSelfServiceSettingsFlowWithProfileMethodBody;
import sh.ory.kratos.model.SubmitSelfServiceVerificationFlowBody;
import sh.ory.kratos.model.SubmitSelfServiceVerificationFlowWithLinkMethodBody;

public class JSON {
    private Gson gson;
    private boolean isLenientOnJson = false;
    private DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
    private SqlDateTypeAdapter sqlDateTypeAdapter = new SqlDateTypeAdapter();
    private OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
    private LocalDateTypeAdapter localDateTypeAdapter = new LocalDateTypeAdapter();
    private ByteArrayAdapter byteArrayAdapter = new ByteArrayAdapter();

    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder().registerTypeSelector(SubmitSelfServiceLoginFlowBody.class, (TypeSelector)new TypeSelector<SubmitSelfServiceLoginFlowBody>(){

            public Class<? extends SubmitSelfServiceLoginFlowBody> getClassForElement(JsonElement readElement) {
                HashMap<String, Class<SubmitSelfServiceLoginFlowBody>> classByDiscriminatorValue = new HashMap<String, Class<SubmitSelfServiceLoginFlowBody>>();
                classByDiscriminatorValue.put("oidc", SubmitSelfServiceLoginFlowWithOidcMethodBody.class);
                classByDiscriminatorValue.put("password", SubmitSelfServiceLoginFlowWithPasswordMethodBody.class);
                classByDiscriminatorValue.put("submitSelfServiceLoginFlowWithOidcMethodBody", SubmitSelfServiceLoginFlowWithOidcMethodBody.class);
                classByDiscriminatorValue.put("submitSelfServiceLoginFlowWithPasswordMethodBody", SubmitSelfServiceLoginFlowWithPasswordMethodBody.class);
                classByDiscriminatorValue.put("submitSelfServiceLoginFlowBody", SubmitSelfServiceLoginFlowBody.class);
                return JSON.getClassByDiscriminator(classByDiscriminatorValue, JSON.getDiscriminatorValue(readElement, "method"));
            }
        }).registerTypeSelector(SubmitSelfServiceRecoveryFlowBody.class, (TypeSelector)new TypeSelector<SubmitSelfServiceRecoveryFlowBody>(){

            public Class<? extends SubmitSelfServiceRecoveryFlowBody> getClassForElement(JsonElement readElement) {
                HashMap<String, Class> classByDiscriminatorValue = new HashMap<String, Class>();
                classByDiscriminatorValue.put("link", SubmitSelfServiceRecoveryFlowWithLinkMethodBody.class);
                classByDiscriminatorValue.put("submitSelfServiceRecoveryFlowWithLinkMethodBody", SubmitSelfServiceRecoveryFlowWithLinkMethodBody.class);
                classByDiscriminatorValue.put("submitSelfServiceRecoveryFlowBody", SubmitSelfServiceRecoveryFlowBody.class);
                return JSON.getClassByDiscriminator(classByDiscriminatorValue, JSON.getDiscriminatorValue(readElement, "method"));
            }
        }).registerTypeSelector(SubmitSelfServiceRegistrationFlowBody.class, (TypeSelector)new TypeSelector<SubmitSelfServiceRegistrationFlowBody>(){

            public Class<? extends SubmitSelfServiceRegistrationFlowBody> getClassForElement(JsonElement readElement) {
                HashMap<String, Class<SubmitSelfServiceRegistrationFlowBody>> classByDiscriminatorValue = new HashMap<String, Class<SubmitSelfServiceRegistrationFlowBody>>();
                classByDiscriminatorValue.put("oidc", SubmitSelfServiceRegistrationFlowWithOidcMethodBody.class);
                classByDiscriminatorValue.put("password", SubmitSelfServiceRegistrationFlowWithPasswordMethodBody.class);
                classByDiscriminatorValue.put("submitSelfServiceRegistrationFlowWithOidcMethodBody", SubmitSelfServiceRegistrationFlowWithOidcMethodBody.class);
                classByDiscriminatorValue.put("submitSelfServiceRegistrationFlowWithPasswordMethodBody", SubmitSelfServiceRegistrationFlowWithPasswordMethodBody.class);
                classByDiscriminatorValue.put("submitSelfServiceRegistrationFlowBody", SubmitSelfServiceRegistrationFlowBody.class);
                return JSON.getClassByDiscriminator(classByDiscriminatorValue, JSON.getDiscriminatorValue(readElement, "method"));
            }
        }).registerTypeSelector(SubmitSelfServiceSettingsFlowBody.class, (TypeSelector)new TypeSelector<SubmitSelfServiceSettingsFlowBody>(){

            public Class<? extends SubmitSelfServiceSettingsFlowBody> getClassForElement(JsonElement readElement) {
                HashMap<String, Class<SubmitSelfServiceSettingsFlowBody>> classByDiscriminatorValue = new HashMap<String, Class<SubmitSelfServiceSettingsFlowBody>>();
                classByDiscriminatorValue.put("oidc", SubmitSelfServiceSettingsFlowWithOidcMethodBody.class);
                classByDiscriminatorValue.put("password", SubmitSelfServiceSettingsFlowWithPasswordMethodBody.class);
                classByDiscriminatorValue.put("profile", SubmitSelfServiceSettingsFlowWithProfileMethodBody.class);
                classByDiscriminatorValue.put("submitSelfServiceSettingsFlowWithOidcMethodBody", SubmitSelfServiceSettingsFlowWithOidcMethodBody.class);
                classByDiscriminatorValue.put("submitSelfServiceSettingsFlowWithPasswordMethodBody", SubmitSelfServiceSettingsFlowWithPasswordMethodBody.class);
                classByDiscriminatorValue.put("submitSelfServiceSettingsFlowWithProfileMethodBody", SubmitSelfServiceSettingsFlowWithProfileMethodBody.class);
                classByDiscriminatorValue.put("submitSelfServiceSettingsFlowBody", SubmitSelfServiceSettingsFlowBody.class);
                return JSON.getClassByDiscriminator(classByDiscriminatorValue, JSON.getDiscriminatorValue(readElement, "method"));
            }
        }).registerTypeSelector(SubmitSelfServiceVerificationFlowBody.class, (TypeSelector)new TypeSelector<SubmitSelfServiceVerificationFlowBody>(){

            public Class<? extends SubmitSelfServiceVerificationFlowBody> getClassForElement(JsonElement readElement) {
                HashMap<String, Class> classByDiscriminatorValue = new HashMap<String, Class>();
                classByDiscriminatorValue.put("link", SubmitSelfServiceVerificationFlowWithLinkMethodBody.class);
                classByDiscriminatorValue.put("submitSelfServiceVerificationFlowWithLinkMethodBody", SubmitSelfServiceVerificationFlowWithLinkMethodBody.class);
                classByDiscriminatorValue.put("submitSelfServiceVerificationFlowBody", SubmitSelfServiceVerificationFlowBody.class);
                return JSON.getClassByDiscriminator(classByDiscriminatorValue, JSON.getDiscriminatorValue(readElement, "method"));
            }
        });
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class)classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    public JSON() {
        this.gson = JSON.createGson().registerTypeAdapter(java.util.Date.class, (Object)this.dateTypeAdapter).registerTypeAdapter(Date.class, (Object)this.sqlDateTypeAdapter).registerTypeAdapter(OffsetDateTime.class, (Object)this.offsetDateTimeTypeAdapter).registerTypeAdapter(LocalDate.class, (Object)this.localDateTypeAdapter).registerTypeAdapter(byte[].class, (Object)this.byteArrayAdapter).create();
    }

    public Gson getGson() {
        return this.gson;
    }

    public JSON setGson(Gson gson) {
        this.gson = gson;
        return this;
    }

    public JSON setLenientOnJson(boolean lenientOnJson) {
        this.isLenientOnJson = lenientOnJson;
        return this;
    }

    public String serialize(Object obj) {
        return this.gson.toJson(obj);
    }

    public <T> T deserialize(String body, Type returnType) {
        try {
            if (this.isLenientOnJson) {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(body));
                jsonReader.setLenient(true);
                return (T)this.gson.fromJson(jsonReader, returnType);
            }
            return (T)this.gson.fromJson(body, returnType);
        }
        catch (JsonParseException e) {
            if (returnType.equals(String.class)) {
                return (T)body;
            }
            throw e;
        }
    }

    public JSON setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        this.offsetDateTimeTypeAdapter.setFormat(dateFormat);
        return this;
    }

    public JSON setLocalDateFormat(DateTimeFormatter dateFormat) {
        this.localDateTypeAdapter.setFormat(dateFormat);
        return this;
    }

    public JSON setDateFormat(DateFormat dateFormat) {
        this.dateTypeAdapter.setFormat(dateFormat);
        return this;
    }

    public JSON setSqlDateFormat(DateFormat dateFormat) {
        this.sqlDateTypeAdapter.setFormat(dateFormat);
        return this;
    }

    public static class DateTypeAdapter
    extends TypeAdapter<java.util.Date> {
        private DateFormat dateFormat;

        public DateTypeAdapter() {
        }

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void write(JsonWriter out, java.util.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : ISO8601Utils.format((java.util.Date)date, (boolean)true);
                out.value(value);
            }
        }

        public java.util.Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL: {
                        in.nextNull();
                        return null;
                    }
                }
                String date = in.nextString();
                try {
                    if (this.dateFormat != null) {
                        return this.dateFormat.parse(date);
                    }
                    return ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0));
                }
                catch (ParseException e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class SqlDateTypeAdapter
    extends TypeAdapter<Date> {
        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {
        }

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : date.toString();
                out.value(value);
            }
        }

        public Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            try {
                if (this.dateFormat != null) {
                    return new Date(this.dateFormat.parse(date).getTime());
                }
                return new Date(ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0)).getTime());
            }
            catch (ParseException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class OffsetDateTimeTypeAdapter
    extends TypeAdapter<OffsetDateTime> {
        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            if (date.endsWith("+0000")) {
                date = date.substring(0, date.length() - 5) + "Z";
            }
            return OffsetDateTime.parse(date, this.formatter);
        }
    }

    public class LocalDateTypeAdapter
    extends TypeAdapter<LocalDate> {
        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            return LocalDate.parse(date, this.formatter);
        }
    }

    public class ByteArrayAdapter
    extends TypeAdapter<byte[]> {
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(ByteString.of((byte[])value).base64());
            }
        }

        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String bytesAsBase64 = in.nextString();
            ByteString byteString = ByteString.decodeBase64((String)bytesAsBase64);
            return byteString.toByteArray();
        }
    }
}

