/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.kratos.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GenericError {
    public static final String SERIALIZED_NAME_CODE = "code";
    @SerializedName(value="code")
    private Long code;
    public static final String SERIALIZED_NAME_DEBUG = "debug";
    @SerializedName(value="debug")
    private String debug;
    public static final String SERIALIZED_NAME_DETAILS = "details";
    @SerializedName(value="details")
    private Object details;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_REQUEST = "request";
    @SerializedName(value="request")
    private String request;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;

    public GenericError code(Long code) {
        this.code = code;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="404", value="The status code")
    public Long getCode() {
        return this.code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public GenericError debug(String debug) {
        this.debug = debug;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="SQL field \"foo\" is not a bool.", value="Debug information  This field is often not exposed to protect against leaking sensitive information.")
    public String getDebug() {
        return this.debug;
    }

    public void setDebug(String debug) {
        this.debug = debug;
    }

    public GenericError details(Object details) {
        this.details = details;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Further error details")
    public Object getDetails() {
        return this.details;
    }

    public void setDetails(Object details) {
        this.details = details;
    }

    public GenericError message(String message) {
        this.message = message;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="The resource could not be found", required=true, value="Error message  The error's message.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public GenericError reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="User with ID 1234 does not exist.", value="A human-readable reason for the error")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public GenericError request(String request) {
        this.request = request;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="d7ef54b1-ec15-46e6-bccb-524b82c035e6", value="The request ID  The request ID is often exposed internally in order to trace errors across service architectures. This is often a UUID.")
    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public GenericError status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Not Found", value="The status description")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericError genericError = (GenericError)o;
        return Objects.equals(this.code, genericError.code) && Objects.equals(this.debug, genericError.debug) && Objects.equals(this.details, genericError.details) && Objects.equals(this.message, genericError.message) && Objects.equals(this.reason, genericError.reason) && Objects.equals(this.request, genericError.request) && Objects.equals(this.status, genericError.status);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.debug, this.details, this.message, this.reason, this.request, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GenericError {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    debug: ").append(this.toIndentedString(this.debug)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

