/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.kratos.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sh.ory.kratos.model.IdentityCredentials;
import sh.ory.kratos.model.IdentityState;
import sh.ory.kratos.model.RecoveryAddress;
import sh.ory.kratos.model.VerifiableIdentityAddress;

@ApiModel(description="An identity can be a real human, a service, an IoT device - everything that can be described as an \"actor\" in a system.")
public class Identity {
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_CREDENTIALS = "credentials";
    @SerializedName(value="credentials")
    private Map<String, IdentityCredentials> credentials = null;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_RECOVERY_ADDRESSES = "recovery_addresses";
    @SerializedName(value="recovery_addresses")
    private List<RecoveryAddress> recoveryAddresses = null;
    public static final String SERIALIZED_NAME_SCHEMA_ID = "schema_id";
    @SerializedName(value="schema_id")
    private String schemaId;
    public static final String SERIALIZED_NAME_SCHEMA_URL = "schema_url";
    @SerializedName(value="schema_url")
    private String schemaUrl;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private IdentityState state;
    public static final String SERIALIZED_NAME_STATE_CHANGED_AT = "state_changed_at";
    @SerializedName(value="state_changed_at")
    private OffsetDateTime stateChangedAt;
    public static final String SERIALIZED_NAME_TRAITS = "traits";
    @SerializedName(value="traits")
    private Object traits = null;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_VERIFIABLE_ADDRESSES = "verifiable_addresses";
    @SerializedName(value="verifiable_addresses")
    private List<VerifiableIdentityAddress> verifiableAddresses = null;

    public Identity createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CreatedAt is a helper struct field for gobuffalo.pop.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Identity credentials(Map<String, IdentityCredentials> credentials) {
        this.credentials = credentials;
        return this;
    }

    public Identity putCredentialsItem(String key, IdentityCredentials credentialsItem) {
        if (this.credentials == null) {
            this.credentials = new HashMap<String, IdentityCredentials>();
        }
        this.credentials.put(key, credentialsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Credentials represents all credentials that can be used for authenticating this identity.")
    public Map<String, IdentityCredentials> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Map<String, IdentityCredentials> credentials) {
        this.credentials = credentials;
    }

    public Identity id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Identity recoveryAddresses(List<RecoveryAddress> recoveryAddresses) {
        this.recoveryAddresses = recoveryAddresses;
        return this;
    }

    public Identity addRecoveryAddressesItem(RecoveryAddress recoveryAddressesItem) {
        if (this.recoveryAddresses == null) {
            this.recoveryAddresses = new ArrayList<RecoveryAddress>();
        }
        this.recoveryAddresses.add(recoveryAddressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RecoveryAddresses contains all the addresses that can be used to recover an identity.")
    public List<RecoveryAddress> getRecoveryAddresses() {
        return this.recoveryAddresses;
    }

    public void setRecoveryAddresses(List<RecoveryAddress> recoveryAddresses) {
        this.recoveryAddresses = recoveryAddresses;
    }

    public Identity schemaId(String schemaId) {
        this.schemaId = schemaId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="SchemaID is the ID of the JSON Schema to be used for validating the identity's traits.")
    public String getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public Identity schemaUrl(String schemaUrl) {
        this.schemaUrl = schemaUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="SchemaURL is the URL of the endpoint where the identity's traits schema can be fetched from.  format: url")
    public String getSchemaUrl() {
        return this.schemaUrl;
    }

    public void setSchemaUrl(String schemaUrl) {
        this.schemaUrl = schemaUrl;
    }

    public Identity state(IdentityState state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public IdentityState getState() {
        return this.state;
    }

    public void setState(IdentityState state) {
        this.state = state;
    }

    public Identity stateChangedAt(OffsetDateTime stateChangedAt) {
        this.stateChangedAt = stateChangedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OffsetDateTime getStateChangedAt() {
        return this.stateChangedAt;
    }

    public void setStateChangedAt(OffsetDateTime stateChangedAt) {
        this.stateChangedAt = stateChangedAt;
    }

    public Identity traits(Object traits) {
        this.traits = traits;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Traits represent an identity's traits. The identity is able to create, modify, and delete traits in a self-service manner. The input will always be validated against the JSON Schema defined in `schema_url`.")
    public Object getTraits() {
        return this.traits;
    }

    public void setTraits(Object traits) {
        this.traits = traits;
    }

    public Identity updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UpdatedAt is a helper struct field for gobuffalo.pop.")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Identity verifiableAddresses(List<VerifiableIdentityAddress> verifiableAddresses) {
        this.verifiableAddresses = verifiableAddresses;
        return this;
    }

    public Identity addVerifiableAddressesItem(VerifiableIdentityAddress verifiableAddressesItem) {
        if (this.verifiableAddresses == null) {
            this.verifiableAddresses = new ArrayList<VerifiableIdentityAddress>();
        }
        this.verifiableAddresses.add(verifiableAddressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VerifiableAddresses contains all the addresses that can be verified by the user.")
    public List<VerifiableIdentityAddress> getVerifiableAddresses() {
        return this.verifiableAddresses;
    }

    public void setVerifiableAddresses(List<VerifiableIdentityAddress> verifiableAddresses) {
        this.verifiableAddresses = verifiableAddresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identity identity = (Identity)o;
        return Objects.equals(this.createdAt, identity.createdAt) && Objects.equals(this.credentials, identity.credentials) && Objects.equals(this.id, identity.id) && Objects.equals(this.recoveryAddresses, identity.recoveryAddresses) && Objects.equals(this.schemaId, identity.schemaId) && Objects.equals(this.schemaUrl, identity.schemaUrl) && Objects.equals((Object)this.state, (Object)identity.state) && Objects.equals(this.stateChangedAt, identity.stateChangedAt) && Objects.equals(this.traits, identity.traits) && Objects.equals(this.updatedAt, identity.updatedAt) && Objects.equals(this.verifiableAddresses, identity.verifiableAddresses);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.credentials, this.id, this.recoveryAddresses, this.schemaId, this.schemaUrl, this.state, this.stateChangedAt, this.traits, this.updatedAt, this.verifiableAddresses});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Identity {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    recoveryAddresses: ").append(this.toIndentedString(this.recoveryAddresses)).append("\n");
        sb.append("    schemaId: ").append(this.toIndentedString(this.schemaId)).append("\n");
        sb.append("    schemaUrl: ").append(this.toIndentedString(this.schemaUrl)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    stateChangedAt: ").append(this.toIndentedString(this.stateChangedAt)).append("\n");
        sb.append("    traits: ").append(this.toIndentedString(this.traits)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    verifiableAddresses: ").append(this.toIndentedString(this.verifiableAddresses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

