/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.kratos.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sh.ory.kratos.model.UiContainer;

public class SelfServiceRegistrationFlow {
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private String active;
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expires_at";
    @SerializedName(value="expires_at")
    private OffsetDateTime expiresAt;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_ISSUED_AT = "issued_at";
    @SerializedName(value="issued_at")
    private OffsetDateTime issuedAt;
    public static final String SERIALIZED_NAME_REQUEST_URL = "request_url";
    @SerializedName(value="request_url")
    private String requestUrl;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_UI = "ui";
    @SerializedName(value="ui")
    private UiContainer ui;

    public SelfServiceRegistrationFlow active(String active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="and so on.")
    public String getActive() {
        return this.active;
    }

    public void setActive(String active) {
        this.active = active;
    }

    public SelfServiceRegistrationFlow expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ExpiresAt is the time (UTC) when the flow expires. If the user still wishes to log in, a new flow has to be initiated.")
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public SelfServiceRegistrationFlow id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public SelfServiceRegistrationFlow issuedAt(OffsetDateTime issuedAt) {
        this.issuedAt = issuedAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="IssuedAt is the time (UTC) when the flow occurred.")
    public OffsetDateTime getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(OffsetDateTime issuedAt) {
        this.issuedAt = issuedAt;
    }

    public SelfServiceRegistrationFlow requestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="RequestURL is the initial URL that was requested from Ory Kratos. It can be used to forward information contained in the URL's path or query for example.")
    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public SelfServiceRegistrationFlow type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The flow type can either be `api` or `browser`.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SelfServiceRegistrationFlow ui(UiContainer ui) {
        this.ui = ui;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public UiContainer getUi() {
        return this.ui;
    }

    public void setUi(UiContainer ui) {
        this.ui = ui;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelfServiceRegistrationFlow selfServiceRegistrationFlow = (SelfServiceRegistrationFlow)o;
        return Objects.equals(this.active, selfServiceRegistrationFlow.active) && Objects.equals(this.expiresAt, selfServiceRegistrationFlow.expiresAt) && Objects.equals(this.id, selfServiceRegistrationFlow.id) && Objects.equals(this.issuedAt, selfServiceRegistrationFlow.issuedAt) && Objects.equals(this.requestUrl, selfServiceRegistrationFlow.requestUrl) && Objects.equals(this.type, selfServiceRegistrationFlow.type) && Objects.equals(this.ui, selfServiceRegistrationFlow.ui);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.expiresAt, this.id, this.issuedAt, this.requestUrl, this.type, this.ui);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SelfServiceRegistrationFlow {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    issuedAt: ").append(this.toIndentedString(this.issuedAt)).append("\n");
        sb.append("    requestUrl: ").append(this.toIndentedString(this.requestUrl)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    ui: ").append(this.toIndentedString(this.ui)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

