/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.kratos.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sh.ory.kratos.model.Identity;

@ApiModel(description="A Session")
public class Session {
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_AUTHENTICATED_AT = "authenticated_at";
    @SerializedName(value="authenticated_at")
    private OffsetDateTime authenticatedAt;
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expires_at";
    @SerializedName(value="expires_at")
    private OffsetDateTime expiresAt;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_IDENTITY = "identity";
    @SerializedName(value="identity")
    private Identity identity;
    public static final String SERIALIZED_NAME_ISSUED_AT = "issued_at";
    @SerializedName(value="issued_at")
    private OffsetDateTime issuedAt;

    public Session active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the session is active.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Session authenticatedAt(OffsetDateTime authenticatedAt) {
        this.authenticatedAt = authenticatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Session Authentication Timestamp  When this session was authenticated at.")
    public OffsetDateTime getAuthenticatedAt() {
        return this.authenticatedAt;
    }

    public void setAuthenticatedAt(OffsetDateTime authenticatedAt) {
        this.authenticatedAt = authenticatedAt;
    }

    public Session expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Session Expiry  When this session expires at.")
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public Session id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Session identity(Identity identity) {
        this.identity = identity;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Identity getIdentity() {
        return this.identity;
    }

    public void setIdentity(Identity identity) {
        this.identity = identity;
    }

    public Session issuedAt(OffsetDateTime issuedAt) {
        this.issuedAt = issuedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Session Issuance Timestamp  When this session was authenticated at.")
    public OffsetDateTime getIssuedAt() {
        return this.issuedAt;
    }

    public void setIssuedAt(OffsetDateTime issuedAt) {
        this.issuedAt = issuedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        return Objects.equals(this.active, session.active) && Objects.equals(this.authenticatedAt, session.authenticatedAt) && Objects.equals(this.expiresAt, session.expiresAt) && Objects.equals(this.id, session.id) && Objects.equals(this.identity, session.identity) && Objects.equals(this.issuedAt, session.issuedAt);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.authenticatedAt, this.expiresAt, this.id, this.identity, this.issuedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Session {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    authenticatedAt: ").append(this.toIndentedString(this.authenticatedAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    identity: ").append(this.toIndentedString(this.identity)).append("\n");
        sb.append("    issuedAt: ").append(this.toIndentedString(this.issuedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

