/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.kratos.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import sh.ory.kratos.model.Meta;
import sh.ory.kratos.model.UiNodeAttributes;
import sh.ory.kratos.model.UiText;

@ApiModel(description="Nodes are represented as HTML elements or their native UI equivalents. For example, a node can be an `<img>` tag, or an `<input element>` but also `some plain text`.")
public class UiNode {
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private UiNodeAttributes attributes;
    public static final String SERIALIZED_NAME_GROUP = "group";
    @SerializedName(value="group")
    private String group;
    public static final String SERIALIZED_NAME_MESSAGES = "messages";
    @SerializedName(value="messages")
    private List<UiText> messages = new ArrayList<UiText>();
    public static final String SERIALIZED_NAME_META = "meta";
    @SerializedName(value="meta")
    private Meta meta;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public UiNode attributes(UiNodeAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public UiNodeAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(UiNodeAttributes attributes) {
        this.attributes = attributes;
    }

    public UiNode group(String group) {
        this.group = group;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public UiNode messages(List<UiText> messages) {
        this.messages = messages;
        return this;
    }

    public UiNode addMessagesItem(UiText messagesItem) {
        this.messages.add(messagesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public List<UiText> getMessages() {
        return this.messages;
    }

    public void setMessages(List<UiText> messages) {
        this.messages = messages;
    }

    public UiNode meta(Meta meta) {
        this.meta = meta;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public UiNode type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UiNode uiNode = (UiNode)o;
        return Objects.equals(this.attributes, uiNode.attributes) && Objects.equals(this.group, uiNode.group) && Objects.equals(this.messages, uiNode.messages) && Objects.equals(this.meta, uiNode.meta) && Objects.equals(this.type, uiNode.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.group, this.messages, this.meta, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UiNode {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    messages: ").append(this.toIndentedString(this.messages)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

